/*
 * Copyright 2008 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.codenarc.results

/**
 * Represents the results of applying rules to one or more source files/directories
 *
 * @author Chris Mair
 * @version $Revision: 7 $ - $Date: 2009-01-21 21:52:00 -0500 (Wed, 21 Jan 2009) $
 */
interface Results {

    /**
     * @return the path to the file or directory associated with these results
     */
    String getPath()

    /**
     * @return the List of child Results objects; may be empty
     */
    List getChildren()

    /**
     * Return the List of violations with the specified priority
     * @param priority - the priority
     * @return the List of violations with the specified priority; may be empty
     */
    List getViolationsWithPriority(int priority)

    /**
     * Return the number of violations with the specified priority
     * @param priority - the priority
     * @param recursive - true if the returned count should include subdirectories as well
     * @return the number of violations with the specified priority
     */
    int getNumberOfViolationsWithPriority(int priority, boolean recursive)

    /**
     * Return the total number of (Groovy) files analyzed 
     * @param recursive - true if the returned count should include subdirectories as well
     * @return the total number of files (with or without violations)
     */
    int getTotalNumberOfFiles(boolean recursive)

    /**
     * Return the number of files with violations
     * @param recursive - true if the returned count should include subdirectories as well
     * @return the number of files containing violations
     */
    int getNumberOfFilesWithViolations(boolean recursive)

    /**
     * @return true only if this object represents the results for a single file
     */
    boolean isFile()

    /**
     * Return the Results object with the specified path within this results object or its descendents.
     * @param path - the path to search for
     * @return this Results object if a match is found, otherwise null
     */
    Results findResultsForPath(String path)
}