/***********************************************************************
 *               Copyright (C) 1995 Joe English
 *                   Freely redistributable
 ***********************************************************************
 *
 * esis.h,v 1.27 1999/06/26 01:32:43 joe Exp
 *
 * Author: 	Joe English
 * Created:  	Jan 1995
 * Description:	Public declarations for libesis.
 */

#ifndef ESIS_H
#define ESIS_H 1

typedef const char *ESISToken;	/* interned name */
typedef char *ESISData;		/* character data content */
typedef char *ESISString;	/* dynamically allocated strings */
typedef struct ESISNodeRec *ESISNode, ESISNodeRec;
typedef struct ESISDocumentRec *ESISDocument;
typedef struct ESISInputStreamRec *ESISInputStream, ESISInputStreamRec;
typedef struct ESISBuilderRec *ESISBuilder, ESISBuilderRec;

/* 
 * Node types:
 */
typedef enum
{
    EN_SD,		/* SGML document or subdocument */
    EN_EL,		/* element */
    EN_PEL,		/* data (HyTime pseudo-element) */
	EN_CDATA,		/* character data */
	EN_SDATA,		/* system data */
	EN_RE,    		/* record end */
	EN_REFERENCE,		/* data entity reference */
    EN_PI,		/* processing instruction */
    EN_AT,		/* attribute */
    EN_ENTITY,		/* entity definition */
    /* ... non-ESIS node types: */
    EN_RELATION,
    EN_ILINK,
    EN_LINKEND,
    EN_ERROR		/* bad node type */
} ESISNodeType;

/*
 * Events:
 */
typedef enum ESISEventType 	
{
    EV_EOF,	/* end of document */
    EV_START,	/* start-tag */
    EV_END,	/* end-tag */
    EV_PI,	/* processing instruction */
    EV_CDATA,	/* character data */
    EV_SDATA,	/* system data (entity text) */
    EV_RE,	/* record end */
    EV_DATAENT,	/* data entity reference or entity */
    EV_SDSTART,	/* subdocument start */
    EV_SDEND,	/* subducoment end */
    EV_ERROR,	/* error event (not used) */

    ESISEventTypeMax	/* Must be last */

} ESISEventType;

typedef int (*ESISEventHandler)
		(ESISEventType ev, ESISNode node, void *closure);
extern int esis_traverse(ESISNode, ESISEventHandler, void *closure);

/* Input streams:
*/
typedef int (*ESISIOproc)(void *closure, char *buf, int n);
extern int ESISIOstdio(/* FILE */ void *, char *, int);

extern ESISInputStream	estream_create		(ESISIOproc, void *closure);
extern void		estream_close		(ESISInputStream);
extern ESISDocument	estream_load_sgmls	(ESISInputStream);

/* Documents:
*/
extern ESISNode		esis_rootnode	(ESISDocument);
extern void		esis_free_document(ESISDocument);
extern void		esis_set_docname(ESISDocument, const char *);
extern ESISToken	esis_docname(ESISDocument);

/* Node inquiry routines:
 */
extern ESISNodeType	esis_nodetype	(ESISNode);
extern ESISToken	esis_gi		(ESISNode);
extern ESISToken	esis_ename	(ESISNode);	/* entity name */
extern ESISString	esis_sysid	(ESISNode);	/* system identifier */
extern ESISString	esis_pubid	(ESISNode);	/* public identifier */
extern ESISString	esis_dcn	(ESISNode);	/* data content ntn */
	/* %%% DCN ESISToken? */
extern ESISString	esis_text	(ESISNode);
	/* Returns: content of CDATA, SDATA, RE, PI, AT nodes */

extern int		esis_hasprop	(ESISNode, const char *propname);
extern ESISString	esis_getprop	(ESISNode, const char *propname);
extern void 		esis_setprop	
			(ESISNode, const char *propname, const char *propval);
extern void 		esis_unsetprop	(ESISNode, const char *propname);

extern ESISNode		esis_findatt	(ESISNode, const char *attname);
extern int 		esis_hasatt	(ESISNode, const char *attname);
extern ESISString 	esis_attval	(ESISNode, const char *attname);
extern ESISNode		esis_firstatt	(ESISNode);
extern ESISNode		esis_nextatt	(ESISNode);
extern ESISToken 	esis_attname	(ESISNode);

extern ESISNode 	esis_docroot	(ESISNode);
extern ESISNode 	esis_parent	(ESISNode);
extern ESISNode 	esis_nextsib	(ESISNode);
extern ESISNode 	esis_prevsib	(ESISNode);
extern ESISNode 	esis_firstchild	(ESISNode);
extern ESISNode 	esis_entity	(ESISNode, const char *ename);

extern int		esis_depth	(ESISNode);
extern int		esis_seqno	(ESISNode);

/* HyTime-like stuff:
*/
extern ESISNode		esis_treeloc	(ESISNode root, const char *marklist);
typedef union 
{
    long marklist[4];
    struct {
	long pathno;
	long width;
	long depth;
	long height;
    } p;
} ESISPathlocAddr;

extern int		esis_docpos	(ESISNode, ESISPathlocAddr *);
extern ESISNode		esis_stepdown	(ESISNode, ESISPathlocAddr *);
extern ESISNode		esis_locate	(ESISNode, ESISPathlocAddr *);

/* traversal iterators
*/
extern ESISNode		esis_firstpreorder	(ESISNode);
extern ESISNode		esis_nextpreorder	(ESISNode, ESISNode);

extern ESISNode		esis_lastpreorder	(ESISNode);
extern ESISNode		esis_prevpreorder	(ESISNode, ESISNode);

/* Ilinks and relations:
*/
extern int esis_define_relation
	(ESISDocument,ESISToken relname,int nanchors,char **anchnames);
extern ESISNode esis_create_ilink
	(ESISDocument, ESISToken relname, ESISNode origin);
extern int esis_set_linkend
	(ESISNode ilinkNode, ESISToken anchname, ESISNode anchnode);
extern ESISNode esis_relation_first(ESISNode, ESISToken relname);
extern ESISNode esis_relation_next(ESISNode ilink);
extern ESISNode esis_first_ilink
	(ESISNode origin, ESISToken relname, ESISToken anchname);
extern ESISNode esis_next_ilink
	(ESISNode origin,ESISToken relname,ESISToken anchname,ESISNode ilink);
extern ESISNode esis_ilink_anchor(ESISNode ilink, ESISToken anchname);
extern ESISNode esis_ilink_origin(ESISNode ilink);

/* Miscellaneous...
 */
extern const char *esis_nodetype_name(ESISNodeType);
extern ESISNodeType esis_string_to_nodetype(const char *);

extern const char *esis_evtype_name(ESISEventType);
extern ESISEventType esis_string_to_evtype(const char *);

#endif /* ESIS_H */
