/***************************************************************************
                          bildchenptr.h  -  description
                             -------------------
    begin                : Mon May 28 2001
    copyright            : (C) 2001 by Immi
    email                : cuyo@karimmi.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef BILDCHENPTR_H
#define BILDCHENPTR_H

#include "inkompatibel.h"

#define verwandlung_keine 0
#define verwandlung_weg 1		// fr's Feuer
#define verwandlung_verbrenne 2 // Auch fr's Feuer: Der Stein unterm Feuer wird grau
#define verwandlung_version 3 // Fr normale Blops: Version wechseln
#define verwandlung_sorte 4 // Fr normale Blops: Ganz andere Sorte werden

/* Fr mTuSo */
#define verkleidung_keine -1

/**
 * Gibt die Nummer einer Bilddatei und die Position darin an.
 * Und evtl. noch ein paar Informationen, die vor allem innerhalb
 * von Animationssequenzen wichtig sind.
 * @author Immi
 */

class BildchenPtr {
 public: 
  BildchenPtr(int d = 0, char p = 0, bool dr = true):
    mDatei(d), mPos(p), mDrueberMalen(dr),
    mZuendX(0), mZuendY(0), mFeuerVerbindbar(false),
    mVerwandlung(verwandlung_keine),
    mHaeufigkeit(1), mVerkleidung(verkleidung_keine)
    {}
		
  /** Liefert true, wenn's kein Null-Pointer ist */
  operator bool() const {return mPos != 0;}

  /** Liefert true, wenn bp gleich aussieht. D. h. beim Wechsel zu (oder von)
      bp muss nicht neu gezeichnet werden. Ist nur fr Animations-BlichenPtr
      gedacht. */
  bool siehtGleichAus(const BildchenPtr & bp) {
    return mDatei == bp.mDatei &&
      mPos == bp.mPos &&
      mDrueberMalen == bp.mDrueberMalen;
  }
	
  int mDatei;
  char mPos;
	
  /* Variablen, die nur innerhalb von Animationssequenzen gebraucht werden */
  /** Soll das Bild ber das Originalbild gemalt werden? */
  bool mDrueberMalen;
  /** Welches Feld wird von diesem angezndet (relativ; 0,0 = nix) */
  int mZuendX, mZuendY;
  /** True, wenn Feuer sich auch mit diesem Blop verbindet, wenn es nicht brennt */
  bool mFeuerVerbindbar;
  /** Wie verwandelt sich das Blop an dieser Stelle der Animation? */
  int mVerwandlung;
  /** Wenn die Verwandlung noch einen Parameter hat (z. B. Versionsnummer) */
  int mVerwandlungParam;
	
  /* Variablen, die nur bei Versionen gebraucht werden */
  /** (Relative) Hufigkeit, mit der diese Version (zufllig) ausgewhlt wird */
  int mHaeufigkeit;
  /** Blop tut so, als sei er ein anderer (bei verkleidung_keine nicht) */
  int mVerkleidung;
};

#endif
