/***************************************************************************
                          blopbesitzer.h  -  description
                             -------------------
    begin                : Sat Jul 14 2001
    copyright            : (C) 2001 by Immi
    email                : cuyo@karimmi.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef BLOPBESITZER_H
#define BLOPBESITZER_H

#include "inkompatibel.h"


/* Rckgabewerte von getVerbindungen(). Achtung: Wenn diese Konstanten
   gendert werden, muss auch Sorte::malMitVerbindungen gendert werden */
#define verbindung_rechts 0x0001
#define verbindung_links  0x0002
#define verbindung_unten  0x0004
#define verbindung_oben   0x0008
#define verbindung_lu			0x0010
#define verbindung_lo			0x0020
#define verbindung_ru			0x0040
#define verbindung_ro			0x0080
#define verbindung_solo   0x0100	// 1, wenn dieses Blop sich in einem Zustand
																	// befindet, in dem es sich sowieso nicht
																	// verbinden kann
#define verbindung_alle4	0x000F


/**Klasse, die Blops "besitzt" und von ihrem Besitztum
erfahren mchte, wenn es sich verndert.
  *@author Immi
  */

class BlopBesitzer {
public:
	virtual ~BlopBesitzer() {}
	virtual void besitzGeaendert(int x, int y, bool auch_nachbarn) = 0;
	/** Da BlopGitter der einzige BlopBesitzer ist, der diese Methode berschreiben
			mchte (naja, fast), kann sie auch gleich daran angepasst sein... */
	virtual int getBesitzVerbindungen(int x, int y, bool feuer) const {
		return verbindung_solo;
	}
};

#endif
