/***************************************************************************
                          configdatei.h  -  description
                             -------------------
    begin                : Sun Jul 1 2001
    copyright            : (C) 2001 by Immi
    email                : cuyo@karimmi.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CONFIGDATEI_H
#define CONFIGDATEI_H

#include "inkompatibel.h"

#include <qstring.h>
#include <qstrlist.h>
#include <qcolor.h>
#include <qfile.h>
#include <qtextstream.h>

#include "inkompatibel.h"


/**Parst Dateien (level.descr, .cuyorc)
  *@author Immi
  */

class ConfigDatei {
 public:
  ConfigDatei(__String name);
  ~ConfigDatei();
  /** Liefert den aktuellen Abschnitt */
  __String getAbschnitt() const;
  /** Wechselt zum angegebenen Abschnitt. (Abschnitte werden durch
      [bla] eingeleitet.) Liefert false, wenn der Abschnitt nicht existiert. */
  bool setAbschnitt(__String na = "");
  /** Liefert den Eintrag, wenn er existiert, sonst den default-String
      (der per default null ist). Schaut ggf. nach EinSpieler-Eintrag. */
  __String getEintrag(__String schluessel, __String def = __String()) const;
  /** Gibt's den Eintrag? */
  bool hatEintrag(__String schluessel) const;
  /** Liefert den Eintrag als Zahl, wenn er existiert, sonst die
      default-Zahl. */
  int getZahlEintrag(__String schluessel, int def = 0) const;
  /** Liefert den Eintrag als Farbe, wenn er existiert, sonst die
      default-Farbe. */
  QColor getFarbEintrag(__String schluessel, const QColor & def = __black) const;
  /** Liefert einen Eintrag als Komma-getrennte Liste */
  int getListenEintrag(__String schluessel, QStrList & liste) const;
  /** Setzt, ob nach Ein-Spieler-Version-Schlsseln
      gesucht werden soll */
  void setEinSpielerVersion(bool esv = false);


 protected:
  __String mName;
  mutable QFile mDatei;
  mutable QTextStream mStream;
  /** false, wenn sich die Datei nicht ffnen lie */
  bool mOffen;
  /** true => Es wird nach 1-Spieler-Versionen von Schlsseln geschaut */
  bool mEinSpielerVersion;
	
  __String mAbschnitt;
  int mAbschnittPos;

	
  /** Liefert den Eintrag, wenn er existiert, sonst den default-String
      (der per default null ist). Schaut _nicht_ nach EinSpieler-Eintrag */
  __String getEintragIntern(__String schluessel, __String def = __String()) const;
  /** Liefert zurck, was fr ein Zeilentyp die Zeile ist:
      leer, abschnitt, zuweisung. In a und b werden interessante
      Positionen abgespeichert... */
  int getZeilenTyp(const __String & z, int & a, int & b) const;
  /** Wenn ein Parse-Fehler in Zeile z aufgetreten ist... */
  void fehlerZeile(const __String & z) const;
};



/** ndert den Abschnitt zeitweilig (so lange, bis das Objekt wieder
		zerstrt wird.) */
class ConfigAbschnittPush {
 public:
  ConfigAbschnittPush(ConfigDatei & c, __String name): mConf(c) {
    mMerk = mConf.getAbschnitt();
    mKlappt = mConf.setAbschnitt(name);
  }
  ~ConfigAbschnittPush() {
    if (mKlappt) mConf.setAbschnitt(mMerk);
  }
  bool hatGeklappt() {
    return mKlappt;
  }
 protected:
  ConfigDatei & mConf;
  __String mMerk;
  bool mKlappt;
};




#endif
