/***************************************************************************
                          menge.h  -  description
                             -------------------
    begin                : Sun May 6 2001
    copyright            : (C) 2001 by Immi
    email                : cuyo@karimmi.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MENGE_H
#define MENGE_H

#include "inkompatibel.h"

#define mengengroesse 52 //53

/** Eine Menge von Buchstaben (A - Z, a - z).
	* Wird von Sorte bentigt
  *@author Immi
  */

class Menge {
public:
	Menge(bool alles = false);
	~Menge();
  /** liefert true, wenn b in der Menge ist */
  bool drin(char b) const;
  /** Fgt b zur Menge hinzu (oder hinweg) */
  void dazu(char b, bool rein = true);
  /** fgt ein ganzes Intervall zur Menge hinzu (oder hinweg) */
  void dazu(char a, char b, bool rein = true);
  /** tut, was man erwarten wrde */
  void komplementiere();
  /** liefert true, wenn die beiden Mengen nicht-leeren
Schnitt haben */
  bool ueberschneidet(const Menge & m) const;
  /** Liefert die Anzahl der Elemente der Menge geschnitten mit dem
  		Intervall ['A', bis] */
  int groesse(char bis = 'z') const;

protected: // Protected methods
  /** liefert die Nummer vom Buchstaben */
  int buchNr(char b) const;

protected:
	bool mDaten[mengengroesse];
	bool mDefault;
};

#endif
