#
#   Copyright 2005 by Mark Weyer
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#

Reversi={
  name = "Reversi"
  author = "Mark Weyer"
  pics = Bunt * 3, Dreh
  greypic = Grau
  startpic = mrAlle.xpm
  startdist = "DDDDDDDDDD","DDDDDDDDDD"
  numexplode = 13

  <<
    var fa; # Ausrichtung der fallenden: 0-links 1-oben 2-rechts 3-unten
    var wr, ws, as, ns, dr; # Welle Richtung, Welle Sorte, alte Sorte,
                            # neue Sorte, Drehrichtung
                            # Richtungen: 1-oben, 2-rechts_oben, ...
                            # Sorten: von Bunt aus
                            # Drehrichtung: true vorwrts, false rckwrts

    init = {
      if loc_x==4 -> fa=0 else fa=2;
    };
  >>

  Bunt = {
    pics = mrAlle.xpm, mrTrenn.xpm
    <<
      Bunt = {
        pos=kind-Bunt;
        *;
        if wr!=0 -> {
          if kind!=ws -> {
            switch {
              wr==1 -> {wr@(0,-1)=1; ws@(0,-1)=ws;};
              wr==2 -> {wr@(1,-1)=2; ws@(1,-1)=ws;};
              wr==3 -> {wr@(1,0)=3; ws@(1,0)=ws;};
              wr==4 -> {wr@(1,1)=4; ws@(1,1)=ws;};
              wr==5 -> {wr@(0,1)=5; ws@(0,1)=ws;};
              wr==6 -> {wr@(-1,1)=6; ws@(-1,1)=ws;};
              wr==7 -> {wr@(-1,0)=7; ws@(-1,0)=ws;};
              wr==8 -> {wr@(-1,-1)=8; ws@(-1,-1)=ws;};
            };
            as=kind-Bunt;
            ns=((Bunt-kind)+(Bunt-ws)+6)%3; # Die dritte Sorte:
                                            # weder kind noch ws
            dr=(3+ns-as)%3==1;
            kind=Dreh;
          };
          wr=0;
        };
        if falling -> {1;pos=fa+4*turn;*;};
      };

      Bunt.land = {
        if fa!=0 -> {
          wr@(1,0)=3; ws@(1,0)=kind;
          if fa!=1 -> {wr@(1,1)=4; ws@(1,1)=kind;};
          if fa!=3 -> {wr@(1,-1)=2; ws@(1,-1)=kind;};
        };
        if fa!=1 -> {wr@(0,1)=5; ws@(0,1)=kind;};
        if fa!=2 -> {
          wr@(-1,0)=7; ws@(-1,0)=kind;
          if fa!=1 -> {wr@(-1,1)=6; ws@(-1,1)=kind;};
          if fa!=3 -> {wr@(-1,-1)=8; ws@(-1,-1)=kind;};
        };
        if fa!=3 -> {wr@(0,-1)=1; ws@(0,-1)=kind;};
      };

      Bunt.init = init;

      Bunt.turn = {fa=(fa+1)%4;};
    >>
  }

  Dreh = {
    neighbours = 7
    pics = mrAlle.xpm
    <<
      Dreh.init = {kind = Bunt+rnd(3); init;};

      Dreh = {
        {A,B,{C;kind=Bunt+ns}};    # pos = bisherige Animationsschritte
        if dr
          -> pos = as+5+5*pos
          else pos = ns+15-5*pos;
        *;
      };
    >>
  }

  Grau = {
    pics = mrAlle.xpm
    << Grau = {E*}; >>
  }

}


