/***************************************************************************
                          sound.cpp  -  description
                             -------------------
    begin                : Fri Jul 21 2000
    copyright            : (C) 2000 by Immi
    email                : cuyo@pcpool.mathematik.uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <cstdlib>

#include "cuyointl.h"
#include "sound.h"
#include "pfaditerator.h"

/* Um rauszufinden, ob's ein oder zwei Spieler gibt, fr Stereo */
#include "cuyo.h"

/* Globale Variable mit dem Sound-Objekt */

Sound * gSound;


Sound::Sound() {
  gSound = this;

  mSoundGeht = false;
  
#ifdef CUYO_SOUND

  mAktMod = 0;

  /* register all the drivers */
  MikMod_RegisterAllDrivers();

  /* register all the module loaders */
  MikMod_RegisterAllLoaders();

  /* initialize the library */
  md_mode |= DMODE_SOFT_MUSIC; // fr mods
  md_mode |= DMODE_SOFT_SNDFX; // fr Effekte
  if (MikMod_Init("")) {
      fprintf(stderr, _("Could not initialize sound, reason: %s\n"
              "Turning sound off.\n"),
              MikMod_strerror(MikMod_errno));
    return;
  }
   
  /* 4 voices fr Samples reservieren. (-1 = nix ndern an den voices
     fr mod-Dateien */
  MikMod_SetNumVoices(-1, 4);

  /* Braucht man wohl um samples abzuspielen: */
  MikMod_EnableOutput();
   

  mSoundGeht = true;


  /* Basis-Samples laden */
  char bsna[sample_anz][222] = sample_namen;
  for (int i = 0; i < sample_anz; i++) {
    ladSample(bsna[i]);
  }
  


  /* Timer erzeugen und verbinden... */	
  mTimer = new QTimer(this);
  connect(mTimer, SIGNAL(timeout()), SLOT(schritt()));
  mTimer->start(30);

#endif
}

Sound::~Sound() {
#ifdef CUYO_SOUND
  if (mSoundGeht) {
    delete mTimer;
    MikMod_Exit();
  }
#endif
}


/** Spielt die angegebene Mod-Datei immer wieder ab.
    Bei na = "" wird nix abgespielt. */
void Sound::playMod(__String /*na*/) {
#ifdef CUYO_SOUND
  if (mSoundGeht) {
    /* Libmikmod prozudiert einen Hnger, wenn man ein Lied mit
       Player_Stop abbricht, ohne was neues zu starten. !?! */
    if (na == "")
      na = "silence.it";
      
      
    /*if (na == "") {
      mAktMod = 0;
      Player_Stop();
      fprintf(stderr, "stop\n");
    } else {*/
 
    __String s;
    s.sprintf("sounds/%s", na.data());

    for (PfadIterator pi(s);
         !(mAktMod = Player_Load(pi.pfad().data(), 64, false)); ++pi);

    /* Lied soll im Kreis laufen: */
    mAktMod->wrap = true;
    Player_Start(mAktMod);
    //}
  }
#endif
}



/** Ldt den angegebenen Sample und liefert eine Nummer zurck,
    mit dem man ihn abspielen kann. */
int Sound::ladSample(__String /*na*/) {
#ifdef CUYO_SOUND
  if (mSoundGeht) {
    int ret = mSamples.size();
    mSamples.resize(ret + 1);

    __String s;
    s.sprintf("sounds/%s", na.data());

    for (PfadIterator pi(s);
         !(mSamples[ret] = Sample_Load(pi.pfad().data())); ++pi);

    //if (!mSamples[ret]) {
     // fprintf(stderr, _("Could not load  '%s', reason: %s\n"),
      //        na.data(), MikMod_strerror(MikMod_errno));
      /* Darf beim nicht-funktionieren nicht einfach sample_nix zurckliefern
         und nix abspeichern; sonst geht's fr die samples mit festen Konstanten
	 schief. */
    //}
    return ret;
  }
#endif
  return sample_nix;
}
  
/** Spielt das Sample mit der angegebenen Nummer (die entweder eine
    der obigen Konstanten ist oder von ladSample zurckgeliefert wurde).
    sp gibt an, fr welchen Spieler. (Wird fr Stereo-Effekte gebraucht.) */
void Sound::playSample(int /*sp*/, int /*nr*/) {
#ifdef CUYO_SOUND
  if (mSoundGeht) {
    if (nr != sample_nix && nr < (int) mSamples.size() && mSamples[nr]) {
      int pan;
      if (sp == 2 || Cuyo::gCuyo->getSpielerZahl() == 1)
        pan = PAN_CENTER; // PAN_SURROUND
      else if (sp == 0)
        pan = PAN_LEFT;
      else
        pan = PAN_RIGHT;
      /* Abspielen starten. 0, 0 bedeutet: am Anfang vom Sound starten und
         keine extra-flags */
      int v = Sample_Play(mSamples[nr], 0, 0);
      /* Stereo-Einstellung */
      Voice_SetPanning(v, pan);
    }
  }
#endif
}



/* Muss immer wieder aufgerufen werden, damit der Sound funktioniert.
   (Etwa 30 mal pro Sekunde sollte's tun.)
   Das Sound-Objekt kmmert sich selbst drum, einen QT-Timer zu erzeugen,
   der schritt() aufruft. */
void Sound::schritt() {
#ifdef CUYO_SOUND
  if (mSoundGeht) {
    MikMod_Update();
  }
#endif
}

