/*
 * Copyright (C) 2011, 2012 Federico Brega
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 */

var map;
var featureLatLon;

function init() {
    map = new OpenLayers.Map('map', {displayProjection: new OpenLayers.Projection("EPSG:4326")});
    map.addControl(new OpenLayers.Control.LayerSwitcher());

    var osm = new OpenLayers.Layer.OSM();
    var cycle = new OpenLayers.Layer.OSM(
        "OpenCycleMap",
        ["http://a.tile.opencyclemap.org/cycle/${z}/${x}/${y}.png",
            "http://b.tile.opencyclemap.org/cycle/${z}/${x}/${y}.png",
            "http://c.tile.opencyclemap.org/cycle/${z}/${x}/${y}.png"],
        { type: 'png', displayOutsideMaxExtent: true,
            transitionEffect: 'resize'}
    );
    var gphy = new OpenLayers.Layer.Google(
        "Google Physical",
        {type: google.maps.MapTypeId.TERRAIN}
    );
    var gmap = new OpenLayers.Layer.Google(
        "Google Streets",
        {numZoomLevels: 20}
    );
    var ghyb = new OpenLayers.Layer.Google(
        "Google Hybrid",
        {type: google.maps.MapTypeId.HYBRID, numZoomLevels: 20}
    );
    var gsat = new OpenLayers.Layer.Google(
        "Google Satellite",
        {type: google.maps.MapTypeId.SATELLITE, numZoomLevels: 22}
    );
    var renderer = OpenLayers.Util.getParameters(window.location.href).renderer;
    renderer = (renderer) ? [renderer] : OpenLayers.Layer.Vector.prototype.renderers;

    vectors = new OpenLayers.Layer.Vector(
        "Drawn",
        {renderers: renderer}
    );
    
    map.addLayers([cycle, osm, gphy, gmap, ghyb, gsat, vectors]);
    map.addControl(new OpenLayers.Control.LayerSwitcher());
    map.addControl(new OpenLayers.Control.MousePosition());

    convertCallback = function(feature) {
        featureLatLon = feature.clone();
        var geom = featureLatLon.geometry;
        geom.transform(map.getProjectionObject(), new OpenLayers.Projection("EPSG:4326"));
    };

    controls = {
        point: new OpenLayers.Control.DrawFeature(vectors,
                    OpenLayers.Handler.Point),
        line: new OpenLayers.Control.DrawFeature(vectors,
                    OpenLayers.Handler.Path, {'featureAdded': convertCallback}),
    };

    for(var key in controls) {
        map.addControl(controls[key]);
    }
    controls["line"].activate(); //TODO: activate through a proper function

    // Google.v3 uses EPSG:900913 
    map.setCenter(new OpenLayers.LonLat(10.2, 48.9).transform(
        new OpenLayers.Projection("EPSG:4326"),
        map.getProjectionObject()
    ), 5);
    
    for (var i = 0; i < map.layers.length; i++) {
        map.layers[i].animationEnabled = true;
    }
    
}

kmlFormat = new OpenLayers.Format.KML();
function createKml() {
    var kml = kmlFormat.write(featureLatLon);
    return kml
}