#ifndef FDBA_SIMPLE_H
#define FDBA_SIMPLE_H

#include <dballe/file.h>
#include <dballe/types.h>

namespace dballe {
namespace fortran {

/**
 * C++ implementation for the Fortran API.
 *
 * See the Fortran API documentation for details on the members of this class.
 */
struct API
{
    static const signed char missing_byte;
    static const int missing_int;
    static const float missing_float;
    static const double missing_double;

    virtual ~API() {}

    virtual void scopa(const char* repinfofile = 0) = 0;
    virtual void remove_all() = 0;
    virtual int enqi(const char* param) = 0;
    virtual signed char enqb(const char* param) = 0;
    virtual float enqr(const char* param) = 0;
    virtual double enqd(const char* param) = 0;
    virtual const char* enqc(const char* param) = 0;
    virtual void seti(const char* param, int value) = 0;
    virtual void setb(const char* param, signed char value) = 0;
    virtual void setr(const char* param, float value) = 0;
    virtual void setd(const char* param, double value) = 0;
    virtual void setc(const char* param, const char* value) = 0;
    virtual void setcontextana() = 0;
    virtual void enqlevel(int& ltype1, int& l1, int& ltype2, int& l2) = 0;
    virtual void setlevel(int ltype1, int l1, int ltype2, int l2) = 0;
    virtual void enqtimerange(int& ptype, int& p1, int& p2) = 0;
    virtual void settimerange(int ptype, int p1, int p2) = 0;
    virtual void enqdate(int& year, int& month, int& day, int& hour, int& min, int& sec) = 0;
    virtual void setdate(int year, int month, int day, int hour, int min, int sec) = 0;
    virtual void setdatemin(int year, int month, int day, int hour, int min, int sec) = 0;
    virtual void setdatemax(int year, int month, int day, int hour, int min, int sec) = 0;
    virtual void unset(const char* param) = 0;
    virtual void unsetall() = 0;
    virtual void unsetb() = 0;
    virtual int quantesono() = 0;
    virtual void elencamele() = 0;
    virtual int voglioquesto() = 0;
    virtual const char* dammelo() = 0;
    virtual void prendilo() = 0;
    virtual void dimenticami() = 0;
    virtual int voglioancora() = 0;
    virtual const char* ancora() = 0;
    virtual void critica() = 0;
    virtual void scusa() = 0;
    virtual void messages_open_input(const char* filename, const char* mode, File::Encoding format, bool simplified=true) = 0;
    virtual void messages_open_output(const char* filename, const char* mode, File::Encoding format) = 0;
    virtual bool messages_read_next() = 0;
    virtual void messages_write_next(const char* template_name=0) = 0;
    virtual const char* spiegal(int ltype1, int l1, int ltype2, int l2) = 0;
    virtual const char* spiegat(int ptype, int p1, int p2) = 0;
    virtual const char* spiegab(const char* varcode, const char* value) = 0;
    virtual void fatto() = 0;

    // Function used for test purposes only
    virtual void test_input_to_output() = 0;
};

}
}
#endif
