/*!

\if MANPAGES
\page dcmpschk Checking tool for presentation states
\else
\page dcmpschk dcmpschk: Checking tool for presentation states
\endif

\section dcmpschk_synopsis SYNOPSIS

\verbatim
dcmpschk [options] [dcmfile-in...]
\endverbatim

\section dcmpschk_description DESCRIPTION

The \b dcmpschk utility checks DICOM Grayscale Softcopy Presentation State
objects for conformance with the standard.  The test is performed in three
phases:

\li Phase 1 checks the Meta-header of the DICOM file.  It is tested whether
    all required attributes are present, whether the SOP class and instance
    UIDs match the UIDs in the main object and whether the group length
    attribute contains a correct value.  The Transfer Syntax of the Meta
    header is also checked.

\li Phase 2 performs a syntactic check of the values, value representations
    and value multiplicities for each attribute in the object.  The values
    present in the object under test are compared with the definitions of the
    DICOM data dictionary.

\li Phase 3 performs a semantic check of the integrity of the Presentation
    State.  This phase is omitted when objects of other SOP Classes are
    encountered.  Phase 1 and 2 can also be applied to other DICOM objects of
    arbitrary SOP class.
    It should be noted that \b dcmpschk does not support Presentation States
    which contain the Mask Module.  These will be rejected with a message
    that the Mask Module is not supported.

\section dcmpschk_parameters PARAMETERS

\verbatim
dcmfile-in  presentation state file(s) to be checked
\endverbatim

\section dcmpschk_options OPTIONS

\subsection dcmpschk_general_options general options
\verbatim
  -h   --help
         print this help text and exit

       --version
         print version information and exit

       --arguments
         print expanded command line arguments

  -q   --quiet
         quiet mode, print no warnings and errors

  -v   --verbose
         verbose mode, print processing details

  -d   --debug
         debug mode, print debug information

  -ll  --log-level  [l]evel: string constant
         (fatal, error, warn, info, debug, trace)
         use level l for the logger

  -lc  --log-config  [f]ilename: string
         use config file f for the logger
\endverbatim

\section dcmpschk_logging LOGGING

The level of logging output of the various command line tools and underlying
libraries can be specified by the user.  By default, only errors and warnings
are written to the standard error stream.  Using option \e --verbose also
informational messages like processing details are reported.  Option
\e --debug can be used to get more details on the internal activity, e.g. for
debugging purposes.  Other logging levels can be selected using option
\e --log-level.  In \e --quiet mode only fatal errors are reported.  In such
very severe error events, the application will usually terminate.  For more
details on the different logging levels, see documentation of module "oflog".

In case the logging output should be written to file (optionally with logfile
rotation), to syslog (Unix) or the event log (Windows) option \e --log-config
can be used.  This configuration file also allows for directing only certain
messages to a particular output stream and for filtering certain messages
based on the module or application where they are generated.  An example
configuration file is provided in <em>\<etcdir\>/logger.cfg</em>.

\section dcmpschk_command_line COMMAND LINE

All command line tools use the following notation for parameters: square
brackets enclose optional values (0-1), three trailing dots indicate that
multiple values are allowed (1-n), a combination of both means 0 to n values.

Command line options are distinguished from parameters by a leading '+' or '-'
sign, respectively.  Usually, order and position of command line options are
arbitrary (i.e. they can appear anywhere).  However, if options are mutually
exclusive the rightmost appearance is used.  This behavior conforms to the
standard evaluation rules of common Unix shells.

In addition, one or more command files can be specified using an '@' sign as a
prefix to the filename (e.g. <em>\@command.txt</em>).  Such a command argument
is replaced by the content of the corresponding text file (multiple
whitespaces are treated as a single separator unless they appear between two
quotation marks) prior to any further evaluation.  Please note that a command
file cannot contain another command file.  This simple but effective approach
allows one to summarize common combinations of options/parameters and avoids
longish and confusing command lines (an example is provided in file
<em>\<datadir\>/dumppat.txt</em>).

\section dcmpschk_environment ENVIRONMENT

The \b dcmpschk utility will attempt to load DICOM data dictionaries specified
in the \e DCMDICTPATH environment variable.  By default, i.e. if the
\e DCMDICTPATH environment variable is not set, the file
<em>\<datadir\>/dicom.dic</em> will be loaded unless the dictionary is built
into the application (default for Windows).

The default behavior should be preferred and the \e DCMDICTPATH environment
variable only used when alternative data dictionaries are required.  The
\e DCMDICTPATH environment variable has the same format as the Unix shell
\e PATH variable in that a colon (":") separates entries.  On Windows systems,
a semicolon (";") is used as a separator.  The data dictionary code will
attempt to load each file specified in the \e DCMDICTPATH environment variable.
It is an error if no data dictionary can be loaded.

\section dcmpschk_copyright COPYRIGHT

Copyright (C) 2000-2022 by OFFIS e.V., Escherweg 2, 26121 Oldenburg, Germany.

*/
