/* burn.c --
 *
 * Copyright (c) 1998-2002  Mike Oliphant <oliphant@gtk.org>
 *
 *   http://www.nostatic.org/grip
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <mysql.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <math.h>
#include "idlist.h"
#include "song.h"
#include "disc.h"


void SymlinkSongs(MYSQL *mysql,IDList *slist,char *destpath)
{
  int pos;
  Song song_data;
  Disc disc_data;
  char new_filename[1024];
  char tmp[1024];
  int int_gain;
  double float_gain;
  FILE *tfp;
  gboolean wav_cd=0;

  if(wav_cd) {
    g_snprintf(tmp,1024,"%s/toc.dat",destpath);
    
    tfp=fopen(tmp,"w");

    fprintf(tfp,"CD_DA\n");
  }

  for(pos=0;pos<slist->num_ids;pos++) {
    if(LookUpSong(mysql,slist->ids[pos],&song_data)) {
      if(wav_cd) {
	g_snprintf(new_filename,1024,"%s/%02d.wav",destpath,pos);

	fprintf(tfp,"TRACK AUDIO\nFILE \"%s\" 0\n",new_filename);
      }
      else {
	g_snprintf(new_filename,1024,"%s/%02d.mp3",destpath,pos);

	printf("copy %s to %s\n",song_data.filename,new_filename);

	g_snprintf(tmp,1024,"cp %s %s",song_data.filename,new_filename);

	system(tmp);
      }

      if(LookUpDisc(mysql,song_data.discid,&disc_data)) {
	if(wav_cd) {
	  if(disc_data.gain_adjustment) {
	    g_snprintf(tmp,1024,
		       "/usr/bin/madplay -a %+6.2f --output=wave:%s %s",
		       ((double)disc_data.gain_adjustment)/100.0,
		       new_filename,song_data.filename);
	  }
	  else {
	    g_snprintf(tmp,1024,"/usr/bin/madplay --output=wave:%s %s",
		       new_filename,song_data.filename);
	  }
	}
	else {
	  if(disc_data.gain_adjustment) {
	    float_gain=(double)disc_data.gain_adjustment/100.0;
	    
	    float_gain=float_gain/(5.0 * log10(2.0));
	    
	    if(fabs(float_gain) - (double)((int)(fabs(float_gain))) < 0.5)
	      int_gain=(int)float_gain;
	    else
	      int_gain=(int)float_gain + (float_gain < 0 ? -1 : 1);	  
	    
	    printf("gain is %d  --  int gain is %d\n",
		   disc_data.gain_adjustment,
		   int_gain);
	    
	    g_snprintf(tmp,1024,"mp3gain /g %d %s",int_gain,new_filename);
	  }
	}  
	
	printf("cmd is [%s]\n",tmp);
	
	system(tmp);		   
      }
    }
  }
 
  if(wav_cd) fclose(tfp);
}

/* mkisofs  -D -J -R -o <out> */
