# -*- coding: utf-8 -*-
#
# Copyright (C) 2014-2018 by the Free Software Foundation, Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301,
# USA.
#
# Author: Aurelien Bompard <abompard@fedoraproject.org>


from django.core.cache import cache as django_cache


MISSING = object()


# TODO: New versions of Django, starting 1.9 have get_or_set included.
# Remove the proxy below when we drop support for 1.9
class CacheProxy:

    def __init__(self):
        self.backend = django_cache

    def __getattr__(self, name):
        return getattr(self.backend, name)

    def get_or_set(self, key, fn, timeout=MISSING, **kw):
        value = self.backend.get(key, **kw)
        if value is None:
            value = fn()
            if timeout is MISSING:
                self.backend.set(key, value, **kw)
            else:
                self.backend.set(key, value, timeout, **kw)
        return value


cache = CacheProxy()
