function newPage(filename) {
    if (filename == "toc.html") {
	if (self.parent.filemap == null) {
	    walk_toc();
	}
    } else if (self.parent.filemap != null) {
	var id = self.parent.filemap[filename];
	if (id != null) {
	    highlight_toc(id);
	}
	write_header(filename);
	write_nav(id);
    }
}

function walk_toc() {
    var doc = self.document;
    var filemap = new Array();
    var fileidx = new Array();
    var filermap = new Array();
    var fileridx = new Array();
    var idx = 0;
    var sectmap = new Array();
    var section = "";
    var title = "";

    for (var i = 0; i < doc.all.length-2; i++) {
	var div_elem = doc.all.item(i);
	var img_elem = doc.all.item(i+1);
	var a_elem   = doc.all.item(i+2);

	if (img_elem.tagName == "A") {
	    a_elem = img_elem;
	}

	if (div_elem.tagName == "DIV"
	    && a_elem.tagName == "A") {
	    var id   = div_elem.getAttribute("ID");
	    var file = a_elem.getAttribute("HREF");
	    var pos  = file.lastIndexOf("/");
	    if (pos > 0) {
		file = file.substring(pos+1);
	    }

	    if (div_elem.className == "toc-section") {
		section = a_elem.innerText;
	    }

	    if (div_elem.className == "toc-slidesinfo") {
		title = a_elem.innerText;
	    }

	    if (id != "") {
		fileidx[idx] = file;
		fileridx[file] = idx;
		idx++;
		filemap[file] = id;
		filermap[id] = file;
		sectmap[file] = section;
	    }
	}
    }

    // Squirrel this away on the top frame
    self.parent.prestitle = title;
    self.parent.filemap = filemap;
    self.parent.filermap = filermap;
    self.parent.fileidx = fileidx;
    self.parent.fileridx = fileridx;
    self.parent.sectmap = sectmap;
}

function highlight_toc(id) {
    var frame = window.parent.frames("toc");
    var doc   = frame.document;
    var div   = null;

    // find the div
    for (var i = 0; i < doc.all.length; i++) {
	if (doc.all.item(i).tagName == "DIV") {
	    if (doc.all.item(i).getAttribute("ID") == id) {
		div = doc.all.item(i);
		break;
	    }
	}
    }

    var a = div.children(0);
    if (a != null && a.tagName != "A") {
	a = div.children(1);
    }

    if (a != null && a.tagName == "A") {
	if (frame.lastA != null) {
	    frame.lastA.style.textDecorationUnderline = false;
	}
	a.style.textDecorationUnderline = true;
	frame.lastA = a;
    }
}

function write_nav(id) {
    var frame = window.parent.frames("navbar");
    var doc   = frame.document;

    if (id == null) {
	id = self.parent.filemap[self.parent.fileidx[0]];
    }

    var file  = self.parent.filermap[id];
    var num   = self.parent.fileridx[file];
    var prev  = null;
    var next  = null;

    if (num > 0) {
	prev = self.parent.fileidx[num-1];
    }

    if (num < self.parent.fileidx.length) {
	next = self.parent.fileidx[num+1];
    }

    doc.open();
    doc.close();
    doc.write("<html><head>\n");
    doc.write("<link type='text/css' rel='stylesheet' href='slides.css'>\n");
    doc.write("<title>nav frame</title>\n");
    doc.write("</head><body bgcolor='#8399B1'>\n");
    doc.write("<table width='100%' border=0 cellpadding=0 cellspacing=0>\n");
    doc.write("<tr>\n");
    doc.write("<td align=left valign=center width='33%'>");
    if (prev != null) {
	doc.write("<a href='" + prev + "' target='foil'>");
	doc.write("<img src='gifs/left.gif' border='0'>");
	doc.write("</a>");
    } else {
	doc.write("&nbsp;");
    }
    doc.write("</td>\n");
    doc.write("<td align=center valign=bottom width='34%'>");
    if (num > 0) {
	doc.write("<span class='navfooter'>Slide " + num + "</span>");
    } else {
	doc.write("&nbsp;");
    }
    doc.write("</td>\n");
    doc.write("<td align=right valign=center width='33%'>");
    if (next) {
	doc.write("<a href='" + next + "' target='foil'>");
	doc.write("<img src='gifs/right.gif' border='0'>");
	doc.write("</a>");
    } else {
	doc.write("&nbsp;");
    }
    doc.write("</td>\n");
    doc.write("</tr>\n");
    doc.write("</table>\n");
    doc.close();
}

function write_header(file) {
    var frame = window.parent.frames("header");
    var doc   = frame.document;
    var title = self.parent.prestitle;
    var section  = self.parent.sectmap[file];

    var bgcolor = "#8399B1";
    var header = title + ": " + section;

    if (file == 'titlefoil.html') {
      header = "";
    }

    doc.open();
    doc.close();
    doc.write("<html><head>\n");
    doc.write("<link type='text/css' rel='stylesheet' href='slides.css'>\n");
    doc.write("<title>header frame</title>\n");
    doc.write("</head><body bgcolor='" + bgcolor + "'>\n");
    doc.write("<table width='100%' border=0 cellpadding=0 cellspacing=0>\n");
    doc.write("<tr>\n");
    doc.write("<td align=center valign=center width='100%'>");
    doc.write("<span class=navheader>" + header + "</span>");
    doc.write("</td>\n");
    doc.write("</tr>\n");
    doc.write("</table>\n");
    doc.close();
}

