import re
from dosage.modules.helpers.BasicComicModule import BasicComicModule
from dosage.util import getQueryParams

class Achewood(BasicComicModule):
    latestUrl = 'http://www.achewood.com/'
    imageUrl = 'http://www.achewood.com/index.php?date=%s'
    imageSearch = re.compile(r'<img src="(/comic\.php\?date=\d{8})"')
    prevSearch = re.compile(r'<a href="(/index\.php\?date=\d{8})"[^>]*>&lt;-</a>')
    help = 'Index format: mmddyyyy'

    def getFilename(self, imageUrl, pageUrl):
        return getQueryParams(imageUrl)['date'][0]
