import re
from dosage.modules.helpers.BasicComicModule import BasicComicModule, BounceMixin
from dosage.util import getQueryParams

class UserFriendly(BasicComicModule, BounceMixin):
    baseUrl = 'http://ars.userfriendly.org/cartoons/?mode=classic'
    imageUrl = 'http://ars.userfriendly.org/cartoons/?id=%s&mode=classic'
    imageSearch = re.compile(r'<img border="0" src="(http://www.userfriendly.org/cartoons/archives/\d{2}\w{3}/.+?\.gif)"')
    prevSearch = re.compile(r'<area shape="rect" href="(/cartoons/\?id=\d{8}&mode=classic)" coords="[\d, ]+?" alt="Previous Cartoon">')
    nextSearch = re.compile(r'<area shape="rect" href="(/cartoons/\?id=\d{8}&mode=classic)" coords="[\d, ]+?" alt="">')
    help = 'Index format: yyyymmdd'

    def getFilename(self, imageUrl, pageUrl):
        return 'uf%s' % (getQueryParams(pageUrl)['id'][0][2:],)
