import re
from dosage.modules.helpers.BasicComicModule import BasicComicModule
from dosage.util import getQueryParams

class Winter(BasicComicModule):
    latestUrl = 'http://www.wintercomic.com/'
    imageUrl = 'http://www.wintercomic.com/index.php?strip_id=%s'
    imageSearch = re.compile(r'<img src=\'(/index\.php\?do_command=show_strip&strip_id=\d+.+?)\'', re.IGNORECASE)
    prevSearch = re.compile(r'<a href=[\'"](/?index\.php\?strip_id=\d+)[\'"]><img.+?src=[\'"]\./img/lastpage.gif[\'"]', re.IGNORECASE)
    help = 'Index format: n (unpadded)'

    def getFilename(self, imageUrl, pageUrl):
        return getQueryParams(imageUrl)['strip_id'][0]
