import os
from zope.interface import Interface
from twisted.plugin import getPlugins
from dosage import plugins

DISABLED_FILES = ('/etc/dosage/disabled',
                  '~/.dosage/disabled')

disabled = []
for filename in DISABLED_FILES:
    filename = os.path.expanduser(filename)
    if os.path.exists(filename):
        disabled.extend([line.rstrip('\n') for line in open(filename)])

class IScraper(Interface):
    """
    I implement a screen-scraping mechanism for traversing web comics and
    retrieving the content.
    """

class DisabledComicError(ValueError):
    pass

def get(comicName):
    """Returns a comic module object."""

    scrapers = getPlugins(IScraper, plugins)
    for scraper in scrapers:
        if scraper.name == comicName:
            return scraper

    raise ValueError('Comic %r not found.' % (comicName,))

def items():
    scrapers = getPlugins(IScraper, plugins)
    return sorted(scrapers, key=lambda s: s.name)
