/*
 *  ---------
 * |.**> <**.|  CardContact
 * |*       *|  Software & System Consulting
 * |*       *|  Minden, Germany
 * |**> <**|  Copyright (c) 1999. All rights reserved
 *  --------- 
 *
 * See file LICENSE for details on licensing
 *
 * Abstract :       Defines tools/types for 3 wire bus memory card handling
 *
 * Author :         Frank Thater (FTH)
 *
 * Last modified:   04/15/2000
 *
 *****************************************************************************/

#ifndef _MC3WBP_H_
#define _MC3WBP_H_

#include "memorycards.h"

int MC_3WBPInit(struct eco5000_t *ctx);

int MC_3WBPProcess(struct eco5000_t *ctx,
		   unsigned int lc,
		   unsigned char *cmd,
		   unsigned int *lr,
		   unsigned char *rsp);

int MC3WBP_Select_File(struct eco5000_t *ctx,
		       unsigned int lc,
		       unsigned char *cmd,
		       unsigned int *lr,
		       unsigned char *rsp);

int MC3WBP_Read_Binary(struct eco5000_t *ctx,
		       unsigned int lc,
		       unsigned char *cmd,
		       unsigned int *lr,
		       unsigned char *rsp);

int MC3WBP_Update_Binary(struct eco5000_t *ctx,
			 unsigned int lc,
			 unsigned char *cmd,
			 unsigned int *lr,
			 unsigned char *rsp);

int MC3WBP_Verify(struct eco5000_t *ctx,
		  unsigned int lc,
		  unsigned char *cmd,
		  unsigned int *lr,
		  unsigned char *rsp);

int MC3WBP_Change_Verification_Data(struct eco5000_t *ctx,
				    unsigned int lc,
				    unsigned char *cmd,
				    unsigned int *lr,
				    unsigned char *rsp);

int MC3WBP_UpdateBuffer(struct eco5000_t *ctx,
			unsigned int soffset,
			int length);

int MC3WBP_Command(struct eco5000_t *ctx,
		   unsigned char *cmd3wbp,
		   unsigned char *rsp,
		   int *length); 

#endif














