/**
* Copyright 1981-2007 ECMWF
* 
* Licensed under the GNU Lesser General Public License which
* incorporates the terms and conditions of version 3 of the GNU
* General Public License.
* See LICENSE and gpl-3.0.txt for details.
*/

#include "fortint.h"

void dsgnbt_(
  fortint * kout,
  fortint * kin,
  fortint * kpos,
  fortint * kret) {

fortint value = *kin;
unsigned fortint sign = value & (1 << ((*kpos)-1));
unsigned fortint mask = ~(-1 << ((*kpos)-1));
fortint new = value & mask;

  if( sign )
    *kout = -new;
  else
    *kout = new;

  *kret = 0;
  return;
}

void dsgnbt(
  fortint * kout,
  fortint * kin,
  fortint * kpos,
  fortint * kret) {

  dsgnbt_(kout,kin,kpos,kret);
}
