C Copyright 1981-2007 ECMWF
C 
C Licensed under the GNU Lesser General Public License which
C incorporates the terms and conditions of version 3 of the GNU
C General Public License.
C See LICENSE and gpl-3.0.txt for details.
C


      SUBROUTINE GETIND (KLND,KIND,KLEN,KARAY,KPR,KRET)
C
C---->
C     ----------------------------------------------------------------
C
C****
C
C     PURPOSE.
C     --------
C
C           GET INTEGER DATA FROM RECORD OF UNPACKED GRIB
C           OR PSEUDO-GRIB DATA.
C
C**   INTERFACE.
C     ----------
C
C           CALL GETIND (KLND,KIND,KLEN,KARAY,KPR,KRET)
C
C           INTEGER    K.
C           REAL       P.
C           LOGICAL    O.
C           CHARACTER  H.
C
C               INPUT PARAMETERS.
C               -----------------
C
C               KIND       - ARRAY TO RECEIVE INTEGER DATA.
C               KLEN       - LENGTH OF THIS ARRAY.
C               KARAY      - ARRAY CONTAINING UNPACKED RECORD.
C               KPR        - DEBUG PRINT SWITCH.
C                            0 , NO PRINTOUT.
C                            1 , DEBUG PRINTOUT.
C
C               KRET       - ABORT/NO ABORT WHEN ERROR FOUND.
C                            0   , ABORT IF ERROR FOUND.
C                            NON-ZERO , NO ABORT ON ERROR.
C
C               OUTPUT PARAMETERS.
C               ------------------
C
C               KRET       - ERROR RETURN CODE.
C                            0   , NO ERROR ENCOUNTERED.
C                            1   , TARGET ARRAY TOO SMALL.
C               KIND       - INTEGER DATA.
C               KLND       - NUMBER OF VALUES IN THIS ARRAY.
C
C     METHOD.
C     -------
C
C           UNPACKED DATA IS IN SELF-DEFINING RECORDS. THE REQUIRED
C           VALUES ARE LOCATED AND EXTRACTED.
C
C     EXTERNALS.
C     ----------
C
C           NONE.
C
C     REFERENCE.
C     ----------
C
C           SEE MARS FORMAT DOCUMENTATION RE GRIB, PSEUDO-GRIB AND
C           UNPACKED RECORD FORMATS.
C
C     COMMENTS.
C     ---------
C
C           PROGRAM CONTAINS SECTIONS 0 TO 2 AND SECTION 9.
C
C     AUTHOR.
C     -------
C
C           J. HENNESSY      ECMWF      18:06:86.
C
C     MODIFICATIONS
C     --------------
C           NONE.
C
C     ----------------------------------------------------------------
C----<
C
C
C
C
C
C
C
C
C
C
C*    SECTION 0 . DEFINITION OF VARIABLES.
C     ------------------------------------
C
      IMPLICIT LOGICAL     ( L, O, G )
      IMPLICIT CHARACTER*8 ( C, H, Y )
      IMPLICIT INTEGER     ( I, J, K, M, N )
C
      DIMENSION KARAY(*)
      DIMENSION KIND(KLEN)
C
C     ----------------------------------------------------------------
C
C
C
C
C
C
C
C
C
C*    SECTION 1 . SET INITIAL VALUES. CHECK INPUT PARAMETERS.
C     -------------------------------------------------------
C
 1000 CONTINUE
C
      IF (KPR.EQ.1) WRITE (*,*) 'GETIND : SECTION 1.'
C
      IRET = KRET
      KRET = 0
C
C
C*    GO TO SECTION 9 , IF ERROR IN PARAMETERS.
C
      IF (KRET.NE.0) GO TO 9000
C
C     ----------------------------------------------------------------
C
C
C
C
C
C
C
C
C
C*    SECTION 2 . LOCATE AND EXTRACT VALUES.
C     --------------------------------------
C
 2000 CONTINUE
C
      IF (KPR.EQ.1) WRITE (*,*) 'GETIND : SECTION 2.'
C
      ILB1 = KARAY(2)
      ILB2 = KARAY(2+ILB1+1)
      ILF2 = KARAY(2+ILB1+1+ILB2+1)
      ILB3 = KARAY(2+ILB1+1+ILB2+1+ILF2+1)
      ILCD = KARAY(2+ILB1+1+ILB2+1+ILF2+1+ILB3+1)
      ILFD = KARAY(2+ILB1+1+ILB2+1+ILF2+1+ILB3+1+ILCD+1)
      KLND = KARAY(2+ILB1+1+ILB2+1+ILF2+1+ILB3+1+ILCD+1+ILFD+1)
C
      IF (KLEN.LT.KLND)
     C   THEN
             KRET = 1
             WRITE (*,9001) KRET , KLND
             GO TO 9000
         ENDIF
C
      DO 2010 J=1,KLND
         KIND(J) = KARAY(J+2+ILB1+1+ILB2+1+ILF2+1+ILB3+1+ILCD+1+ILFD+1)
 2010 CONTINUE
C
C
C     ----------------------------------------------------------------
C
C
C
C
C
C
C
C*    SECTION 9 . RETURN TO CALLING ROUTINE OR ABORT. FORMAT STATEMENTS.
C     ------------------------------------------------------------------
C
 9000 CONTINUE
C
      IF (KPR.EQ.1) WRITE (*,*) 'GETIND : SECTION 9.'
C
      IF (KRET.NE.0.AND.IRET.EQ.0) CALL ABORT
C
      RETURN
C
C
 9001 FORMAT (1H ,'GETIND : ERROR CODE = ',I3,'. TARGET ARRAY MUST ',
     C            'BE AT LEAST ',I5,' WORDS LONG.')
C
C
C     ---------------------------------------------------------------
C
C
      END
C
