C Copyright 1981-2007 ECMWF
C 
C Licensed under the GNU Lesser General Public License which
C incorporates the terms and conditions of version 3 of the GNU
C General Public License.
C See LICENSE and gpl-3.0.txt for details.
C

      SUBROUTINE LL2XYZ(RLAT,RLONG,X,Y,Z,INROW)
C---->
C**** LL2XYZ
C
C     Purpose
C     -------
C
C     Converts an array of latitude/longitude values to an
C     array of (x,y,z) coordinates.
C
C
C     Interface
C     ---------
C
C     CALL LL2XYZ(RLAT,RLONG,X,Y,Z,INROW)
C
C     Input
C     -----
C
C     RLAT  - Array of latitudes.
C     RLONG - Array of corresponding longitudes.
C     INROW - Count of latitudes/longitudes.
C
C
C     Output
C     ------
C
C     (X,Y,Z) - Array of coordinates.
C
C
C     Method
C     ------
C
C     Z axis is the polar axis directed from south to north.
C     X and Y axes are in the equatorial plane and have origin at the
C     centre of the Earth. The X axis passes through (O north, 0 east).
C
C
C     Externals
C     ---------
C
C     None.
C
C
C     Author
C     ------
C
C     J.D.Chambers     ECMWF
C
C----<
C
      IMPLICIT NONE
C
C     Subroutine arguments
C
      REAL RLAT,RLONG,X,Y,Z
      DIMENSION RLONG(*),X(*),Y(*),Z(*)
      INTEGER INROW
C
C     Parameters
C
      INTEGER JPMAXGG
      PARAMETER( JPMAXGG = 1280 )
C
C     Local variables
C
      REAL FACTOR, COS_LAT, SIN_LAT, COS_LON, SIN_LON
      DIMENSION COS_LON(JPMAXGG), SIN_LON(JPMAXGG)
      DATA FACTOR/0.017453293/
      INTEGER LOOP
      REAL ALAT
C
      ALAT = RLAT * FACTOR
      COS_LAT = COS(ALAT)
      SIN_LAT = SIN(ALAT)
C
      DO LOOP = 1, INROW
        COS_LON(LOOP) = COS(RLONG(LOOP)*FACTOR)
        SIN_LON(LOOP) = SIN(RLONG(LOOP)*FACTOR)
C
        X(LOOP) = COS_LAT*COS_LON(LOOP)
        Y(LOOP) = COS_LAT*SIN_LON(LOOP)
        Z(LOOP) = SIN_LAT
      ENDDO
C
      RETURN
      END

