/**
* Copyright 1981-2007 ECMWF
* 
* Licensed under the GNU Lesser General Public License which
* incorporates the terms and conditions of version 3 of the GNU
* General Public License.
* See LICENSE and gpl-3.0.txt for details.
*/

#include <stdio.h>

#include "bitmap.h"

void SHOWMAP(
  char ** mybuffer,
  int * rowCount,
  int * columnCount) {
/*
// Displays the bits in a bitmap.
//
// Called from FORTRAN:
//
// CALL SHOWMAP(BITMAP,ROWCNT,COLCNT)
//
// where:
//
// BITMAP is an array containing the bitmap.
// ROWCNT is the number of rows
// COLCNT is the number of columns
//
*/
int value, i, j, bitNumber, byte, bit;
int rowTotal = *rowCount;
int columnTotal = *columnCount;
char * buffer;

  buffer = *mybuffer;

  for( i = 0; i < rowTotal; i++ ) {
    printf("\n");
    for( j = 0; j < columnTotal; j++ ) {
      bitNumber = i*columnTotal + j;
      byte = bitNumber / 8;
      bit  = bitNumber % 8;
      value = (buffer[byte] >> (7-bit)) & 0x01;
      printf("%d ", value);
    }
  }
  printf("\n");

}
