/* 
 * marker_style.h -- ePiX's dot size and tick mark length
 *
 * This file is part of ePiX, a C++ library for creating high-quality 
 * figures in LaTeX 
 *
 * Version 1.1.19
 * Last Change: September 17, 2007
 */

/* 
 * Copyright (C) 2001, 2002, 2003, 2004, 2005, 2006, 2007
 * Andrew D. Hwang <rot 13 nujnat at zngupf dot ubylpebff dot rqh>
 * Department of Mathematics and Computer Science
 * College of the Holy Cross
 * Worcester, MA, 01610-2395, USA
 */

/*
 * ePiX is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * ePiX is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
 * License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ePiX; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef EPIX_MARKER_STYLE
#define EPIX_MARKER_STYLE

namespace ePiX {

  class marker_sizes {
  public:
    marker_sizes();

    marker_sizes& dot_size(double diam);
    marker_sizes& tick_size(double len);

    double  dot_size() const;
    double tick_size() const;

  private:
    double the_dotsize;  // size of dots,  1  -- 36 pt
    double the_ticksize; // (half-)size of tick marks, 1 -- 8 pt
  };

  marker_sizes& the_mark_size();

} // end of namespace

#endif /* EPIX_MARKER_STYLE */
