/* $Id: NodeFactory.tpp 4331 2009-01-27 14:57:41Z potyra $ 
 * vim:tabstop=8:shiftwidth=8:filetype=cpp:textwidth=72:
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <cassert>

namespace ast {

template <typename T, typename U>
std::list<T>*
NodeFactory::listCast(std::list<U>* l)
{
	U u = NULL; /* U should be a pointer */
	T t;
	t = u; /* won't work if classes aren't compatible */

	assert(sizeof(std::list<T>) == sizeof(std::list<U>));
	return reinterpret_cast< std::list<T>* >(l);
}

template <typename T>
void
NodeFactory::listCombine(std::list<T>* dest, std::list<T>* source)
{
	assert(source);
	assert(dest);

	for (typename std::list<T>::iterator i = source->begin(); 
		i != source->end(); i++) {
		dest->push_back(*i);
	}
}

};
