/*
 * $Id: chip_gen_74612.c,v 1.19 2009-06-03 11:34:03 vrsieh Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>

#include "fixme.h"

#include "chip_gen_74612.h"

struct cpssp {
	/*
	 * Config
	 */

	/*
	 * Signals
	 */
	unsigned int state_power;
	struct sig_cs *port_cs;
	struct sig_integer *port_ma;
	struct sig_integer *port_md;

	/*
	 * State
	 */
	uint8_t page[16];
};

static void
chip_gen_74612_power_set(void *_css, unsigned int val)
{
	struct cpssp *cpssp = (struct cpssp *) _css;

	cpssp->state_power = val;
}

static int
chip_gen_74612_inb(void *_css, uint8_t *valp, unsigned long port)
{
	struct cpssp *cpssp = (struct cpssp *) _css;	
	
	*valp = cpssp->page[port & 0xf];

	return 0;
}

static int
chip_gen_74612_outb(void *_css, uint8_t value, unsigned long port)
{
	struct cpssp *cpssp = (struct cpssp *) _css;	
	
	cpssp->page[port & 0xf] = value;

	return 0;
}

static void
chip_gen_74612_ma_set(void *_css, int val)
{
	struct cpssp *cpssp = (struct cpssp *) _css;	
	
	sig_integer_set(cpssp->port_md, cpssp, cpssp->page[val & 0xf]);
}

void *
chip_gen_74612_create(
	const char *name,
	struct sig_manage *port_manage,
	struct sig_boolean *port_power,
	struct sig_cs *port_cs,
	struct sig_isa_bus_main *port_bus,
	struct sig_integer *port_ma,
	struct sig_integer *port_md
)
{
	static const struct sig_boolean_funcs power_funcs = {
		.set = chip_gen_74612_power_set,
	};
	static const struct sig_cs_funcs cs_funcs = {
		.readb = chip_gen_74612_inb,
		.writeb = chip_gen_74612_outb,
	};
	static const struct sig_integer_funcs ma_funcs = {
		.set = chip_gen_74612_ma_set,
	};
	struct cpssp *cpssp;

	cpssp = malloc(sizeof(*cpssp));
	assert(cpssp);

	cpssp->port_md = port_md;

	/* Out */
	sig_integer_connect_out(port_md, cpssp, 0);

	/* Call */
	cpssp->port_cs = port_cs;
	sig_cs_connect(port_cs, cpssp, &cs_funcs);

	/* In */
	cpssp->state_power = 0;
	sig_boolean_connect_in(port_power, cpssp, &power_funcs);

	sig_integer_connect_in(port_ma, cpssp, &ma_funcs);

	return cpssp;
}

void
chip_gen_74612_destroy(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	free(cpssp);
}
