/*
 * $Id: sig_eth.c,v 1.11 2009-05-21 16:38:07 vrsieh Exp $
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>

#include "sig_eth.h"

void
sig_eth_send(
	struct sig_eth *b,
	void *s,
	const void *buf,
	unsigned int buflen
)
{
	unsigned int nr;

	for (nr = 0; nr < b->nmembers; nr++) {
		if (b->member[nr].s == s) {
			continue;
		}
		(*b->member[nr].f->recv)(b->member[nr].s, buf, buflen);
	}
}

void
sig_eth_connect(struct sig_eth *b, void *s, const struct sig_eth_funcs *f)
{
	assert(b);
	assert(b->type == SIG_GEN_ETH);
	assert(b->nmembers < sizeof(b->member) / sizeof(b->member[0]));

	b->member[b->nmembers].s = s;
	b->member[b->nmembers].f = f;
	b->nmembers++;
}

struct sig_eth *
sig_eth_create(const char *name)
{
	struct sig_eth *b;

	b = malloc(sizeof(*b));
	assert(b);

	b->type = SIG_GEN_ETH;
	b->nmembers = 0;

	return b;
}

void
sig_eth_destroy(struct sig_eth *sig)
{
	assert(sig);
	assert(sig->type == SIG_GEN_ETH);

	free(sig);
}
