/*
 * Copyright (C) 2016 FAUmachine Team <info@faumachine.org>.
 *
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __TREE_H_INCLUDED
#define __TREE_H_INCLUDED

/* LIST */
struct lst_node_t {
	struct lst_node_t *preceder;
	struct lst_node_t *succeder;
};
typedef struct lst_node_t lst_node;

typedef struct {
	lst_node node;
	void *data;
} lst_dnode;

typedef struct  {
	lst_node *first;
	lst_node *last;
	int num;
} lst;

#define lst_Foreach(list, iter)	for ((iter) = ((lst_dnode *)(list)->first); iter; (iter) = (lst_dnode *)(((lst_node *)(iter))->succeder))

/* LIST */

typedef struct tree_node_t tree_node;

tree_node *tree_new(void);
void tree_free(tree_node *node);

void* tree_get_data(tree_node *node);
void tree_set_data(tree_node *node, void *data);

tree_node* tree_get_parent(tree_node *node);
lst* tree_get_children(tree_node *node);

tree_node* tree_new_child(tree_node *parent, void *data);

/* Callback which is invoked on every tree node. The opaque pointer will
 * be passed to this function by the traversal function. Return 0 to continue
 * traversal or 1 to abort.
 */
typedef int (*tree_node_callback)(tree_node *node, void *opaque);

int tree_visit_preorder(tree_node *root, tree_node_callback cb, void *opaque);
int tree_visit_postorder(tree_node *root, tree_node_callback cb, void *opaque);
int tree_visit_children(tree_node *parent, tree_node_callback cb, void *opaque);

#endif /* __TREE_H_INCLUDED */
