/*
 * Copyright (C) 2004-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __COMPILER_H_INCLUDED
#define __COMPILER_H_INCLUDED

#include "build_config.h"

#ifndef __ASSEMBLY__
#include <inttypes.h>
#endif

#define CONST	const
#define PACKED	__attribute__((__packed__))
#define CODE16 asm(".code16gcc")
#define CODE32 asm(".code32")
#define ASM_ENTRY
#define C_ENTRY
#define ALWAYS_INLINE	inline __attribute__((__always_inline__))
#define NOINLINE	__attribute__((__noinline__))

/* Pointer macros */
/* Uses linear address pointers */ 
/*
 * ATTENTION!
 * The *_VEC versions are special macros for
 * setting up the interrupt vector table
 * in real mode. This is needed, because
 * flaws in the boot programs of some DOSoid
 * systems rely on having a lot of 0-bytes
 * in the table _AND_ properly initialized
 * interrupt vectors.
 */
#ifndef CONFIG_80286_SUPPORT

#define PTR_OFF(__p) (((uint16_t) (uint32_t) (__p) & 0x000f) | 0x8000)
#define PTR_OFF_VEC(__p) (((uint16_t) (uint32_t) (__p) & 0xffff))

#define PTR_SEG(__p) ((uint16_t) (((uint32_t) (__p) >> 4) - 0x800))
#define PTR_SEG_VEC(__p) ((uint16_t) (((uint32_t) (__p) >> 4) & 0xf000))

#else

#define PTR_OFF(__p) ((uint16_t) ((uint32_t) (__p)))
#define PTR_OFF_VEC(__p) ((uint16_t) ((uint32_t) (__p)))

#define PTR_SEG(__p) ((uint16_t) (((uint32_t) (__p) >> 16)))
#define PTR_SEG_VEC(__p) ((uint16_t) (((uint32_t) (__p) >> 16)))

#endif

#define PTR(__s,__o) ((void *) (((uint32_t) (__s) << 4) + (uint32_t) (__o)))

#endif /* __COMPILER_H_INCLUDED */
