#include "tools.h"

#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <limits.h>
#include <string.h>
#include <ctype.h>

#include "ui.h"
#include "version.h"
#include "MainWindow.h"
#include "InputWindow.h"
#include "PYFA.h"
#include "py.h"
#include "sp.h"
#include "ime.h"

extern Display *dpy;
extern int      iScreen;
extern int      MAINWND_WIDTH;
extern int      iMainWindowX;
extern int      iMainWindowY;
extern int      iInputWindowX;
extern int      iInputWindowY;
extern int      iTempInputWindowX;
extern int      iTempInputWindowY;
extern int      iInputWindowWidth;
extern int      iInputWindowHeight;

extern int      iMaxCandWord;
extern Bool     _3DEffectMainWindow;
extern _3D_EFFECT _3DEffectInputWindow;
extern WINDOW_COLOR inputWindowColor;
extern WINDOW_COLOR mainWindowColor;
extern MESSAGE_COLOR IMNameColor[];
extern MESSAGE_COLOR messageColor[];
extern MESSAGE_COLOR inputWindowLineColor;
extern MESSAGE_COLOR mainWindowLineColor;
extern MESSAGE_COLOR cursorColor;
extern ENTER_TO_DO enterToDo;

extern HOTKEYS  hkTrigger[];
extern HOTKEYS  hkGBK[];
extern HOTKEYS  hkCorner[];
extern HOTKEYS  hkPunc[];
extern HOTKEYS  hkPrevPage[];
extern HOTKEYS  hkNextPage[];
extern HOTKEYS  hkWBAddPhrase[];
extern HOTKEYS  hkWBDelPhrase[];
extern HOTKEYS  hkWBAdjustOrder[];
extern HOTKEYS  hkPYAddFreq[];
extern HOTKEYS  hkPYDelFreq[];
extern HOTKEYS  hkPYDelUserPhr[];
extern HOTKEYS  hkLegend[];
extern HOTKEYS	hkTrack[];

extern KEYCODE  switchKey;
extern XIMTriggerKey *Trigger_Keys;
extern INT8     iTriggerKeyCount;

extern Bool     bUseGBK;
extern Bool     bEngPuncAfterNumber;
extern Bool     bAutoHideInputWindow;
extern XColor   colorArrow;
extern Bool	bTrackCursor;
extern HIDE_MAINWINDOW hideMainWindow;
extern Bool     bCompactMainWindow;
extern HIDE_MAINWINDOW hideMainWindow;
extern int      iFontSize;
extern int      iMainWindowFontSize;

extern Bool     bChnPunc;
extern Bool     bCorner;
extern Bool     bUseLegend;

extern Bool     bPYCreateAuto;
extern Bool     bPYSaveAutoAsPhrase;
extern Bool     bPhraseTips;
extern Bool     bEngAfterSemicolon;
extern Bool     bEngAfterCap;

extern Bool     bFullPY;
extern Bool     bDisablePagingInLegend;

extern int      i2ndSelectKey;
extern int      i3rdSelectKey;

extern char     strFontName[];
extern char     strFontEnName[];

extern ADJUSTORDER baseOrder;
extern ADJUSTORDER phraseOrder;
extern ADJUSTORDER freqOrder;

extern INT8     iIMIndex;
extern Bool     bLocked;

extern MHPY     MHPY_C[];
extern MHPY     MHPY_S[];

extern Bool     bUsePinyin;
extern Bool     bUseSP;
extern Bool     bUseQW;
extern Bool     bUseTable;

extern Bool	bLumaQQ;
extern char	cPYYCDZ[];

extern Bool	bDoubleSwitchKey;

#ifdef _USE_XFT
extern Bool     bUseAA;
#else
extern char     strUserLocale[];
#endif

/*
#if defined(DARWIN)*/
/* function to reverse byte order for integer
this is required for Mac machine*/
/*int ReverseInt (unsigned int pc_int)
{
    int             mac_int;
    unsigned char  *p;

    mac_int = pc_int;
    p = (unsigned char *) &pc_int;
    mac_int = (p[3] << 24) + (p[2] << 16) + (p[1] << 8) + p[0];
    return mac_int;
}
#endif
*/
/*
 * ȡûļ
 */
void LoadConfig (Bool bMode)
{
    FILE           *fp;
    char            str[PATH_MAX], *pstr;
    char            strPath[PATH_MAX];
    int             i;
    int             r, g, b;	//

    strcpy (strPath, (char *) getenv ("HOME"));
    strcat (strPath, "/.fcitx/config");

    fp = fopen (strPath, "rt");

    if (!fp) {
	SaveConfig ();
	LoadConfig (True);	//Ĭֵ
	return;
    }

    for (;;) {
	if (!fgets (str, PATH_MAX, fp))
	    break;

	i = strlen (str) - 1;
	while (str[i] == ' ' || str[i] == '\n')
	    str[i--] = '\0';

	pstr = str;
	if (*pstr == ' ')
	    pstr++;
	if (pstr[0] == '#')
	    continue;

	if (strstr (pstr, "ʾ()=") && bMode) {
	    pstr += 13;
	    strcpy (strFontName, pstr);
	}
	if (strstr (pstr, "ʾ(Ӣ)=") && bMode) {
	    pstr += 13;
	    strcpy (strFontEnName, pstr);
	}
	else if (strstr (pstr, "ʾС=") && bMode) {
	    pstr += 13;
	    iFontSize = atoi (pstr);
	}
	else if (strstr (pstr, "С=") && bMode) {
	    pstr += 15;
	    iMainWindowFontSize = atoi (pstr);
	}
#ifdef _USE_XFT
	else if (strstr (pstr, "ǷʹAA=") && bMode) {
	    pstr += 15;
	    bUseAA = atoi (pstr);
	}
#else
	else if (strstr (pstr, "=") && bMode) {
	    pstr += 9;
	    strcpy (strUserLocale, pstr);
	}
#endif
	else if (strstr (pstr, "ѡʸ=")) {
	    pstr += 11;
	    iMaxCandWord = atoi (pstr);
	    if (iMaxCandWord > 10)
		iMaxCandWord = MAX_CAND_WORD;
	}
	else if (strstr (pstr, "ֺǷ=")) {
	    pstr += 17;
	    bEngPuncAfterNumber = atoi (pstr);
	}
	else if (strstr (pstr, "LumaQQ֧=") ) {
	    pstr += 11;
	    bLumaQQ = atoi(pstr);
	}
	else if (strstr (pstr, "Ƿʹ3D=")) {
	    pstr += 21;
	    _3DEffectMainWindow = atoi (pstr);
	}
	else if (strstr (pstr, "ʹ3D=")) {
	    pstr += 17;
	    _3DEffectInputWindow = (_3D_EFFECT)atoi (pstr);
	}
	else if (strstr (pstr, "ǷԶ=")) {
	    pstr += 19;
	    bAutoHideInputWindow = atoi (pstr);
	}
	else if (strstr (pstr, "ģʽ=")) {
	    pstr += 15;
	    hideMainWindow = (HIDE_MAINWINDOW) atoi (pstr);
	}
	else if (strstr (pstr, "ɫ=") && bMode) {
	    pstr += 7;
	    sscanf (pstr, "%d %d %d\n", &r, &g, &b);
	    cursorColor.color.red = (r << 8);
	    cursorColor.color.green = (g << 8);
	    cursorColor.color.blue = (b << 8);
	}
	else if (strstr (pstr, "ڱɫ=") && bMode) {
	    pstr += 13;
	    sscanf (pstr, "%d %d %d\n", &r, &g, &b);
	    mainWindowColor.backColor.red = (r << 8);
	    mainWindowColor.backColor.green = (g << 8);
	    mainWindowColor.backColor.blue = (b << 8);
	}
	else if (strstr (pstr, "ɫ=") && bMode) {
	    pstr += 13;
	    sscanf (pstr, "%d %d %d\n", &r, &g, &b);
	    mainWindowLineColor.color.red = (r << 8);
	    mainWindowLineColor.color.green = (g << 8);
	    mainWindowLineColor.color.blue = (b << 8);
	}
	else if (strstr (pstr, "뷨ɫ=") && bMode) {
	    int             r1, r2, g1, g2, b1, b2;

	    pstr += 19;
	    sscanf (pstr, "%d %d %d %d %d %d %d %d %d", &r, &g, &b, &r1, &g1, &b1, &r2, &g2, &b2);
	    IMNameColor[0].color.red = (r << 8);
	    IMNameColor[0].color.green = (g << 8);
	    IMNameColor[0].color.blue = (b << 8);
	    IMNameColor[1].color.red = (r1 << 8);
	    IMNameColor[1].color.green = (g1 << 8);
	    IMNameColor[1].color.blue = (b1 << 8);
	    IMNameColor[2].color.red = (r2 << 8);
	    IMNameColor[2].color.green = (g2 << 8);
	    IMNameColor[2].color.blue = (b2 << 8);
	}
	else if (strstr (pstr, "봰ɫ=") && bMode) {
	    pstr += 13;
	    sscanf (pstr, "%d %d %d\n", &r, &g, &b);
	    inputWindowColor.backColor.red = (r << 8);
	    inputWindowColor.backColor.green = (g << 8);
	    inputWindowColor.backColor.blue = (b << 8);
	}
	else if (strstr (pstr, "봰ʾɫ=") && bMode) {
	    pstr += 13;
	    sscanf (pstr, "%d %d %d\n", &r, &g, &b);
	    messageColor[0].color.red = (r << 8);
	    messageColor[0].color.green = (g << 8);
	    messageColor[0].color.blue = (b << 8);
	}
	else if (strstr (pstr, "봰ûɫ=") && bMode) {
	    pstr += 17;
	    sscanf (pstr, "%d %d %d\n", &r, &g, &b);
	    messageColor[1].color.red = (r << 8);
	    messageColor[1].color.green = (g << 8);
	    messageColor[1].color.blue = (b << 8);
	}
	else if (strstr (pstr, "봰ɫ=") && bMode) {
	    pstr += 13;
	    sscanf (pstr, "%d %d %d\n", &r, &g, &b);
	    messageColor[2].color.red = (r << 8);
	    messageColor[2].color.green = (g << 8);
	    messageColor[2].color.blue = (b << 8);
	}
	else if (strstr (pstr, "봰һѡɫ=") && bMode) {
	    pstr += 21;
	    sscanf (pstr, "%d %d %d\n", &r, &g, &b);
	    messageColor[3].color.red = (r << 8);
	    messageColor[3].color.green = (g << 8);
	    messageColor[3].color.blue = (b << 8);
	}
	else if (strstr (pstr, "봰ûɫ=") && bMode) {
	    pstr += 17;
	    sscanf (pstr, "%d %d %d\n", &r, &g, &b);
	    messageColor[4].color.red = (r << 8);
	    messageColor[4].color.green = (g << 8);
	    messageColor[4].color.blue = (b << 8);
	}
	else if (strstr (pstr, "봰ʾɫ=") && bMode) {
	    pstr += 17;
	    sscanf (pstr, "%d %d %d\n", &r, &g, &b);
	    messageColor[5].color.red = (r << 8);
	    messageColor[5].color.green = (g << 8);
	    messageColor[5].color.blue = (b << 8);
	}
	else if (strstr (pstr, "봰ıɫ=") && bMode) {
	    pstr += 17;
	    sscanf (pstr, "%d %d %d\n", &r, &g, &b);
	    messageColor[6].color.red = (r << 8);
	    messageColor[6].color.green = (g << 8);
	    messageColor[6].color.blue = (b << 8);
	}
	else if (strstr (pstr, "봰ɫ=") && bMode) {
	    pstr += 13;
	    sscanf (pstr, "%d %d %d\n", &r, &g, &b);
	    inputWindowLineColor.color.red = (r << 8);
	    inputWindowLineColor.color.green = (g << 8);
	    inputWindowLineColor.color.blue = (b << 8);
	}
	else if (strstr (pstr, "봰ͷɫ=") && bMode) {
	    pstr += 13;
	    sscanf (pstr, "%d %d %d\n", &r, &g, &b);
	    colorArrow.red = (r << 8);
	    colorArrow.green = (g << 8);
	    colorArrow.blue = (b << 8);
	}

	else if (strstr (pstr, "/ر뷨=") && bMode) {
	    pstr += 16;
	    SetTriggerKeys (pstr);
	    SetHotKey (pstr, hkTrigger);
	}
	else if (strstr (pstr, "ӢĿл=")) {
	    pstr += 17;
	    SetSwitchKey (pstr);
	}
	else if (strstr (pstr, "˫Ӣл=")) {
	    pstr += 15;
	    bDoubleSwitchKey = atoi (pstr);
	}
	else if (strstr (pstr, "GBK֧=")) {
	    pstr += 8;
	    SetHotKey (pstr, hkGBK);
	}
	else if (strstr (pstr, "ֺӢ=")) {
	    pstr += 13;
	    bEngAfterSemicolon = atoi (pstr);
	}
	else if (strstr (pstr, "дĸӢ=")) {
	    pstr += 17;
	    bEngAfterCap = atoi (pstr);
	}
	else if (strstr (pstr, "뷽ʽֹҳ=")) {
	    pstr += 17;
	    bDisablePagingInLegend = atoi (pstr);
	}
	else if (strstr (pstr, "֧=")) {
	    pstr += 9;
	    SetHotKey (pstr, hkLegend);
	}
	else if (strstr (pstr, "EnterΪ=")) {
	    pstr += 12;
	    enterToDo = (ENTER_TO_DO) atoi (pstr);
	}
	else if (strstr (pstr, "ȫ=")) {
	    pstr += 7;
	    SetHotKey (pstr, hkCorner);
	}
	else if (strstr (pstr, "ı=")) {
	    pstr += 9;
	    SetHotKey (pstr, hkPunc);
	}
	else if (strstr (pstr, "һҳ=")) {
	    pstr += 7;
	    SetHotKey (pstr, hkPrevPage);
	}
	else if (strstr (pstr, "һҳ=")) {
	    pstr += 7;
	    SetHotKey (pstr, hkNextPage);
	}
	else if (strstr (pstr, "ڶѡѡ=")) {
	    pstr += 19;
	    if (!strcasecmp (pstr, "SHIFT")) {
		i2ndSelectKey = 50;	//SHIFTɨ
		i3rdSelectKey = 62;	//SHIFTɨ
	    }
	    else if (!strcasecmp (pstr, "CTRL")) {
		i2ndSelectKey = 37;	//CTRLɨ
		i3rdSelectKey = 109;	//CTRLɨ
	    }
	}

	else if (strstr (pstr, "ʹƴ=")) {
	    pstr += 9;
	    bUsePinyin = atoi (pstr);
	}
	else if (strstr (pstr, "ʹ˫ƴ=")) {
	    pstr += 9;
	    bUseSP = atoi (pstr);
	}
	else if (strstr (pstr, "ʹλ=")) {
	    pstr += 9;
	    bUseQW = atoi (pstr);
	}
	else if (strstr (pstr, "ʹ=")) {
	    pstr += 9;
	    bUseTable = atoi (pstr);
	}
	else if (strstr (pstr, "ʾʿеĴ=")) {
	    pstr += 17;
	    bPhraseTips = atoi (pstr);
	}

	else if (strstr (str, "ʹȫƴ=")) {
	    pstr += 9;
	    bFullPY = atoi (pstr);
	}
	else if (strstr (str, "ƴԶ=")) {
	    pstr += 13;
	    bPYCreateAuto = atoi (pstr);
	}
	else if (strstr (str, "Զ=")) {
	    pstr += 13;
	    bPYSaveAutoAsPhrase = atoi (pstr);
	}
	else if (strstr (str, "ƴ=")) {
	    pstr += 15;
	    SetHotKey (pstr, hkPYAddFreq);
	}
	else if (strstr (str, "ɾƴ=")) {
	    pstr += 15;
	    SetHotKey (pstr, hkPYDelFreq);
	}
	else if (strstr (str, "ɾƴû=")) {
	    pstr += 17;
	    SetHotKey (pstr, hkPYDelUserPhr);
	}
	else if (strstr (str, "ƴԴʶּ=")) {
	    pstr += 15;
	    cPYYCDZ[0] = pstr[0];
	    cPYYCDZ[1] = pstr[1];
	}
	else if (strstr (str, "ƴʽ=")) {
	    pstr += 21;
	    baseOrder = (ADJUSTORDER) atoi (pstr);
	}
	else if (strstr (str, "ƴʽ=")) {
	    pstr += 21;
	    phraseOrder = (ADJUSTORDER) atoi (pstr);
	}
	else if (strstr (str, "ƴôʽ=")) {
	    pstr += 23;
	    freqOrder = (ADJUSTORDER) atoi (pstr);
	}
	else if (strstr (str, "Ƿģanang=")) {
	    pstr += 16;
	    MHPY_C[0].bMode = atoi (pstr);
	    MHPY_S[5].bMode = atoi (pstr);
	}
	else if (strstr (str, "Ƿģeneng=")) {
	    pstr += 16;
	    MHPY_C[1].bMode = atoi (pstr);
	}
	else if (strstr (str, "Ƿģianiang=")) {
	    pstr += 18;
	    MHPY_C[2].bMode = atoi (pstr);
	}
	else if (strstr (str, "Ƿģining=")) {
	    pstr += 16;
	    MHPY_C[3].bMode = atoi (pstr);
	}
	else if (strstr (str, "Ƿģouu=")) {
	    pstr += 14;
	    MHPY_C[4].bMode = atoi (pstr);
	}
	else if (strstr (str, "Ƿģuanuang=")) {
	    pstr += 18;
	    MHPY_C[5].bMode = atoi (pstr);
	}
	else if (strstr (str, "Ƿģcch=")) {
	    pstr += 14;
	    MHPY_S[0].bMode = atoi (pstr);
	}
	else if (strstr (str, "Ƿģfh=")) {
	    pstr += 13;
	    MHPY_S[1].bMode = atoi (pstr);
	}
	else if (strstr (str, "Ƿģln=")) {
	    pstr += 13;
	    MHPY_S[2].bMode = atoi (pstr);
	}
	else if (strstr (str, "Ƿģssh=")) {
	    pstr += 14;
	    MHPY_S[3].bMode = atoi (pstr);
	}
	else if (strstr (str, "Ƿģzzh=")) {
	    pstr += 14;
	    MHPY_S[4].bMode = atoi (pstr);
	}
    }

    fclose (fp);

    if (!Trigger_Keys) {
	iTriggerKeyCount = 0;
	Trigger_Keys = (XIMTriggerKey *) malloc (sizeof (XIMTriggerKey) * (iTriggerKeyCount + 2));
	Trigger_Keys[0].keysym = XK_space;
	Trigger_Keys[0].modifier = ControlMask;
	Trigger_Keys[0].modifier_mask = ControlMask;
	Trigger_Keys[1].keysym = 0;
	Trigger_Keys[1].modifier = 0;
	Trigger_Keys[1].modifier_mask = 0;
    }
}

void SaveConfig (void)
{
    FILE           *fp;
    char            strPath[PATH_MAX];

    strcpy (strPath, (char *) getenv ("HOME"));
    strcat (strPath, "/.fcitx/");

    if (access (strPath, 0))
	mkdir (strPath, S_IRWXU);

    strcat (strPath, "config");
    fp = fopen (strPath, "wt");
    if (!fp) {
	fprintf (stderr, "\n޷ļ config\n");
	return;
    }

    fprintf (fp, "[]\n");
    fprintf (fp, "ʾ()=%s\n", strFontName);
    fprintf (fp, "ʾ(Ӣ)=%s\n", strFontEnName);
    fprintf (fp, "ʾС=%d\n", iFontSize);
    fprintf (fp, "С=%d\n", iMainWindowFontSize);
#ifdef _USE_XFT
    fprintf (fp, "ǷʹAA=%d\n", bUseAA);
#else
    if ( strUserLocale[0] )
    	fprintf (fp, "=%s\n", strUserLocale);
    else
    	fprintf (fp, "#=zh_CN.gb2312\n");
#endif

    fprintf (fp, "\n[]\n");
    fprintf (fp, "ֺǷ=%d\n", bEngPuncAfterNumber);
    fprintf (fp, "EnterΪ=%d\n", enterToDo);
    fprintf (fp, "ֺӢ=%d\n", bEngAfterSemicolon);
    fprintf (fp, "дĸӢ=%d\n", bEngAfterCap);
    fprintf (fp, "뷽ʽֹҳ=%d\n", bDisablePagingInLegend);
    fprintf (fp, "LumaQQ֧=%d\n", bLumaQQ);

    fprintf (fp, "\n[]\n");
    fprintf (fp, "ѡʸ=%d\n", iMaxCandWord);
    fprintf (fp, "Ƿʹ3D=%d\n", _3DEffectMainWindow);
    fprintf (fp, "ʹ3D=%d\n", _3DEffectInputWindow);
    fprintf (fp, "ģʽ=%d\n", (int) hideMainWindow);
    fprintf (fp, "ǷԶ=%d\n", bAutoHideInputWindow);
    
    fprintf (fp, "ɫ=%d %d %d\n", cursorColor.color.red >> 8, cursorColor.color.green >> 8, cursorColor.color.blue >> 8);
    fprintf (fp, "ڱɫ=%d %d %d\n", mainWindowColor.backColor.red >> 8, mainWindowColor.backColor.green >> 8, mainWindowColor.backColor.blue >> 8);
    fprintf (fp, "ɫ=%d %d %d\n", mainWindowLineColor.color.red >> 8, mainWindowLineColor.color.green >> 8, mainWindowLineColor.color.blue >> 8);
    fprintf (fp, "뷨ɫ=%d %d %d %d %d %d %d %d %d\n", IMNameColor[0].color.red >> 8, IMNameColor[0].color.green >> 8, IMNameColor[0].color.blue >> 8, IMNameColor[1].color.red >> 8, IMNameColor[1].color.green >> 8,
	     IMNameColor[1].color.blue >> 8, IMNameColor[2].color.red >> 8, IMNameColor[2].color.green >> 8, IMNameColor[2].color.blue >> 8);
    fprintf (fp, "봰ɫ=%d %d %d\n", inputWindowColor.backColor.red >> 8, inputWindowColor.backColor.green >> 8, inputWindowColor.backColor.blue >> 8);
    fprintf (fp, "봰ʾɫ=%d %d %d\n", messageColor[0].color.red >> 8, messageColor[0].color.green >> 8, messageColor[0].color.blue >> 8);
    fprintf (fp, "봰ûɫ=%d %d %d\n", messageColor[1].color.red >> 8, messageColor[1].color.green >> 8, messageColor[1].color.blue >> 8);
    fprintf (fp, "봰ɫ=%d %d %d\n", messageColor[2].color.red >> 8, messageColor[2].color.green >> 8, messageColor[2].color.blue >> 8);
    fprintf (fp, "봰һѡɫ=%d %d %d\n", messageColor[3].color.red >> 8, messageColor[3].color.green >> 8, messageColor[3].color.blue >> 8);
    fprintf (fp, "#ɫֵֻƴеû\n");
    fprintf (fp, "봰ûɫ=%d %d %d\n", messageColor[4].color.red >> 8, messageColor[4].color.green >> 8, messageColor[4].color.blue >> 8);
    fprintf (fp, "봰ʾɫ=%d %d %d\n", messageColor[5].color.red >> 8, messageColor[5].color.green >> 8, messageColor[5].color.blue >> 8);
    fprintf (fp, "#ʡƴĵ/ϵͳʹøɫ\n");
    fprintf (fp, "봰ıɫ=%d %d %d\n", messageColor[6].color.red >> 8, messageColor[6].color.green >> 8, messageColor[6].color.blue >> 8);
    fprintf (fp, "봰ɫ=%d %d %d\n", inputWindowLineColor.color.red >> 8, inputWindowLineColor.color.green >> 8, inputWindowLineColor.color.blue >> 8);
    fprintf (fp, "봰ͷɫ=%d %d %d\n", colorArrow.red >> 8, colorArrow.green >> 8, colorArrow.blue >> 8);

    fprintf (fp, "\n#ˡӢĿл⣬ȼΪмÿոָ\n");
    fprintf (fp, "[ȼ]\n");
    fprintf (fp, "/ر뷨=CTRL_SPACE\n");
    fprintf (fp, "#ӢĿл ΪL_CTRL R_CTRL L_SHIFT R_SHIFT\n");
    fprintf (fp, "ӢĿл=L_CTRL\n");
    fprintf (fp, "˫Ӣл=%d\n", bDoubleSwitchKey);
    fprintf (fp, "=CTRL_K\n");
    fprintf (fp, "GBK֧=CTRL_M\n");
    fprintf (fp, "֧=CTRL_L\n");
    fprintf (fp, "ȫ=SHIFT_SPACE\n");
    fprintf (fp, "ı=ALT_SPACE\n");
    fprintf (fp, "һҳ=-\n");
    fprintf (fp, "һҳ==\n");
    fprintf (fp, "ڶѡѡ=SHIFT\n");

    fprintf (fp, "\n[뷨]\n");
    fprintf (fp, "ʹƴ=%d\n", bUsePinyin);
    fprintf (fp, "ʹ˫ƴ=%d\n", bUseSP);
    fprintf (fp, "ʹλ=%d\n", bUseQW);
    fprintf (fp, "ʹ=%d\n", bUseTable);
    fprintf (fp, "ʾʿеĴ=%d\n", bPhraseTips);

    fprintf (fp, "\n[ƴ]\n");
    fprintf (fp, "ʹȫƴ=%d\n", bFullPY);
    fprintf (fp, "ƴԶ=%d\n", bPYCreateAuto);
    fprintf (fp, "Զ=%d\n", bPYSaveAutoAsPhrase);
    fprintf (fp, "ƴ=CTRL_8\n");
    fprintf (fp, "ɾƴ=CTRL_7\n");
    fprintf (fp, "ɾƴû=CTRL_DELETE\n");
    fprintf (fp, "#ƴԴʶּȺźӼҪпո\n");
    fprintf (fp, "ƴԴʶּ=%c%c\n", cPYYCDZ[0], cPYYCDZ[1]);
    fprintf (fp, "#ʽ˵0-->  1-->ٵ  2-->Ƶʵ\n");
    fprintf (fp, "ƴʽ=%d\n", baseOrder);
    fprintf (fp, "ƴʽ=%d\n", phraseOrder);
    fprintf (fp, "ƴôʽ=%d\n", freqOrder);
    fprintf (fp, "Ƿģanang=%d\n", MHPY_C[0].bMode);
    fprintf (fp, "Ƿģeneng=%d\n", MHPY_C[1].bMode);
    fprintf (fp, "Ƿģianiang=%d\n", MHPY_C[2].bMode);
    fprintf (fp, "Ƿģining=%d\n", MHPY_C[3].bMode);
    fprintf (fp, "Ƿģouu=%d\n", MHPY_C[4].bMode);
    fprintf (fp, "Ƿģuanuang=%d\n", MHPY_C[5].bMode);
    fprintf (fp, "Ƿģcch=%d\n", MHPY_S[0].bMode);
    fprintf (fp, "Ƿģfh=%d\n", MHPY_S[1].bMode);
    fprintf (fp, "Ƿģln=%d\n", MHPY_S[2].bMode);
    fprintf (fp, "Ƿģssh=%d\n", MHPY_S[3].bMode);
    fprintf (fp, "Ƿģzzh=%d\n", MHPY_S[4].bMode);

    fclose (fp);
}

void LoadProfile (void)
{
    FILE           *fp;
    char            str[PATH_MAX], *pstr;
    char            strPath[PATH_MAX];
    int             i;
    Bool            bRetVal;

    iMainWindowX = MAINWND_STARTX;
    iMainWindowY = MAINWND_STARTY;
    iInputWindowX = INPUTWND_STARTX;
    iInputWindowY = INPUTWND_STARTY;

    bRetVal = False;
    strcpy (strPath, (char *) getenv ("HOME"));
    strcat (strPath, "/.fcitx/profile");

    fp = fopen (strPath, "rt");

    if (fp) {
	for (;;) {
	    if (!fgets (str, PATH_MAX, fp))
		break;

	    i = strlen (str) - 1;
	    while (str[i] == ' ' || str[i] == '\n')
		str[i--] = '\0';

	    pstr = str;

	    if (strstr (str, "汾=")) {
		pstr += 5;

		if (!strcasecmp (FCITX_VERSION, pstr))
		    bRetVal = True;
	    }
	    else if (strstr (str, "λX=")) {
		pstr += 12;
		iMainWindowX = atoi (pstr);
		if (iMainWindowX < 0)
		    iMainWindowX = 0;
		else if ((iMainWindowX + MAINWND_WIDTH) > DisplayWidth (dpy, iScreen))
		    iMainWindowX = DisplayWidth (dpy, iScreen) - MAINWND_WIDTH;
	    }
	    else if (strstr (str, "λY=")) {
		pstr += 12;
		iMainWindowY = atoi (pstr);
		if (iMainWindowY < 0)
		    iMainWindowY = 0;
		else if ((iMainWindowY + MAINWND_HEIGHT) > DisplayHeight (dpy, iScreen))
		    iMainWindowY = DisplayHeight (dpy, iScreen) - MAINWND_HEIGHT;
	    }
	    else if (strstr (str, "봰λX=")) {
		pstr += 14;
		iInputWindowX = atoi (pstr);
		if (iInputWindowX < 0)
		    iInputWindowX = 0;
		else if ((iInputWindowX + iInputWindowWidth) > DisplayWidth (dpy, iScreen))
		    iInputWindowX = DisplayWidth (dpy, iScreen) - iInputWindowWidth - 3;
	    }
	    else if (strstr (str, "봰λY=")) {
		pstr += 14;
		iInputWindowY = atoi (pstr);
		if (iInputWindowY < 0)
		    iInputWindowY = 0;
		else if ((iInputWindowY + INPUTWND_HEIGHT) > DisplayHeight (dpy, iScreen))
		    iInputWindowY = DisplayHeight (dpy, iScreen) - iInputWindowHeight;
	    }
	    else if (strstr (str, "Ƿȫ=")) {
		pstr += 9;
		bCorner = atoi (pstr);
	    }
	    else if (strstr (str, "Ƿı=")) {
		pstr += 13;
		bChnPunc = atoi (pstr);
	    }
	    else if (strstr (str, "ǷGBK=")) {
		pstr += 8;
		bUseGBK = atoi (pstr);
	    }
	    else if (strstr (str, "Ƿ=")) {
		pstr += 13;
		bTrackCursor = atoi (pstr);
	    }
	    else if (strstr (str, "Ƿ=")) {
		pstr += 9;
		bUseLegend = atoi (pstr);
	    }
	    else if (strstr (str, "ǰ뷨=")) {
		pstr += 11;
		iIMIndex = atoi (pstr);
	    }
	    else if (strstr (str, "ֹüл=")) {
		pstr += 15;
		bLocked = atoi (pstr);
	    }
	    else if (strstr (str, "ڼģʽ=")) {
		pstr += 15;
		bCompactMainWindow = atoi (pstr);
	    }
	}

	fclose (fp);
    }

    if (!bRetVal) {
	SaveConfig ();
	SaveProfile ();
    }
}

void SaveProfile (void)
{
    FILE           *fp;
    char            strPath[PATH_MAX];

    strcpy (strPath, (char *) getenv ("HOME"));
    strcat (strPath, "/.fcitx/");

    if (access (strPath, 0))
	mkdir (strPath, S_IRWXU);

    strcat (strPath, "profile");
    fp = fopen (strPath, "wt");

    if (!fp) {
	fprintf (stderr, "\n޷ļ profile!\n");
	return;
    }

    fprintf (fp, "汾=%s\n", FCITX_VERSION);
    fprintf (fp, "λX=%d\n", iMainWindowX);
    fprintf (fp, "λY=%d\n", iMainWindowY);
    fprintf (fp, "봰λX=%d\n", iInputWindowX);
    fprintf (fp, "봰λY=%d\n", iInputWindowY);
    fprintf (fp, "Ƿȫ=%d\n", bCorner);
    fprintf (fp, "Ƿı=%d\n", bChnPunc);
    fprintf (fp, "ǷGBK=%d\n", bUseGBK);
    fprintf (fp, "Ƿ=%d\n", bTrackCursor);
    fprintf (fp, "Ƿ=%d\n", bUseLegend);
    fprintf (fp, "ǰ뷨=%d\n", iIMIndex);
    fprintf (fp, "ֹüл=%d\n", bLocked);
    fprintf (fp, "ڼģʽ=%d\n", bCompactMainWindow);
    
    iTempInputWindowX = iInputWindowX;
    iTempInputWindowY = iInputWindowY;

    fclose (fp);
}

void SetHotKey (char *strKeys, HOTKEYS * hotkey)
{
    char           *p;
    char            strKey[30];
    int             i, j;

    p = strKeys;

    while (*p == ' ')
	p++;
    i = 0;
    while (p[i] != ' ' && p[i] != '\0')
	i++;
    strncpy (strKey, p, i);
    strKey[i] = '\0';
    p += i + 1l;
    j = ParseKey (strKey);
    if (j != -1)
	hotkey[0] = j;
    if (j == -1)
	j = 0;
    else
	j = 1;

    i = 0;
    while (p[i] != ' ' && p[i] != '\0')
	i++;
    if (p[0]) {
	strncpy (strKey, p, i);
	strKey[i] = '\0';

	i = ParseKey (strKey);
	if (i == -1)
	    i = 0;
    }
    else
	i = 0;

    hotkey[j] = i;
}

/*
 * ļж
 * ע:ļеĿҲΪһд
 */
int CalculateRecordNumber (FILE * fpDict)
{
    char            strText[101];
    int             nNumber = 0;

    for (;;) {
	if (!fgets (strText, 100, fpDict))
	    break;

	nNumber++;
    }
    rewind (fpDict);

    return nNumber;
}

void SetSwitchKey (char *str)
{
    if (!strcasecmp (str, "R_CTRL"))
	switchKey = R_CTRL;
    else if (!strcasecmp (str, "R_SHIFT"))
	switchKey = R_SHIFT;
    else if (!strcasecmp (str, "L_SHIFT"))
	switchKey = L_SHIFT;
    else
	switchKey = L_CTRL;
}

void SetTriggerKeys (char *str)
{
    int             i;
    char            strKey[2][30];
    char           *p;

    //жû˼ȼΪ2    
    p = str;

    i = 0;
    iTriggerKeyCount = 0;
    while (*p) {
	if (*p == ' ') {
	    iTriggerKeyCount++;
	    while (*p == ' ')
		p++;
	    strcpy (strKey[1], p);
	    break;
	}
	else
	    strKey[0][i++] = *p++;
    }
    strKey[0][i] = '\0';

    Trigger_Keys = (XIMTriggerKey *) malloc (sizeof (XIMTriggerKey) * (iTriggerKeyCount + 2));
    for (i = 0; i <= (iTriggerKeyCount + 1); i++) {
	Trigger_Keys[i].keysym = 0;
	Trigger_Keys[i].modifier = 0;
	Trigger_Keys[i].modifier_mask = 0;
    }

    for (i = 0; i <= iTriggerKeyCount; i++) {
	if (strstr (strKey[i], "CTRL_")) {
	    Trigger_Keys[i].modifier = Trigger_Keys[i].modifier | ControlMask;
	    Trigger_Keys[i].modifier_mask = Trigger_Keys[i].modifier_mask | ControlMask;
	}
	else if (strstr (strKey[i], "SHIFT_")) {
	    Trigger_Keys[i].modifier = Trigger_Keys[i].modifier | ShiftMask;
	    Trigger_Keys[i].modifier_mask = Trigger_Keys[i].modifier_mask | ShiftMask;
	}
	else if (strstr (strKey[i], "ALT_")) {
	    Trigger_Keys[i].modifier = Trigger_Keys[i].modifier | Mod1Mask;
	    Trigger_Keys[i].modifier_mask = Trigger_Keys[i].modifier_mask | Mod1Mask;
	}

	if (Trigger_Keys[i].modifier == 0) {
	    Trigger_Keys[i].modifier = ControlMask;
	    Trigger_Keys[i].modifier_mask = ControlMask;
	}

	p = strKey[i] + strlen (strKey[i]) - 1;
	while (*p != '_') {
	    p--;
	    if (p == strKey[i] || (p == strKey[i] + strlen (strKey[i]) - 1)) {
		Trigger_Keys = (XIMTriggerKey *) malloc (sizeof (XIMTriggerKey) * (iTriggerKeyCount + 2));
		Trigger_Keys[i].keysym = XK_space;
		return;
	    }
	}
	p++;

	if (strlen (p) == 1)
	    Trigger_Keys[i].keysym = tolower (*p);
	else if (!strcasecmp (p, "LCTRL"))
	    Trigger_Keys[i].keysym = XK_Control_L;
	else if (!strcasecmp (p, "RCTRL"))
	    Trigger_Keys[i].keysym = XK_Control_R;
	else if (!strcasecmp (p, "LSHIFT"))
	    Trigger_Keys[i].keysym = XK_Shift_L;
	else if (!strcasecmp (p, "RSHIFT"))
	    Trigger_Keys[i].keysym = XK_Shift_R;
	else if (!strcasecmp (p, "LALT"))
	    Trigger_Keys[i].keysym = XK_Alt_L;
	else if (!strcasecmp (p, "RALT"))
	    Trigger_Keys[i].keysym = XK_Alt_R;
	else
	    Trigger_Keys[i].keysym = XK_space;
    }
}

Bool CheckHZCharset (char *strHZ)
{
    if (!bUseGBK) {
	//GB2312ĺֱΪһֽڵֵ0xA10xFE֮(ʵΪ0xF7)ڶֽڵֵ0xA10xFE֮
	//ڲ鵽˵һúʵ
	int             i;

	for (i = 0; i < strlen (strHZ); i++) {
	    if ((unsigned char) strHZ[i] < (unsigned char) 0xA1 || (unsigned char) strHZ[i] > (unsigned char) 0xF7 || (unsigned char) strHZ[i + 1] < (unsigned char) 0xA1 || (unsigned char) strHZ[i + 1] > (unsigned char) 0xFE)
		return False;
	    i++;
	}
    }

    return True;
}
