/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.codec;

import loci.formats.FormatException;
import loci.formats.codec.BaseCodec;
import loci.formats.codec.BitBuffer;
import loci.formats.codec.BitWriter;
import loci.formats.codec.Codec;

public class NikonCodec
extends BaseCodec
implements Codec {
    private static final int[] NIKON_TREE = new int[]{0, 1, 5, 1, 1, 1, 1, 1, 1, 2, 0, 0, 0, 0, 0, 0, 5, 4, 3, 6, 2, 7, 1, 0, 8, 9, 11, 10, 12};

    public byte[] compress(byte[] data, int x, int y, int[] dims, Object options) throws FormatException {
        throw new FormatException("Nikon Compression not currently supported");
    }

    public byte[] decompress(byte[] input, Object options) throws FormatException {
        BitWriter out = new BitWriter(input.length);
        BitBuffer bb = new BitBuffer(input);
        boolean eof = false;
        while (!eof) {
            boolean codeFound = false;
            int code = 0;
            int bitsRead = 0;
            block1: while (!codeFound) {
                int bit = bb.getBits(1);
                if (bit == -1) {
                    eof = true;
                    break;
                }
                ++bitsRead;
                code >>= 1;
                code += bit;
                for (int i = 16; i < NIKON_TREE.length; ++i) {
                    if (code != NIKON_TREE[i]) continue;
                    int ndx = i;
                    int count = 0;
                    while (ndx > 16) {
                        ndx -= NIKON_TREE[count];
                        ++count;
                    }
                    if (ndx < 16) {
                        --count;
                    }
                    if (bitsRead != count + 1) continue;
                    codeFound = true;
                    i = NIKON_TREE.length;
                    continue block1;
                }
            }
            while (code > 0) {
                out.write(bb.getBits(1), 1);
                --code;
            }
        }
        byte[] b = out.toByteArray();
        return b;
    }
}

