/*
 *	fhist - file history and comparison tools
 *	Copyright (C) 1998 Peter Miller;
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 * MANIFEST: functions to manipulate stdio.cs
 */

#include <pwd.h>
#include <ac/stdio.h>
#include <ac/string.h>
#include <ac/unistd.h>


#ifndef HAVE_CUSERID

char *
cuserid(buffer)
	char		*buffer;
{
	static char	temp[20];
	struct passwd	*pw;
	int		uid;

	if (!buffer)
		buffer = temp;
	uid = geteuid();
	pw = getpwuid(uid);
	if (!pw)
		sprintf(buffer, "%d", uid);
	else
	{
		strncpy(buffer, pw->pw_name, 8);
		buffer[8] = 0;
	}
	return buffer;
}

#endif
