<?php
/*
    FibuSQL 0.4.1  -  (c) 2003 Martin Pitt <martin@piware.de>

    This software is protected by the GNU General Public License (see
    file COPYING).
*/

include_once 'backend/base.inc';
include_once 'pagehead-html.inc';
include_once get_lang_inc( '-accdef' );

static $account_types = array();
$account_types[0] = $LANG_balsheet;
$account_types[1] = $LANG_assets;
$account_types[2] = $LANG_liabs;
$account_types[3] = $LANG_revenue;
$account_types[4] = $LANG_expense;

# check whether an account of type $type can be a subaccount of type
# $parenttype. If so, null is returned, otherwise an error string.
function valid_subacctype( $type, $parenttype )
{
    global $LANG_err_acctype, $LANG_err_oneroot, $LANG_err_asset,
	$LANG_err_liabs, $LANG_err_revenue, $LANG_err_expense;
    if( $type < 0 || $type > 4 || $parenttype < 0 || $parenttype > 4 )
	return $LANG_err_acctype;
    if( $type == 0 )
	return $LANG_err_oneroot;
    if( $type == 1 && $parenttype > 1 )
	return $LANG_err_asset;
    if( $type == 2 && ( $parenttype == 1 || $parenttype > 2 ) )
	return $LANG_err_liabs;
    if( $type == 3 && !( $parenttype == 3 || $parenttype == 2 ) )
	return $LANG_err_revenue;
    if( $type == 4 && !( $parenttype == 4 || $parenttype == 2 ) )
	return $LANG_err_expense;
    return null;
}

# print all subaccounts of $acc with the current indentation level
# $indent in a tree like fashion for use in a <select> field. Calls
# itself recursively.
function get_subaccs( $acc, $indent ) 
{
    global $db;
    global $account_types;

    $res = $db->query( "select account, name, type from accounts where parent=$acc and account <> 0 order by account" );
    # function is used within a table, so check_res cannot be used here
    if( DB::isError( $res ) )
	return $fail = $res->getMessage();

    while( $r = $res->fetchRow() ) {
	echo '  <option value="' . $r[0] . '">';
	for( $i = 0; $i < $indent; ++$i )
	    echo '&nbsp; &nbsp; ';
	echo '+-- (' . $r[0] . ') ' . $r[1] . ' [' . $account_types[$r[2]] . "]</option>\n";
	get_subaccs( $r[0], $indent+1 );
    }
}

$get_acc = get_http_int( 'acclist', 1 );

if( $HTTP_GET_VARS['delete'] && $get_acc > 0 ) {
    $res = $db->query( "delete from accounts where account=$get_acc" );
    if( DB::isError( $res ) )
	echo '<p class="error">', $LANG_err_delacc, '</p>';
    else
	check_res( $db->query( "delete from balances where account=$get_acc" ),
	    $LANG_err_delbalcache );
}
elseif( $HTTP_GET_VARS['insert'] ) {
    $num = get_http_int( 'newnum', 1 );
    $type = get_http_int( 'newtype', 1 );

    if( $HTTP_GET_VARS['newname'] ) {
	$parenttype = $db->getOne( "select type from accounts where account = $get_acc" );
	check_res( $parenttype, $LANG_err_readacc );
	if( $err = valid_subacctype( $type, $parenttype ) )
	    echo "<p class=\"error\">$LANG_error: $err</p>\n";
	else {
	    $name = str_replace( "'", "''", stripslashes( $HTTP_GET_VARS['newname'] ) );	
	    $res = $db->query( "insert into accounts values( $num, $get_acc, null, '$name', $type )" );
	    check_res( $res, $LANG_err_insertacc );
	}
    }
}
elseif( $HTTP_GET_VARS['modify'] && $get_acc != null ) {
    $name = str_replace( "'", "''", stripslashes( $HTTP_GET_VARS['newname'] ) );	
    if( is_numeric( $HTTP_GET_VARS['newnum'] ) )
	$num = intval( $HTTP_GET_VARS['newnum'] );
    else
	$num = null;
    if( is_numeric( $HTTP_GET_VARS['newtype'] ) )
	$type = intval( $HTTP_GET_VARS['newtype'] );
    else
	$type = null;

    # change name
    if( $name ) {
	check_res( $db->query( "update accounts set name='$name' where account=$get_acc" ),
	    $LANG_err_updateacc );
    }

    # change type
    if( $type ) {
	$parent = $db->getOne( "select parent from accounts where account=$get_acc" );
	check_res( $parent, $LANG_err_readacc );
	$parenttype = $db->getOne( "select type from accounts where account = $parent" );
	check_res( $parenttype, $LANG_err_readacc );
	if( $err = valid_subacctype( $type, $parenttype ) )
	    echo "<p class=\"error\">$LANG_error: $err</p>\n";
	else {
	    check_res( $db->query( "update accounts set type=$type where account=$get_acc" ),
		$LANG_err_updateacc );
	}
    }

    # change account number
    if( $num > 0 ) {
# constraints prevent that this is possible
#	check_res( $db->query( "update accounts set account=$num where account=$get_acc" ), 
#	    'Konnte Kontonummer nicht &auml;ndern' );
#	check_res( $db->query( "update journal set debit_acc=$num where debit_acc=$get_acc" ),
#	    'Konnte Soll-Konten des Grundbuch nicht aktualisieren' );
#	check_res( $db->query( "update journal set credit_acc=$num where credit_acc=$get_acc" ),
#	    'Konnte Haben-Konten des Grundbuch nicht aktualisieren' );
	echo '<p class="error">', $LANG_err_changenumunimpl, '</p>';
    }
}
?>

<h2><?php echo $LANG_menu_accounts ?></h2>

<form action="<?php echo $HTTP_SERVER_VARS['PHP_SELF'] ?>" method="get">

<table>
  <tr><td>
    <select name="acclist" size="25" class="fixed">
<?php
echo '<option value="0">(0) ' . $LANG_balsheet . "</option>\n";
get_subaccs(0, 1);
?>
      </select>
  </td></tr>

  <tr><td></td></tr>

  <tr><td><?php echo $LANG_withchosen ?></td></tr>

  <tr><td>
    <table>
       <tr>
         <td><?php echo $LANG_accnum ?></td>
         <td><input type="text" name="newnum" size="5" /></td>
         <td class="rightalign"><?php echo $LANG_acctype ?> <select name="newtype">
	    <option value="1" selected="selected"><?php echo $LANG_assets ?></option>
	    <option value="2"><?php echo $LANG_liabs ?></option>
	    <option value="3"><?php echo $LANG_revenue ?></option>
	    <option value="4"><?php echo $LANG_expense ?></option>
	  </select>
	</td>
      </tr>
      <tr>
        <td><?php echo $LANG_accname ?></td>
	<td colspan="2"><input type="text" name="newname" size="50" maxlength="255" /></td>
      </tr>
    </table>
  </td></tr>

  <tr><td><?php echo $LANG_doaction ?>:</td></tr>

  <tr><td> <input type="submit" name="insert" value=" <?php echo $LANG_createsubacc ?> " /></td></tr>
  <tr><td> <input type="submit" name="modify" value=" <?php echo $LANG_changeacc ?> " />
    <?php echo $LANG_noemptychange ?></td></tr>
  <tr><td> <input type="submit" name="delete" value=" <?php echo $LANG_delacc ?> " /></td></tr>
</table>
</form>

<?php
if( $fail )
    print "<p class=\"error\">$LANG_error: $LANG_err_readacc ($LANG_dbmsg: $fail)</p>\n";
?>

</body>
</html>

