<?php
/*
    FibuSQL 0.4.1  -  (c) 2003 Martin Pitt <martin@piware.de>

    This software is protected by the GNU General Public License (see
    file COPYING).
*/

include_once 'backend/base.inc';
include_once 'pagehead-html.inc';
include_once 'backend/do-update-rep.inc';

switch( $HTTP_GET_VARS['order'] )  {
    case 'debit':   $sort = 'debit_acc, credit_acc, time desc'; break;
    case 'credit':  $sort = 'credit_acc, debit_acc, time desc'; break;
    case 'value':   $sort = 'value, time'; break;
    case 'desc':    $sort = 'description, time desc'; break;
    case 'receipt': $sort = 'receipt, time desc'; break;
    default:	    $sort = 'time desc';
}

$res = $db->query( 'select id,a1.name,a2.name,value,description,receipt,
		    extract(YEAR from time), extract(MONTH from time),
		    extract(DAY from time), extract(HOUR from time),
		    extract(MINUTE from time)
		   from journal, accounts as a1, accounts as a2
		   where debit_acc = a1.account and credit_acc = a2.account
		   order by '. $sort );
check_res( $res, $LANG_err_readj );

echo "<h2>$LANG_menu_journal</h2>\n<p>", $LANG_clicktochange, ' ', $LANG_clicksort, "</p>\n";
?>

  <table class="booktbl">
    <tr>
      <th><a href="?order=debit"><?php echo $LANG_debitacc ?></a></th>
      <th><a href="?order=credit"><?php echo $LANG_creditacc ?></a></th>
      <th class="num"><a href="?order=value"><?php echo $LANG_value ?></a></th>
      <th><a href="?order=desc"><?php echo $LANG_desc ?></a></th>
      <th><a href="?order=time"><?php echo $LANG_time ?></a></th>
      <th><a href="?order=receipt"><?php echo $LANG_receipt ?></a></th>
    </tr>

<?php
while( $row = $res->fetchRow() ) {
    $time = sprintf( '%d-%02d-%02d&nbsp;%02d:%02d', $row[6], $row[7], $row[8], $row[9], $row[10] );
    print '<tr> <td>'.htmlq( $row[1] )."</td> <td>".
	htmlq( $row[2] )."</td> <td class=\"num\">".
	formatval( $row[3] )."</td> <td><a href=\"booking.php?id=".$row[0]."\">".
	htmlq( $row[4] ). "</a></td> <td>$time</td> <td>".
	$row[5]."</td> </tr>\n";
}
?>
  </table>

</body>
</html>

