/******************************************************************** 
   Copyright (C) 2000 Bassoukos Tassos <abas@aix.meng.auth.gr>
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later
   version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*********************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdlib.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#ifdef HAVE_MALLOC_H
#include <malloc.h>
#endif
#include <glib.h>

#include "threads.h"

typedef struct {
  gpointer data;
  VoidFunc func;
  VoidFunc endfunc;
} NewThreadData;

static void nullfunc(gpointer dummy){}

static void stopThread(NewThreadData *nd){
  nd->endfunc(nd->data);
  free(nd);
}

static void *startThread(NewThreadData *nd){

  pthread_setcancelstate(PTHREAD_CANCEL_ENABLE,NULL);
  pthread_setcanceltype(PTHREAD_CANCEL_DEFERRED ,NULL);

  pthread_cleanup_push((VoidFunc)stopThread, nd);
#ifdef DEBUG
  sleep(1);
#endif
  nd->func(nd->data);
  pthread_cleanup_pop(1);
  pthread_exit(NULL);
}

int newThread(Thread *t,
	      VoidFunc startFunc,
	      VoidFunc endFunc,
	      gpointer data){
  pthread_attr_t attr;
  NewThreadData *nd=malloc(sizeof(NewThreadData));
  nd->data=data;
  nd->func=startFunc;
  nd->endfunc=endFunc ? endFunc : nullfunc;

  pthread_attr_init(&attr);
  pthread_attr_setdetachstate(&attr, PTHREAD_CREATE_DETACHED);

#ifdef DEBUG
  sleep(1);
#endif
  if(pthread_create(t,&attr,
		    (void *(*)(void *))startThread,nd)!=0){
    free(nd);
    return FALSE;
  }
  return TRUE;
}

void killThread(Thread t){
  pthread_cancel(t);
}

pthread_cond_t *cond_new(void)
{
  pthread_cond_t *c = malloc(sizeof(pthread_cond_t));
  pthread_cond_init(c, NULL);
  return c;
}

pthread_mutex_t *mutex_new(void)
{
  pthread_mutex_t *m = malloc(sizeof(pthread_mutex_t));
  pthread_mutex_init(m, NULL);
  return m;
}

void mutex_free(pthread_mutex_t *m)
{
  pthread_mutex_destroy(m);
  free(m);
}

void cond_free(pthread_cond_t *c)
{
  pthread_cond_destroy(c);
  free(c);
}
