#ifndef USERWIDGET_H
#define USERWIDGET_H

#ifndef GNOME_H
#include <gnome.h>
#endif

typedef struct {
  UserlistEntry *ule;
  int pos;
  int oldpos;
  GnomeCanvasItem *group;
  GnomeCanvasItem *name;
  GnomeCanvasItem *rect;
  GnomeCanvasItem *icon;
  GnomeCanvasItem *admin_icon;
  GnomeCanvasItem *no_msg_icon;
  GnomeCanvasItem *no_chat_icon;
  GnomeCanvasItem *line1,*line2;
} UserWidgetEntry;

typedef struct UserWidget_ {
  Connection *c;
  UserlistOps *ops;
  GtkWidget *widget;
  GnomeCanvasGroup *root;
  int width;
  int frozen;
  int numusers;
  UserWidgetEntry *users;
  int seluser;
  void (*select)(struct UserWidget_ *,int socket,gboolean is_double,gpointer data);
  gpointer select_data;
  GnomeUIInfo *menu;
  GtkWidget *popup_menu;
  gpointer popup_data;
} UserWidget;

UserWidget *userwidget_new(Connection *c);
void userwidget_destroy(UserWidget *uw);
void userwidget_add(UserWidget *uw,int socket);
void userwidget_remove(UserWidget *uw,int socket);
void userwidget_update(UserWidget *uw,int socket);
void userwidget_clear(UserWidget *uw);

void userwidget_set_select(UserWidget *uw,
			   void (*select)(UserWidget *,int,gboolean,gpointer),
			   gpointer data);

void userwidget_freeze(UserWidget *uw);
void userwidget_thaw(UserWidget *uw);

void userwidget_lists_userlist(UserWidget *uw);
int userwidget_get_seluser(UserWidget *uw);

#endif
