/* dialog.c  */
/* COPYRIGHT (C) 2000 THE VICTORIA UNIVERSITY OF MANCHESTER and John Levon
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details. 
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA. 
 */
/* creates a window and initialise stkInternalDialog structure  */
/*
 * $Log: stk_dialog.c,v $
 * Revision 1.2  2000/12/06 20:56:04  moz
 * GPL stuff.
 *
 * Revision 1.1.1.1  2000/08/21 01:05:31  moz
 *
 *
 * Revision 1.1.1.1  2000/07/19 22:45:30  moz
 * CVS Import
 *
 * Revision 1.11  2000/03/09 23:07:00  moz
 * Clear current textlist selection on textlist clear.
 *
 * Revision 1.10  2000/03/09 00:53:51  moz
 * Compile fixes.
 *
 * Revision 1.9  2000/01/30 17:22:14  moz
 * stk_open_message(): pass back check_dial
 *
 * Revision 1.8  2000/01/29 03:23:52  moz
 * Removed dead FIXMEs.
 *
 * Revision 1.7  2000/01/25 20:52:41  moz
 * Add stuff to free_list().
 * Don't use ++ as add_to_list is a macro when debugging.
 *
 * Revision 1.6  1999/11/15 02:04:24  moz
 * Set window cursor on text entries to xterm.
 *
 * Revision 1.5  1999/08/08 20:55:15  moz
 * From clean up of structs.
 *
 * Revision 1.4  1999/05/19 17:08:08  moz
 * 1.0 Checkin.
 *
 * Revision 1.3  1999/05/05 12:29:09  moz
 * Fix print dialog.
 *
 * Revision 1.2  1999/04/04 01:47:31  moz
 * calculate a more accurate shown_number.
 * TEXTSLIDER should check its justification isn't 0 before setting it in resize.
 *
 * Revision 1.1  1999/03/30 00:06:05  moz
 * Initial revision
 *
 */    

#include <string.h>
#include <stdlib.h> 
#include <stdio.h> 
#include <X11/cursorfont.h> 
 
#include "include/stk_internal.h"
#include "include/stk.h" 
#include "include/stk_extern.h"

static int dial_ticket=0; 

void free_list(void *); 
void set_window_cursor(Window, int); 
 
/* create a dialog with pixel width and pixel height  */  
Window 
stk_create_dialog(long width, long height)
{
	stkInternalDialog *dp;

	dp = (stkInternalDialog *)malloc(sizeof(stkInternalDialog));

	if (dp==NULL)
	   return (Window)FAIL;

	free_list(dp);

	dp->window.x = DisplayWidth(stk_display,DefaultScreen(stk_display))/2 - 200;
	dp->window.y = DisplayHeight(stk_display,DefaultScreen(stk_display))/2 - 200;
	dp->window.w = width;
	dp->window.h = height;
	dp->next_x = 5;
	dp->next_y = 5;

	if (!stk_create_window(&(dp->window),RootWindow(stk_display,DefaultScreen(stk_display)), DIALOG_TYPE, (void *)dp, FALSE))
		return (Window)FAIL;

	dp->items = NULL;
	dp->focus = NULL; 
	dp->defaultbutton = NULL; 

	dp->window.size_hints = XAllocSizeHints();
	dp->window.size_hints->flags = USPosition | PSize | PMinSize;
	dp->window.size_hints->x = DisplayWidth(stk_display,DefaultScreen(stk_display))/2 - 200;
	dp->window.size_hints->y = DisplayHeight(stk_display,DefaultScreen(stk_display))/2 - 200;
	dp->window.size_hints->min_width = 10;
	dp->window.size_hints->min_height = 10;   
	XSetWMNormalHints(stk_display,dp->window.win,dp->window.size_hints);

	return dp->window.win;
}

/* resize routine  */  
/* ensures a minimum width and height  */  
void 
stk_resize_dialog(stkInternalDialog *d, long x, long y, long w, long h)
{
	List l;
	int i; 
	int ow, oh; 
	int cum_y = 5; 
	int just[3][40]; 

	/* init justification array  */  
	for (i=0; i<40; i++)
		{ 
		just[0][i]=0;
		just[1][i]=5;
		just[2][i]=0; 
		};

	ow = d->window.w;
	oh = d->window.h;
	d->window.x = x;
	d->window.y = y;
	d->window.w = w;
	d->window.h = h;

	l = d->items;

	/* if any elements have a justification, tag it in just[0]  */  
	while (l!=NULL)
		{
		switch (l->type)
			{
			case DIALOG_VSLIDER_TYPE:
				if (VSLIDER(l)->hjustification!=0)
					just[0][VSLIDER(l)->hjustification]++;
				break;

			case DIALOG_TEXT_SLIDER_TYPE:
				if (SLIDER(l)->hjustification!=0)
					just[0][SLIDER(l)->hjustification]++;
				break;
			
			case DIALOG_TEXT_ENTRY_TYPE:
				if (TEXTENTRY(l)->hjustification!=0)
					just[0][TEXTENTRY(l)->hjustification]++;
				break;
			
			case DIALOG_CHOICE_TYPE:
				if (CHOICE(l)->hjustification!=0)
					just[0][CHOICE(l)->hjustification]++;
				break;
			
			case BUTTON_TYPE:
				if (BUTTON(l)->hjustification!=0)
					just[0][BUTTON(l)->hjustification]++;
				break;
			};
		l = l->next;
		};
	
	l = d->items;

	/* resize objects  */  
	/* objects with justification don't affect cum_y  */  
	while (l!=NULL)
		{
		switch (l->type)
			{
			case DIALOG_TITLE_TYPE:
				DIALOGTITLE(l)->window.x = (d->window.w - XTextWidth(stk_font,DIALOGTITLE(l)->text, (int)strlen(DIALOGTITLE(l)->text)))/2 - 5;
				DIALOGTITLE(l)->window.y = cum_y;
				cum_y += stk_font->max_bounds.ascent + stk_font->max_bounds.descent + 5;
				XMoveWindow(stk_display,DIALOGTITLE(l)->window.win, DIALOGTITLE(l)->window.x, DIALOGTITLE(l)->window.y);
				break;

			case DIALOG_VSLIDER_TYPE:
				VSLIDER(l)->window.x = just[1][VSLIDER(l)->hjustification];
				if (VSLIDER(l)->hjustification==0 || just[2][VSLIDER(l)->hjustification]==0)   
						{
						VSLIDER(l)->window.y = cum_y; 
						if (VSLIDER(l)->hjustification!=0)
							just[2][VSLIDER(l)->hjustification] = cum_y;
						cum_y += VSLIDER(l)->window.h+5;
						}
					else
						VSLIDER(l)->window.y = just[2][VSLIDER(l)->hjustification];
							 
					if (just[0][VSLIDER(l)->hjustification]!=0) 
						VSLIDER(l)->window.w = (d->window.w-4- (just[0][VSLIDER(l)->hjustification]*5))
									/just[0][VSLIDER(l)->hjustification]; 
					else
						VSLIDER(l)->window.w = (d->window.w-10);
				
					if (VSLIDER(l)->hjustification!=0) 
						just[1][VSLIDER(l)->hjustification] += VSLIDER(l)->window.w + 5;
					
					XMoveResizeWindow(stk_display, VSLIDER(l)->window.win, 
						VSLIDER(l)->window.x, VSLIDER(l)->window.y,
						VSLIDER(l)->window.w, VSLIDER(l)->window.h);
					break;	

				
			case BUTTON_TYPE:
				i = oh - (BUTTON(l)->window.h+BUTTON(l)->window.y);
				BUTTON(l)->window.x = just[1][BUTTON(l)->hjustification];
					if (BUTTON(l)->hjustification==0 || just[2][BUTTON(l)->hjustification]==0)   
						{
						BUTTON(l)->window.y = cum_y; 
						if (BUTTON(l)->hjustification!=0)
							just[2][BUTTON(l)->hjustification] = cum_y;
						cum_y += BUTTON(l)->window.h+5;
						}
					else
						BUTTON(l)->window.y = just[2][BUTTON(l)->hjustification];
							 
					if (just[0][BUTTON(l)->hjustification]!=0) 
						BUTTON(l)->window.w = (d->window.w-4-(just[0][BUTTON(l)->hjustification]*5))
									/just[0][BUTTON(l)->hjustification]; 
					else
						BUTTON(l)->window.w = (d->window.w-10);
				
					if (BUTTON(l)->hjustification!=0) 
						just[1][BUTTON(l)->hjustification] += BUTTON(l)->window.w + 5;
					
					BUTTON(l)->window.h = d->window.h - BUTTON(l)->window.y - i;
					 
					BUTTON(l)->label_x = (BUTTON(l)->window.w - 
							XTextWidth(stk_font,BUTTON(l)->label, (int)strlen(BUTTON(l)->label)))/2  ;
					BUTTON(l)->label_y = (BUTTON(l)->window.h+stk_font->max_bounds.ascent)/2 - 1;
					XMoveResizeWindow(stk_display, BUTTON(l)->window.win, 
						BUTTON(l)->window.x, BUTTON(l)->window.y,
						BUTTON(l)->window.w, BUTTON(l)->window.h);
					break;	
			
			case DIALOG_TEXT_ENTRY_TYPE:
				i = oh - (TEXTENTRY(l)->window.h+TEXTENTRY(l)->window.y);
				TEXTENTRY(l)->window.x = just[1][TEXTENTRY(l)->hjustification];
				if (TEXTENTRY(l)->hjustification==0 || just[2][TEXTENTRY(l)->hjustification]==0)
					{
					TEXTENTRY(l)->window.y = cum_y;
					if (TEXTENTRY(l)->hjustification!=0)
						just[2][TEXTENTRY(l)->hjustification] = cum_y;
					cum_y += TEXTENTRY(l)->window.h+5;
					}
				else
					TEXTENTRY(l)->window.y = just[2][TEXTENTRY(l)->hjustification];
				
				if (just[0][TEXTENTRY(l)->hjustification]!=0) 
					TEXTENTRY(l)->window.w = (d->window.w-4-(just[0][TEXTENTRY(l)->hjustification]*5))
								/just[0][TEXTENTRY(l)->hjustification]; 
				else
					TEXTENTRY(l)->window.w = (d->window.w-10);
					 
				TEXTENTRY(l)->text_window.x = TEXTENTRY(l)->window.x + 
						XTextWidth(stk_font,TEXTENTRY(l)->label, (int)strlen(TEXTENTRY(l)->label)) + 5;
				TEXTENTRY(l)->text_window.y = TEXTENTRY(l)->window.y;
				TEXTENTRY(l)->text_window.w = TEXTENTRY(l)->window.w - 
						XTextWidth(stk_font,TEXTENTRY(l)->label, (int)strlen(TEXTENTRY(l)->label)) - 5;
				if (TEXTENTRY(l)->hjustification!=0) 
					just[1][TEXTENTRY(l)->hjustification] += TEXTENTRY(l)->window.w + 5;
					 
				XMoveResizeWindow(stk_display, TEXTENTRY(l)->text_window.win, 
						TEXTENTRY(l)->text_window.x, TEXTENTRY(l)->text_window.y, 
						TEXTENTRY(l)->text_window.w, TEXTENTRY(l)->text_window.h);
				XMoveResizeWindow(stk_display, TEXTENTRY(l)->window.win, 
						TEXTENTRY(l)->window.x, TEXTENTRY(l)->window.y,
						TEXTENTRY(l)->window.w, TEXTENTRY(l)->window.h);
				break;
				 
			case DIALOG_CHOICE_TYPE:
				i = oh - (CHOICE(l)->window.h+CHOICE(l)->window.y);
				if (CHOICE(l)->hjustification==0 || just[2][CHOICE(l)->hjustification]==0)
					{
					CHOICE(l)->window.y = cum_y;
					if (CHOICE(l)->hjustification!=0)
						just[2][CHOICE(l)->hjustification] = cum_y;
					cum_y += CHOICE(l)->window.h+5;
					}
				else
					CHOICE(l)->window.y = just[2][CHOICE(l)->hjustification];
				
				if (CHOICE(l)->hjustification!=0) 
					just[1][CHOICE(l)->hjustification] += CHOICE(l)->window.w + 5;
					 
				XMoveResizeWindow(stk_display, CHOICE(l)->window.win, CHOICE(l)->window.x, CHOICE(l)->window.y,
									   CHOICE(l)->window.w, CHOICE(l)->window.h);
				break;

			case DIALOG_TEXT_SLIDER_TYPE:
				i = oh - (SLIDER(l)->window.h+SLIDER(l)->window.y);
				SLIDER(l)->window.x = just[1][SLIDER(l)->hjustification]; 
				if (SLIDER(l)->hjustification==0 || just[2][SLIDER(l)->hjustification]==0) 
					{ 
					SLIDER(l)->window.y = cum_y; 
					if (SLIDER(l)->hjustification!=0) 
						just[2][SLIDER(l)->hjustification] = cum_y; 
					SLIDER(l)->window.h = d->window.h - SLIDER(l)->window.y - i;
					cum_y += SLIDER(l)->window.h+5;
					} 
				else
					{ 
					SLIDER(l)->window.y = just[2][SLIDER(l)->hjustification];
					SLIDER(l)->window.h = d->window.h - SLIDER(l)->window.y - i;
					};
					 
				if (just[0][SLIDER(l)->hjustification]!=0)
					SLIDER(l)->window.w = (d->window.w-4-(just[0][SLIDER(l)->hjustification]*5))
								/just[0][SLIDER(l)->hjustification];
				else
					SLIDER(l)->window.w = (d->window.w-10); 
					 
				SLIDER(l)->textlist->window.x = SLIDER(l)->window.x;
				SLIDER(l)->textlist->window.y = SLIDER(l)->window.y + 
								stk_font->max_bounds.ascent + stk_font->max_bounds.descent; 
				SLIDER(l)->textlist->window.w = SLIDER(l)->window.w;
				SLIDER(l)->textlist->window.h = SLIDER(l)->window.h-SLIDER(l)->textlist->window.y+SLIDER(l)->window.y+2;
				SLIDER(l)->textlist->shown_number = (SLIDER(l)->window.h- (4+(stk_font->max_bounds.ascent/2)))
									/(stk_font->max_bounds.ascent + stk_font->max_bounds.descent); 
				 
				if (SLIDER(l)->hjustification!=0) 
					just[1][SLIDER(l)->hjustification] += SLIDER(l)->window.w + 5;
					 
				XMoveResizeWindow(stk_display, SLIDER(l)->textlist->window.win, 
						SLIDER(l)->textlist->window.x, SLIDER(l)->textlist->window.y, 
						SLIDER(l)->textlist->window.w, SLIDER(l)->textlist->window.h);
				XMoveResizeWindow(stk_display, SLIDER(l)->window.win, 
						SLIDER(l)->window.x, SLIDER(l)->window.y,
						SLIDER(l)->window.w, SLIDER(l)->window.h);
				break;
					 
			}; 
		l = l->next;
		};
}

void 
stk_add_dialog_title(Window dw, char *title)
{
	List l;
	stkInternalDialogTitle *tp;  
	char t[50]="Figurine: "; 
	char *tt=t; 
	XTextProperty dialogName;

	tp = (stkInternalDialogTitle *)malloc(sizeof(stkInternalDialogTitle));

	if (tp==NULL)
		return;

        free_list(tp);

	l = where_in_list(stk_window_list, (ulong)dw);
	 
	tp->dialog = DIALOG(l);
	strncpy(tp->text,title,199);
	tp->window.w = XTextWidth(stk_font, tp->text, (int)strlen(tp->text)) + 5;
	tp->window.h = stk_font->max_bounds.ascent + stk_font->max_bounds.descent;
	/* center at top  */
	tp->window.x = (tp->dialog->window.w - tp->window.w)/2 - 5;
	tp->window.y = tp->dialog->next_y;

	if (!stk_create_window(&(tp->window), tp->dialog->window.win, DIALOG_TITLE_TYPE, (void *)tp, FALSE))
		return;

	tp->dialog->items = add_to_list(tp->dialog->items, (ulong)dial_ticket, DIALOG_TITLE_TYPE, (void *)tp);
	dial_ticket++; 
	 
	tp->dialog->next_y += tp->window.h;

	tp->dialog->window.size_hints->min_width = max(tp->dialog->window.size_hints->min_width, (int)tp->window.w+ 20);
	tp->dialog->window.size_hints->min_height = tp->dialog->next_y + 10; 
	XSetWMNormalHints(stk_display,tp->dialog->window.win, tp->dialog->window.size_hints);
	XMoveResizeWindow(stk_display,tp->window.win, tp->window.x, tp->window.y, tp->window.w, tp->window.h); 

	strncat(t, title,40);  
	XStringListToTextProperty(&tt, 1, &dialogName);
	XSetWMName(stk_display, tp->dialog->window.win, &dialogName);
 	XMapWindow(stk_display,tp->window.win);  
}

void 
stk_redraw_dialog(stkInternalDialog *d)
{
  	XClearWindow(stk_display, d->window.win);  
  	stk_outline(&d->window, 0, 0, d->window.w, d->window.h); 
}

void 
stk_redraw_dialog_title(stkInternalDialogTitle *t)
{
	SET_CLIP_WINDOW(fontgc,&t->window); 
	XClearWindow(stk_display, t->window.win); 
	XDrawString(stk_display,t->window.win, fontgc, 1, stk_font->max_bounds.ascent, t->text, (int)strlen(t->text)); 
}                               

void 
stk_open_dialog(Window dw,void *call)
{
	List l;

	l = where_in_list(stk_window_list, (ulong)dw);

	DIALOG(l)->call = call;
	XRaiseWindow(stk_display, DIALOG(l)->window.win); 
	XMapWindow(stk_display, DIALOG(l)->window.win);
}

void 
stk_close_dialog(Window dw)
{
	List l;
	List l2; 

	l = where_in_list(stk_window_list, (ulong)dw);

	l2 = DIALOG(l)->items;
	DIALOG(l)->focus = NULL; 

	while (l2!=NULL)
		{
		if (l2->type == DIALOG_TEXT_ENTRY_TYPE)
			TEXTENTRY(l2)->charpos = -1;
			 
		if (l2->type == DIALOG_TEXT_SLIDER_TYPE)
			SLIDER(l2)->textlist->selection = -1; 
			 
		l2 = l2->next; 
		};
	XUnmapWindow(stk_display, DIALOG(l)->window.win);
}

void 
stk_set_slider_pos(Window vw, double pos)
{
	List l;

	l = where_in_list(stk_window_list,(ulong)vw);

	VSLIDER(l)->pos = pos;

	stk_redraw_dialog_slider(VSLIDER(l));
}

Window 
stk_add_slider(Window dw, char *label, char *start, char *end, uint pstart, int justification, int hjustification)
{
	stkInternalDialogVSlider *vp;
	List l;
	int a; 

	l = where_in_list(stk_window_list, (ulong)dw);

	vp = (stkInternalDialogVSlider *)malloc(sizeof(stkInternalDialogVSlider));
	if (vp==NULL)
		return 0;
		 
	free_list(vp);

	vp->dialog = DIALOG(l);
	vp->window.x = DIALOG(l)->next_x;
	a = vp->window.y = DIALOG(l)->next_y;
	vp->window.w = 10;
	vp->window.h = stk_font->max_bounds.ascent + stk_font->max_bounds.descent + 
			3 + 10 + 2 + stk_sfont->max_bounds.ascent + stk_sfont->max_bounds.descent;
	vp->hjustification = hjustification; 

	if (!stk_create_window(&(vp->window),vp->dialog->window.win, DIALOG_VSLIDER_TYPE, (void *)vp, FALSE))
		return (Window)FAIL;

	vp->dialog->items = add_to_list(vp->dialog->items, (ulong)dial_ticket, DIALOG_VSLIDER_TYPE, (void *)vp);
	dial_ticket++; 

	vp->pos = pstart;
	vp->dialog->next_y += stk_font->max_bounds.ascent + stk_font->max_bounds.descent + 
			3 + 10 + 2 + stk_sfont->max_bounds.ascent + stk_sfont->max_bounds.descent + 5;
	strncpy(vp->start,start,20);
	strncpy(vp->end,end,20);
	strncpy(vp->label,label,40); 
	
	vp->dialog->window.size_hints->min_width = max(vp->dialog->window.size_hints->min_width, 
		vp->window.x + XTextWidth(stk_sfont, vp->start,(int)strlen(vp->start)) + 20 + 
		XTextWidth(stk_sfont,vp->end,(int)strlen(vp->end)));
	vp->dialog->window.size_hints->min_height = max(vp->dialog->window.size_hints->min_height, 
							vp->window.y + ((int)vp->window.h) + 5); 
	XMoveResizeWindow(stk_display,vp->window.win, vp->window.x, vp->window.y, vp->window.w, vp->window.h); 
	vp->dialog->window.w = vp->dialog->window.size_hints->min_width; 
	vp->dialog->window.h = vp->dialog->window.size_hints->min_height; 
	XResizeWindow(stk_display,vp->dialog->window.win, vp->dialog->window.w, vp->dialog->window.h); 
	XSetWMNormalHints(stk_display,vp->dialog->window.win, vp->dialog->window.size_hints);
	if (justification!=RIGHT)
		{
		vp->dialog->next_x += + 10 + 200; 
		vp->dialog->next_y = a;
		} 
	else
		{ 
		vp->dialog->next_x = 5;
		vp->dialog->next_y = vp->window.y + vp->window.h + 5;
		}; 
		 
	XMapWindow(stk_display,vp->window.win);
	return vp->window.win;  
}

void 
stk_redraw_dialog_slider(stkInternalDialogVSlider *vp)
{
	uint ppos;
	uint y; 

	ppos = min(((int)vp->window.w)-22,max(0,(vp->pos*(vp->window.w-22))));
	SET_CLIP_WINDOW(fontgc,&vp->window);
	SET_CLIP_WINDOW(sfontgc,&vp->window);
	XDrawString(stk_display,vp->window.win, fontgc, 0, stk_font->max_bounds.ascent, vp->label, (int)strlen(vp->label)); 
	y = stk_font->max_bounds.ascent + stk_font->max_bounds.descent + 1; 
	y++; 
	XFillRectangle(stk_display,vp->window.win, bottomrightgc, 1, (int)y, vp->window.w, 9); 
	stk_inverse_outline(&vp->window,0, y-1, (uint)vp->window.w, 10); 
 	XFillRectangle(stk_display,vp->window.win, backgroundgc, 1+((int)ppos), (int)y, 20, 8); 
 	stk_outline(&vp->window, 1+ppos, (uint)y, 20, 8); 
	XDrawString(stk_display,vp->window.win, sfontgc, 0, ((int)y) + 12 + 
			stk_sfont->max_bounds.ascent, vp->start, (int)strlen(vp->start));
	XDrawString(stk_display,vp->window.win, sfontgc, ((int)vp->window.w) - XTextWidth(stk_sfont,vp->end,(int)strlen(vp->end)), 
			((int)y) + 12 + stk_sfont->max_bounds.ascent, vp->end, (int)strlen(vp->end));
}

Window 
stk_add_text_slider(Window dw, char *label, int init_items, int justification, int hjustification)
{
	stkInternalDialogSlider *sp;
	stkInternalDialogTextList *tp; 
	int a; 
	List l;

	l = where_in_list(stk_window_list, (ulong)dw);

	if (l==NULL)
		return 0;

	sp = (stkInternalDialogSlider *)malloc(sizeof(stkInternalDialogSlider));
	if (sp==NULL)
		return 0;

	free_list(sp);
	 
	sp->dialog = DIALOG(l); 
	sp->window.x = DIALOG(l)->next_x;
	a = sp->window.y = DIALOG(l)->next_y;
	sp->window.w = 200;
	sp->window.h = 30+DIALOG(l)->next_y;
	sp->hjustification = hjustification;

	if (!stk_create_window(&(sp->window),sp->dialog->window.win, DIALOG_TEXT_SLIDER_TYPE, (void *)sp, FALSE))
		return (Window)FAIL;

	sp->dialog->items = add_to_list(sp->dialog->items, (ulong)dial_ticket, DIALOG_TEXT_SLIDER_TYPE, (void *)sp);
	dial_ticket++; 

	sp->label_x = 1;
	sp->label_y = stk_font->max_bounds.ascent;
	sp->dialog->next_y += (stk_font->max_bounds.ascent + stk_font->max_bounds.descent);
	strncpy(sp->label,label,40);
	XMapWindow(stk_display,sp->window.win);
	
	tp = (stkInternalDialogTextList *)malloc(sizeof(stkInternalDialogTextList));

	if (tp==NULL)
		return 0;

	free_list(tp);
	tp->dialog = sp->dialog;
	sp->textlist = (void *)tp;
	sp->textlist->selection = -1; 
	tp->shown_number = tp->number = 0;
	tp->strings = NULL;
	tp->stringsize = 0;
	tp->window.x = sp->dialog->next_x;
	tp->window.y = sp->dialog->next_y;
	tp->window.w = 200;
	tp->window.h = (stk_font->max_bounds.ascent + stk_font->max_bounds.descent)*init_items + 4 + 16;
	tp->start = 0; 
	 
	stk_create_window(&(tp->window),tp->dialog->window.win, DIALOG_TEXT_LIST_TYPE, (void *)tp, FALSE);
	tp->dialog = sp->dialog; 
	
	tp->dialog->window.size_hints->min_width = max(tp->dialog->window.size_hints->min_width, sp->dialog->next_x+10+200);
	sp->window.w = tp->window.w;
	sp->window.h = tp->window.h+(tp->window.y-sp->window.y);
	tp->dialog->window.size_hints->min_height = max(tp->dialog->window.size_hints->min_height, sp->window.y + ((int)sp->window.h) + 5); 
	XMoveResizeWindow(stk_display,tp->window.win, tp->window.x, tp->window.y, tp->window.w, tp->window.h); 
	XMoveResizeWindow(stk_display,sp->window.win, sp->window.x, sp->window.y, sp->window.w, sp->window.h); 
	sp->dialog->window.w = tp->dialog->window.size_hints->min_width; 
	sp->dialog->window.h = tp->dialog->window.size_hints->min_height; 
	XResizeWindow(stk_display,sp->dialog->window.win, sp->dialog->window.w, sp->dialog->window.h); 
	XSetWMNormalHints(stk_display,tp->dialog->window.win, tp->dialog->window.size_hints);
	XSetWindowBackground(stk_display, tp->window.win, WhitePixel(stk_display,DefaultScreen(stk_display)));
	if (justification!=RIGHT)
		{
		sp->dialog->next_x += + 10 + 200; 
		sp->dialog->next_y = a;
		} 
	else
		{ 
		sp->dialog->next_x = 5;
		sp->dialog->next_y = sp->window.y + sp->window.h + 5;
		}; 
		 
 	XMapWindow(stk_display,tp->window.win);  
	return tp->window.win; 
}

void 
stk_redraw_dialog_text_slider(stkInternalDialogSlider *s)
{
	XClearWindow(stk_display,s->window.win); 
 	XDrawString(stk_display,s->window.win, fontgc, s->label_x, s->label_y, s->label, (int)strlen(s->label)); 
}

void 
stk_redraw_dialog_text_list(stkInternalDialogTextList *t)
{ 
	uint i; 
	int j=2; 
	char *a=t->strings;

	stk_inverse_outline(&(t->window),2,2,t->window.w-2, t->window.h-2); 
	stk_outline(&(t->window),0,0, t->window.w, t->window.h); 
	stk_thin_outline(&(t->window),t->window.w-22, 2, 20, 20);
	XFillRectangle(stk_display,t->window.win, backgroundgc, ((int)t->window.w)-21, 3, 18,18);
	XCopyArea(stk_display,up_arrow_pixmap, t->window.win, backgroundgc, 0, 0, 
		 up_arrow_attr.width-1, up_arrow_attr.height-1, ((int)t->window.w)-19,5);
	stk_thin_outline(&(t->window),t->window.w-22, t->window.h-22, 20, 20);
  	XFillRectangle(stk_display,t->window.win, backgroundgc, ((int)t->window.w)-21, ((int)t->window.h)-21, 18,18);  
 	XCopyArea(stk_display,down_arrow_pixmap, t->window.win, backgroundgc, 0, 0,
		 down_arrow_attr.width-1,down_arrow_attr.height-1, ((int)t->window.w)-19,((int)t->window.h)-20); 
	XFillRectangle(stk_display,t->window.win,bottomrightgc, ((int)t->window.w)-22, 22, 20, t->window.h-44);
	
	set_clip(fontgc, 2, 2, ((int)t->window.w)-24, ((int)t->window.h)-4); 
	set_clip(whitegc, 2, 2, ((int)t->window.w)-24, ((int)t->window.h)-4); 
	 
	for (i=0; i<t->start; i++)
		a += strlen(a) + 1;

	for (i=t->start;i<t->number && i<(t->shown_number+t->start);i++)
		{
		if (i==((uint)t->selection))
			{
			XFillRectangle(stk_display,t->window.win,bottomrightgc, 
				4, j, t->window.w-26, 
				(uint)(stk_font->max_bounds.ascent+stk_font->max_bounds.descent));
			XSetFunction(stk_display,fontgc,GXcopyInverted); 
			} 
		else
			XFillRectangle(stk_display,t->window.win,whitegc, 4, 
				4+(stk_font->max_bounds.ascent+stk_font->max_bounds.descent)*(int)(i-t->start), 
				t->window.w-26, 
				(uint)(stk_font->max_bounds.ascent+stk_font->max_bounds.descent));
			
		XDrawString(stk_display,t->window.win,fontgc, 5, j+stk_font->max_bounds.ascent, a, (int)strlen(a));
		a += strlen(a) + 1;
		j += stk_font->max_bounds.ascent+stk_font->max_bounds.descent; 
		if (i==((uint)t->selection))
			XSetFunction(stk_display,fontgc,GXcopy); 
		};
	
	XFillRectangle(stk_display, t->window.win, whitegc, 4, j, t->window.w-26, t->window.h-4); 
	set_clip(bottomrightgc, 0, 0, DisplayWidth(stk_display,DefaultScreen(stk_display)), DisplayHeight(stk_display,DefaultScreen(stk_display))); 
	set_clip(fontgc, 0, 0, DisplayWidth(stk_display,DefaultScreen(stk_display)), DisplayHeight(stk_display,DefaultScreen(stk_display))); 
	set_clip(whitegc, 0, 0, DisplayWidth(stk_display,DefaultScreen(stk_display)), DisplayHeight(stk_display,DefaultScreen(stk_display))); 
} 

void 
stk_clear_textlist(Window w)
{
	List l;

	l = where_in_list(stk_window_list, (ulong)w);

	if (l==NULL)
		return;
	
	if (TEXTLIST(l)->strings) 
		free(TEXTLIST(l)->strings);

	TEXTLIST(l)->stringsize = 0;
	TEXTLIST(l)->selection = -1; 
	TEXTLIST(l)->number = 0;
	TEXTLIST(l)->start = 0;
	TEXTLIST(l)->strings = NULL; 
	REDRAW_ALL_WINDOW(&TEXTLIST(l)->window); 
}
	
void 
stk_select_textlist_member(Window w, char *label)
{
	List l;
	uint i; 
	char *c; 

	l = where_in_list(stk_window_list, (ulong)w);

	c = TEXTLIST(l)->strings; 

	TEXTLIST(l)->selection=-1;

	for (i=0; TEXTLIST(l)->selection==-1 && i<TEXTLIST(l)->number; i++)
		{
		if (streq(label,c))
			TEXTLIST(l)->selection = i;
			 
		c += strlen(c)+1;
		};
		 
	stk_redraw_dialog_text_list(TEXTLIST(l));
}

void 
stk_add_textlist_member(Window w, char *s)
{
	List l;

	l = where_in_list(stk_window_list, (ulong)w);

	if (l==NULL)
		return;
	
	if (TEXTLIST(l)->strings==NULL)
		TEXTLIST(l)->strings = malloc(strlen(s)+1);
	else
		TEXTLIST(l)->strings = realloc(TEXTLIST(l)->strings, TEXTLIST(l)->stringsize+strlen(s)+1);
		 
	strcpy(TEXTLIST(l)->strings+TEXTLIST(l)->stringsize,s);
	TEXTLIST(l)->stringsize += strlen(s) + 1;
	TEXTLIST(l)->number++; 
	REDRAW_ALL_WINDOW(&TEXTLIST(l)->window); 
}
 
void 
stk_unselect_textlist(Window w)
{
	List l;

	l = where_in_list(stk_window_list, (ulong)w);

	if (l==NULL)
		return;

	TEXTLIST(l)->selection = -1;
} 
 
Window 
stk_add_text_entry(Window dw, char *label, char *string, int justification, int hjustification)
{
	stkInternalDialogTextEntry *tp; 
	int a; 
	List l;

	l = where_in_list(stk_window_list, (ulong)dw);

	tp = (stkInternalDialogTextEntry *)malloc(sizeof(stkInternalDialogTextEntry));
	if (tp==NULL)
		return 0;

	free_list(tp);
	tp->dialog = DIALOG(l); 
	tp->window.x = DIALOG(l)->next_x;
	a = tp->window.y = DIALOG(l)->next_y;
	tp->window.w = 200;
	tp->window.h = stk_font->max_bounds.ascent + stk_font->max_bounds.descent + 4;
	tp->hjustification = hjustification;

	if (!stk_create_window(&(tp->window),tp->dialog->window.win, DIALOG_TEXT_ENTRY_TYPE, (void *)tp, FALSE))
		return 0;

	tp->dialog->items = add_to_list(tp->dialog->items, (ulong)dial_ticket, DIALOG_TEXT_ENTRY_TYPE, (void *)tp);
	dial_ticket++; 

	tp->label_x = 1;
	tp->label_y = stk_font->max_bounds.ascent+2;
	tp->dialog->next_y += (stk_font->max_bounds.ascent + stk_font->max_bounds.descent) + 10;
	strncpy(tp->label,label,40);
	XMapWindow(stk_display,tp->window.win);
	
	tp->charpos=-1;
	tp->pos_x = 0;
	tp->text_window.x = tp->window.x + XTextWidth(stk_font, tp->label, (int)strlen(tp->label)) + 10;
	tp->text_window.y = tp->window.y;
	tp->text_window.w = 50;
	tp->window.w = tp->text_window.w + tp->text_window.x; 
	tp->text_window.h = stk_font->max_bounds.ascent + stk_font->max_bounds.descent+4; 
	strncpy(tp->contents,string,200);

	stk_create_window(&(tp->text_window), tp->dialog->window.win, DIALOG_TEXT_ENTRY_ENTRY_TYPE, (void *)tp, FALSE);
	set_window_cursor(tp->text_window.win, XC_xterm); 

	tp->dialog->window.size_hints->min_width = max(tp->dialog->window.size_hints->min_width, ((int)tp->window.w));
	tp->dialog->window.size_hints->min_height = max(tp->dialog->window.size_hints->min_height, tp->window.y + ((int)tp->window.h) + 5); 
	XMoveResizeWindow(stk_display,tp->window.win, tp->window.x, tp->window.y, tp->window.w, tp->window.h); 
	XMoveResizeWindow(stk_display,tp->text_window.win, tp->text_window.x, tp->text_window.y, tp->text_window.w, tp->text_window.h); 
	tp->dialog->window.w = tp->dialog->window.size_hints->min_width; 
	tp->dialog->window.h = tp->dialog->window.size_hints->min_height; 
	XResizeWindow(stk_display,tp->dialog->window.win, tp->dialog->window.w, tp->dialog->window.h); 
	XSetWMNormalHints(stk_display,tp->dialog->window.win, tp->dialog->window.size_hints);
	XSetWindowBackground(stk_display, tp->text_window.win, WhitePixel(stk_display,DefaultScreen(stk_display)));
	if (justification!=RIGHT)
		{
		tp->dialog->next_x += 10 + tp->window.w;
		tp->dialog->next_y = a;
		} 
	else
		tp->dialog->next_x = 5;
		 
 	XMapWindow(stk_display,tp->window.win);  
 	XMapWindow(stk_display,tp->text_window.win);  
	return tp->window.win; 	
}

void 
stk_redraw_dialog_text_entry(stkInternalDialogTextEntry *t)
{
	SET_CLIP_WINDOW(fontgc, &(t->window)); 
	XDrawString(stk_display,t->window.win,fontgc, t->label_x, t->label_y, t->label, (int)strlen(t->label));
	XFlush(stk_display); 
}
 
Boolean 
stk_get_choice(Window dw,int num)
{
	List l;

	l = where_in_list(stk_window_list, (ulong)dw);
	
	if (num==1)
		return (RCHOICE(l)->c1->on);
	else if (num==2)
		return (RCHOICE(l)->c2->on);
	else if (num==3)
		return (RCHOICE(l)->c3->on);
	else if (num==4)
		return (RCHOICE(l)->c4->on);
	else
		return (CHOICE(l)->on);
} 
 
void 
stk_choice_on(Window dw,int num)
{
	List l;

	l = where_in_list(stk_window_list, (ulong)dw);
	
	if (num==1)
		{ 
		RCHOICE(l)->c1->on = TRUE;
		REDRAW_ALL_WINDOW(&RCHOICE(l)->c1->window);
		}
	else if (num==2)
		{ 
		RCHOICE(l)->c2->on = TRUE;
		REDRAW_ALL_WINDOW(&RCHOICE(l)->c2->window);
		}
	else if (num==3)
		{ 
		RCHOICE(l)->c3->on = TRUE;
		REDRAW_ALL_WINDOW(&RCHOICE(l)->c3->window);
		}
	else if (num==4)
		{ 
		RCHOICE(l)->c4->on = TRUE;
		REDRAW_ALL_WINDOW(&RCHOICE(l)->c4->window);
		}
	else
		{
		CHOICE(l)->on = TRUE;
		REDRAW_ALL_WINDOW(&CHOICE(l)->window);
		};

} 
 
void 
stk_choice_off(Window dw,int num)
{
	List l;

	l = where_in_list(stk_window_list, (ulong)dw);
	
	if (num==1)
		{ 
		RCHOICE(l)->c1->on = FALSE;
		REDRAW_ALL_WINDOW(&RCHOICE(l)->c1->window);
		}
	else if (num==2)
		{ 
		RCHOICE(l)->c2->on = FALSE;
		REDRAW_ALL_WINDOW(&RCHOICE(l)->c2->window);
		}
	else if (num==3)
		{ 
		RCHOICE(l)->c3->on = FALSE;
		REDRAW_ALL_WINDOW(&RCHOICE(l)->c3->window);
		}
	else if (num==4)
		{ 
		RCHOICE(l)->c4->on = FALSE;
		REDRAW_ALL_WINDOW(&RCHOICE(l)->c4->window);
		}
	else
		{
		CHOICE(l)->on = FALSE;
		REDRAW_ALL_WINDOW(&CHOICE(l)->window);
		};

} 
 
void 
stk_set_text_entry(Window tw, char *str)
{
	List l;

	l = where_in_list(stk_window_list, (ulong)tw);

	if (l==NULL)
		return;

	strncpy(TEXTENTRY(l)->contents, str, 200);
	if (TEXTENTRY(l)->dialog->focus==TEXTENTRY(l))
		{
		TEXTENTRY(l)->charpos = strlen(TEXTENTRY(l)->contents);
		TEXTENTRY(l)->pos_x = 5 + XTextWidth(stk_font,TEXTENTRY(l)->contents, TEXTENTRY(l)->charpos);
		};
	REDRAW_ALL_WINDOW(&TEXTENTRY(l)->text_window);
}

void 
stk_get_text_entry(Window tw, char *str)
{
	List l;

	l = where_in_list(stk_window_list, (ulong)tw);

	if (l==NULL)
		return;
	
	strncpy(str, TEXTENTRY(l)->contents, 200);
}

int 
stk_get_textlist_selection_num(Window tw)
{
	List l;

	l = where_in_list(stk_window_list, (ulong)tw);

	return TEXTLIST(l)->selection; 
}

void 
stk_get_textlist_selection(Window tw, char *str)
{
	List l;
	char *a; 
	uint i; 
	
	l = where_in_list(stk_window_list, (ulong)tw);

	if (l==NULL)
		return;
	
	a = TEXTLIST(l)->strings; 
	 
	for (i=0; i<TEXTLIST(l)->number; i++)
		{
		if (TEXTLIST(l)->selection==(int)i)
			{
			strncpy(str, a, 200);
			break;
			};
		a += strlen(a) + 1;
		};
	
	if (i==TEXTLIST(l)->number)
		strcpy(str,"");
}

void 
stk_redraw_dialog_text_entry_entry(stkInternalDialogTextEntry *t)
{
	SET_CLIP_WINDOW(fontgc, &(t->window)); 
	stk_inverse_outline(&(t->text_window),0,0,t->window.w, t->window.h);  
	set_clip(whitegc,0,0,DisplayWidth(stk_display,DefaultScreen(stk_display)),DisplayHeight(stk_display,DefaultScreen(stk_display))); 
	XFillRectangle(stk_display,t->text_window.win,whitegc, 2, 2, t->window.w-4, t->window.h-4); 
	if (t->charpos!=-1)
		{ 
		XDrawLine(stk_display,t->text_window.win,bottomrightgc, t->pos_x, 4, t->pos_x, ((int)t->text_window.h)-4);
		XDrawLine(stk_display,t->text_window.win,bottomrightgc, t->pos_x+1, 4, t->pos_x+1, ((int)t->text_window.h)-4);
		};

	if (!streq(t->contents,""))
		{ 
		SET_CLIP_WINDOW(fontgc, &(t->text_window)); 
		XDrawString(stk_display,t->text_window.win,fontgc, 5, stk_font->max_bounds.ascent+2, t->contents, (int)strlen(t->contents));
		set_clip(bottomrightgc, 0, 0, DisplayWidth(stk_display,DefaultScreen(stk_display)), DisplayHeight(stk_display,DefaultScreen(stk_display))); 
		}; 
}
 
Window 
stk_add_radio_choice(Window dw, char *label, char *l1, char *l2, char *l3, char *l4, int justification, int hjustification)
{
	stkInternalDialogRadioChoice *cp; 
	int a; 
	int num; 
	List l,li2;
	Window w; 

	if (l4!=NULL)
		num=4;
	else if (l3!=NULL)
		num=3;
	else if (l2!=NULL)
		num=2;
	else
		num=1;

	l = where_in_list(stk_window_list, (ulong)dw);

	cp = (stkInternalDialogRadioChoice *)malloc(sizeof(stkInternalDialogRadioChoice));
	if (cp==NULL)
		return 0;
	
	free_list(cp);
	cp->dialog = DIALOG(l); 
	strncpy(cp->label,label,29); 
	cp->window.x = DIALOG(l)->next_x;
	a = cp->window.y = DIALOG(l)->next_y;
	cp->window.w = 10;
	cp->window.h = num*(stk_font->max_bounds.ascent + stk_font->max_bounds.descent + 4);
	cp->hjustification = hjustification;

	if (!stk_create_window(&(cp->window),cp->dialog->window.win, DIALOG_RADIO_CHOICE_TYPE, (void *)cp, FALSE))
		return (Window)FAIL;

	cp->c1 = NULL; 
	cp->c2 = NULL; 
	cp->c3 = NULL; 
	cp->c4 = NULL; 
	 
	DIALOG(l)->next_x = XTextWidth(stk_font,cp->label,(int)strlen(cp->label)) + 10;
	w = stk_add_choice(cp->dialog->window.win, l1, RIGHT, 0);
	li2 = where_in_list(stk_window_list, (ulong)w);
	cp->c1 = CHOICE(li2); 
	cp->c1->radio = cp->window.win; 
	DIALOG(l)->next_x = XTextWidth(stk_font,cp->label,(int)strlen(cp->label)) + 10;
	cp->window.w = cp->c1->window.w + 10 + XTextWidth(stk_font,cp->label,(int)strlen(cp->label));

	if (num>1)
		{
		w = stk_add_choice(cp->dialog->window.win, l2, RIGHT, 0);
		li2 = where_in_list(stk_window_list, (ulong)w);
		cp->c2 = CHOICE(li2); 
		cp->c2->radio = cp->window.win; 
		DIALOG(l)->next_x = XTextWidth(stk_font,cp->label,(int)strlen(cp->label)) + 10;
		cp->window.w = max(cp->window.w,cp->c2->window.w + 10 + XTextWidth(stk_font,cp->label,(int)strlen(cp->label))); 
		if (num>2)
			{
			w = stk_add_choice(cp->dialog->window.win, l3, RIGHT, 0);
			li2 = where_in_list(stk_window_list, (ulong)w);
			cp->c3 = CHOICE(li2); 
			cp->c3->radio = cp->window.win; 
			DIALOG(l)->next_x = XTextWidth(stk_font,cp->label,(int)strlen(cp->label)) + 10;
			cp->window.w = max(cp->window.w,cp->c3->window.w + 10 + XTextWidth(stk_font,cp->label,(int)strlen(cp->label))); 
			if (num>3)
				{
				w = stk_add_choice(cp->dialog->window.win, l4, RIGHT, 0);
				li2 = where_in_list(stk_window_list, (ulong)w);
				cp->c4 = CHOICE(li2); 
				cp->c4->radio = cp->window.win; 
				DIALOG(l)->next_x = XTextWidth(stk_font,cp->label,(int)strlen(cp->label)) + 10;
				cp->window.w = max(cp->window.w,cp->c4->window.w + 10 + XTextWidth(stk_font,cp->label,(int)strlen(cp->label))); 
				};
			};
		};
		
	cp->dialog->items = add_to_list(cp->dialog->items, (ulong)dial_ticket, DIALOG_RADIO_CHOICE_TYPE, (void *)cp);
	dial_ticket++;
	cp->dialog->window.size_hints->min_width = max(cp->dialog->window.size_hints->min_width, ((int)cp->window.w)+10);
	cp->dialog->window.size_hints->min_height = max(cp->dialog->window.size_hints->min_height, cp->window.y + ((int)cp->window.h) + 5); 
	XMoveResizeWindow(stk_display,cp->window.win, cp->window.x, cp->window.y, cp->window.w, cp->window.h); 
	cp->dialog->window.w = cp->dialog->window.size_hints->min_width; 
	cp->dialog->window.h = cp->dialog->window.size_hints->min_height; 
	XResizeWindow(stk_display,cp->dialog->window.win, cp->dialog->window.w, cp->dialog->window.h); 
	XSetWMNormalHints(stk_display,cp->dialog->window.win, cp->dialog->window.size_hints);
	if (justification!=RIGHT)
		{
		cp->dialog->next_x += 10 + cp->window.w;
		cp->dialog->next_y = a;
		} 
	else
		cp->dialog->next_x = 5;
		 
 	XMapWindow(stk_display,cp->window.win);  
	return cp->window.win; 	
}


Window 
stk_add_choice(Window dw, char *label, int justification, int hjustification)
{
	stkInternalDialogChoice *cp; 
	int a; 
	List l;

	l = where_in_list(stk_window_list, (ulong)dw);

	cp = (stkInternalDialogChoice *)malloc(sizeof(stkInternalDialogChoice));
	if (cp==NULL)
		return 0;

	free_list(cp);

	cp->dialog = DIALOG(l); 
	strncpy(cp->label,label,40);
	cp->window.x = DIALOG(l)->next_x;
	a = cp->window.y = DIALOG(l)->next_y;
	cp->window.w = 15 + XTextWidth(stk_font, cp->label, (int)strlen(cp->label));
	cp->window.h = stk_font->max_bounds.ascent + stk_font->max_bounds.descent + 4;
	cp->hjustification = hjustification;
	cp->radio=0;

	if (!stk_create_window(&(cp->window),cp->dialog->window.win, DIALOG_CHOICE_TYPE, (void *)cp, FALSE))
		return (Window)FAIL;

	cp->dialog->items = add_to_list(cp->dialog->items, (ulong)dial_ticket, DIALOG_CHOICE_TYPE, (void *)cp);
	dial_ticket++; 
	cp->on = FALSE; 

	cp->label_x = 15;
	cp->label_y = stk_font->max_bounds.ascent+2;
	cp->dialog->next_y += (stk_font->max_bounds.ascent + stk_font->max_bounds.descent) + 10;

	cp->dialog->window.size_hints->min_width = max(cp->dialog->window.size_hints->min_width, ((int)cp->window.w));
	cp->dialog->window.size_hints->min_height = max(cp->dialog->window.size_hints->min_height, cp->window.y + ((int)cp->window.h) + 5); 
	XMoveResizeWindow(stk_display,cp->window.win, cp->window.x, cp->window.y, cp->window.w, cp->window.h); 
	cp->dialog->window.w = cp->dialog->window.size_hints->min_width; 
	cp->dialog->window.h = cp->dialog->window.size_hints->min_height; 
	XResizeWindow(stk_display,cp->dialog->window.win, cp->dialog->window.w, cp->dialog->window.h); 
	XSetWMNormalHints(stk_display,cp->dialog->window.win, cp->dialog->window.size_hints);
	if (justification!=RIGHT)
		{
		cp->dialog->next_x += 10 + cp->window.w;
		cp->dialog->next_y = a;
		} 
	else
		cp->dialog->next_x = 5;
		 
 	XMapWindow(stk_display,cp->window.win);  
	return cp->window.win; 	
}
  
void 
stk_redraw_dialog_choice(stkInternalDialogChoice *c)
{
	SET_CLIP_WINDOW(fontgc, &(c->window)); 
	if (c->on)
		stk_inverse_outline(&c->window, 0, (uint)max(0,(((int)c->window.h)-10)/2), 10, 10);
	else
		stk_outline(&c->window, 0, (uint)max(0,(((int)c->window.h)-10)/2), 10, 10);

	XDrawString(stk_display,c->window.win,fontgc, c->label_x, c->label_y, c->label, (int)strlen(c->label));
}

void 
stk_redraw_dialog_radio_choice(stkInternalDialogRadioChoice *c)
{
	SET_CLIP_WINDOW(fontgc, &(c->window)); 
	XClearWindow(stk_display,c->window.win); 
	XDrawString(stk_display,c->window.win,fontgc, 0, stk_font->max_bounds.ascent+5, c->label, (int)strlen(c->label));
}

Window 
stk_add_button(Window dw, char *label, int justification, int hjustification, Boolean defaultbutton, int num)
{
	stkInternalDialogButton *bp; 
	int a; 
	List l;

	l = where_in_list(stk_window_list, (ulong)dw);

	bp = (stkInternalDialogButton *)malloc(sizeof(stkInternalDialogButton));
	if (bp==NULL)
		return 0;

	free_list(bp); 

	bp->dialog = DIALOG(l); 
	strncpy(bp->label,label,15); 
	bp->window.x = DIALOG(l)->next_x;
	a = bp->window.y = DIALOG(l)->next_y;
	bp->window.w = XTextWidth(stk_font, label, (int)strlen(label)) + 15;
	bp->window.h = stk_font->max_bounds.ascent + stk_font->max_bounds.descent + 8;
	bp->hjustification = hjustification;

	if (!stk_create_window(&(bp->window),bp->dialog->window.win, BUTTON_TYPE, (void *)bp, FALSE))
		return (Window)FAIL;

	bp->dialog->items = add_to_list(bp->dialog->items, (ulong)dial_ticket, BUTTON_TYPE, (void *)bp);
	dial_ticket++; 
	
	bp->label_x = 4;
	bp->label_y = stk_font->max_bounds.ascent+2;
	bp->dialog->next_y += (stk_font->max_bounds.ascent + stk_font->max_bounds.descent) + 8;
	XMapWindow(stk_display,bp->window.win);
	
	bp->dialog->window.size_hints->min_width = max(bp->dialog->window.size_hints->min_width, 10+(((int)bp->window.w)*num));
	bp->dialog->window.size_hints->min_height = max(bp->dialog->window.size_hints->min_height, bp->window.y + ((int)bp->window.h) + 7); 
	bp->dialog->window.w = bp->dialog->window.size_hints->min_width; 
	bp->dialog->window.h = bp->dialog->window.size_hints->min_height; 
	XResizeWindow(stk_display,bp->dialog->window.win, bp->dialog->window.w, bp->dialog->window.h); 
	XSetWMNormalHints(stk_display,bp->dialog->window.win, bp->dialog->window.size_hints);
	 
	XMoveResizeWindow(stk_display,bp->window.win, bp->window.x, bp->window.y, bp->window.w, bp->window.h); 
	 
	if (justification!=RIGHT)
		{
		bp->dialog->next_x += + 10 + bp->window.w;
		bp->dialog->next_y = a;
		} 
	else
		{ 
		bp->dialog->next_x = 5;
		bp->dialog->next_y += bp->window.w + 5;
		}; 
		 
	bp->pressed = FALSE;
	
	if (defaultbutton)
		bp->dialog->defaultbutton = bp;

	return bp->window.win; 	
} 

void 
stk_redraw_dialog_button(stkInternalDialogButton *b)
{
	SET_CLIP_WINDOW(fontgc, &(b->window)); 
	if (b->pressed)
		stk_inverse_outline(&(b->window),0, 0, b->window.w, b->window.h);
	else
		stk_outline(&(b->window),0, 0, b->window.w, b->window.h);
	
	XDrawString(stk_display, b->window.win, fontgc, b->label_x, b->label_y, b->label, (int)strlen(b->label));
} 

/* message requiring response  */  
void 
stk_open_message(char *message, char *sone, char *stwo, char *sthree, Window *dial, Window *one, Window *two, Window *three, void *call)
{
	Window w; 
	stkInternalDialog *d; 

	w = stk_create_dialog(400,100);
	*dial = w; 
	stk_add_dialog_title(w,message); 
	*one = stk_add_button(w, sone, 0, 1, TRUE,3);
	*two = stk_add_button(w, stwo, 0, 1, TRUE,3);
	*three = stk_add_button(w, sthree, RIGHT, 1, TRUE,3);
	d = DIALOG(where_in_list(stk_window_list, (ulong)w)); 
	stk_resize_dialog(d, d->window.x, d->window.y,(int)d->window.w, (int)d->window.h); 
	stk_open_dialog(w,call);
}

/* informational message  */  
void 
stk_open_info(char *message)
{
	Window w;
	stkInternalDialog *d; 

	w = stk_create_dialog(400,100);
	stk_add_dialog_title(w,message);
	 
	stk_add_button(w, "OK", RIGHT, 0, TRUE, 1);
	d = DIALOG(where_in_list(stk_window_list, (ulong)w)); 
	stk_resize_dialog(d, d->window.x, d->window.y,(int)d->window.w, (int)d->window.h); 
	stk_open_dialog(w,NULL);

}
