/*
 * fireflier-client-gnome
 * Copyright (C) 2002  triendl.kj
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * triendl.kj
 * triendl.kj@aon.at
 */

#ifndef _CNETWORKTHREAD_H
#define _CNETWORKTHREAD_H
#include "CkjThread.h"
#include "CPacket.h"
#include "CSemaphore.h"
#include "CRefPtr.h"
#include <sigc++/sigc++.h>


	
class CffIO::CNetworkThread: public CkjThread
{
public:
	typedef SigC::Signal1 <void, CRefPtr <const CPacket> > signal_Packet_avail_t;
	typedef SigC::Signal1 <void, bool> signal_Connection_t;
	typedef SigC::Signal1 <void, int> signal_Authentication_t;
	typedef SigC::Signal2 <void, const char*, int> signal_Src_avail_t;
	typedef SigC::Signal2 <void, const char*, int> signal_IPTablesRules_avail_t;
	typedef SigC::Signal2 <void, const char*, int> signal_USpaceRules_avail_t; // must be char* because ffc modifies it
	typedef SigC::Signal0 <void> signal_finished_t;
	typedef SigC::Signal2 <void, CffIO::pCffIOError, bool> signal_error_t;

	typedef SigC::Slot1 <void, CRefPtr <const CPacket> > slot_Packet_avail_t;
	typedef SigC::Slot1 <void, bool> slot_Connection_t;
	typedef SigC::Slot1 <void, int> slot_Authentication_t;
	typedef SigC::Slot2 <void, const char*, int> slot_Src_avail_t;
	typedef SigC::Slot2 <void, const char*, int> slot_IPTablesRules_avail_t;
	typedef SigC::Slot2 <void, const char*, int> slot_USpaceRules_avail_t;
	typedef SigC::Slot0 <void> slot_finished_t;
	typedef SigC::Slot2 <void, CffIO::pCffIOError, bool> slot_error_t;


private:
	bool m_bDoRun;
	CRefPtr <const CPacket> m_pCurPacket;
	
	signal_Packet_avail_t m_signalPacketAvail;
	signal_Connection_t m_signalConnection;
	signal_Authentication_t m_signalAuthentication;
	signal_Src_avail_t m_signalSrcAvail;
	signal_IPTablesRules_avail_t m_signalIPTablesRulesAvail;
	signal_USpaceRules_avail_t m_signalUSpaceRulesAvail;
	signal_finished_t m_signalFinished;
	signal_error_t m_signalError;
	
public:
	CSemaphore m_semWait;


public:
	CNetworkThread();
	virtual ~CNetworkThread();


private:
	void run1();

protected:
	virtual void run();
	
public:
	signal_Packet_avail_t& signal_Packet_avail()
	{
		return m_signalPacketAvail;
	}
	
	signal_Connection_t& signal_Connection()
	{
		return m_signalConnection;
	}
	
	signal_Authentication_t& signal_Authentication()
	{
		return m_signalAuthentication;
	}
	
	signal_Src_avail_t& signal_Src_avail()
	{
		return m_signalSrcAvail;
	}
	
	signal_IPTablesRules_avail_t& signal_IPTablesRules_avail()
	{
		return m_signalIPTablesRulesAvail;
	}

	signal_USpaceRules_avail_t& signal_USpaceRules_avail()
	{
		return m_signalUSpaceRulesAvail;
	}
	
	signal_finished_t& signal_finished()
	{
		return m_signalFinished;
	}
	
	signal_error_t& signal_error()
	{
		return m_signalError;
	}
};

#endif
