/*---[ menus.c ]------------------------------------------------------
 * Copyright (C) 2000 Tomas Junnonen (majix@sci.fi)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Menu and toolbar related functions
 *--------------------------------------------------------------------*/

#include "menus.h"
#include "firestarter.h"
#include "druid.h"
#include "savelog.h"
#include "preferences.h"
#include "modrules.h"
#include "parse.h"
#include "lookup.h"
#include "addrules.h"

#include "xpm/wizard.xpm"
#include "xpm/clear.xpm"
#include "xpm/refresh.xpm"
#include "xpm/save.xpm"
#include "xpm/start.xpm"
#include "xpm/stop.xpm"

static void goto_homepage (void);

static GnomeUIInfo docklet_menu [] = {
	GNOMEUIINFO_ITEM (N_("Start _firewall"), NULL, restart_firewall, start_xpm),
	GNOMEUIINFO_ITEM (N_("_Stop firewall"), NULL, stop_firewall, stop_xpm),
	GNOMEUIINFO_MENU_PREFERENCES_ITEM (preferences_cb, NULL),
	GNOMEUIINFO_SEPARATOR,
	GNOMEUIINFO_MENU_ABOUT_ITEM (show_about, NULL),
	GNOMEUIINFO_MENU_EXIT_ITEM (exit_firestarter, NULL),
	GNOMEUIINFO_END
};

static GnomeUIInfo firewall_menu [] = {
	GNOMEUIINFO_ITEM (N_("_Run firewall wizard"), NULL, rundruid, wizard_xpm),
	GNOMEUIINFO_ITEM (N_("Start _firewall"), NULL, restart_firewall, start_xpm),
	GNOMEUIINFO_ITEM (N_("_Stop firewall"), NULL, stop_firewall, stop_xpm),
	GNOMEUIINFO_ITEM (N_("_Halt all network traffic"), NULL, halt_traffic, stop_xpm),
	GNOMEUIINFO_MENU_PREFERENCES_ITEM (preferences_cb, NULL),
	GNOMEUIINFO_SEPARATOR,
	GNOMEUIINFO_MENU_EXIT_ITEM (exit_firestarter, NULL),
	GNOMEUIINFO_END
};

static GnomeUIInfo log_menu [] = {
	GNOMEUIINFO_ITEM (N_("_Clear firewall hit list"), NULL, clear_hitlist, clear_xpm),
	GNOMEUIINFO_ITEM (N_("R_eload entire firewall hit list"), NULL, reload_hitlist, refresh_xpm),
	GNOMEUIINFO_ITEM (N_("_Save firewall hit list to file"), NULL, create_savelog_filesel, save_xpm),
	GNOMEUIINFO_END
};

static GnomeUIInfo help_menu [] = {
	GNOMEUIINFO_HELP ("firestarter"),
	GNOMEUIINFO_ITEM_STOCK (N_("Firestarter _Homepage"), NULL, goto_homepage, GNOME_STOCK_MENU_HOME),
	GNOMEUIINFO_SEPARATOR,
	GNOMEUIINFO_MENU_ABOUT_ITEM (show_about, NULL),
	GNOMEUIINFO_END
};

static GnomeUIInfo menu [] = {
	GNOMEUIINFO_SUBTREE (N_("_Firewall"), firewall_menu),
	GNOMEUIINFO_SUBTREE (N_("_Hit list"), log_menu),
	GNOMEUIINFO_MENU_HELP_TREE (help_menu),
	GNOMEUIINFO_END
};

static GnomeUIInfo hitlogtoolbar [] = {
	GNOMEUIINFO_ITEM (NULL, N_("Run firewall wizard"), rundruid, wizard_xpm),
	GNOMEUIINFO_SEPARATOR,
	GNOMEUIINFO_ITEM (NULL, N_("Clear firewall hit list"), clear_hitlist, clear_xpm),
  	GNOMEUIINFO_ITEM (NULL, N_("Reload entire firewall hit list"), reload_hitlist, refresh_xpm),
  	GNOMEUIINFO_ITEM (NULL, N_("Save firewall hit list to file"), create_savelog_filesel, save_xpm),
	GNOMEUIINFO_SEPARATOR,
  	GNOMEUIINFO_ITEM (NULL, N_("Restart firewall"), restart_firewall, start_xpm),
  	GNOMEUIINFO_ITEM (NULL, N_("Stop firewall"), stop_firewall, stop_xpm),
	GNOMEUIINFO_END
};

static GnomeUIInfo hitlog_menu [] = {
	GNOMEUIINFO_ITEM (N_("Deny all connections from machine"), NULL, deny_all_from_machine, NULL),
	GNOMEUIINFO_ITEM (N_("Allow all connections from machine"), NULL, allow_all_from_machine, NULL),
	GNOMEUIINFO_ITEM (N_("Open service to machine"), NULL, open_service_to_machine, NULL),
	GNOMEUIINFO_ITEM (N_("Open service to anyone"), NULL, open_service_to_anyone, NULL),
	GNOMEUIINFO_SEPARATOR,
	GNOMEUIINFO_ITEM (N_("Block and stop logging this port"), NULL, do_not_log_port_clist, NULL),
	GNOMEUIINFO_ITEM (N_("Lookup hostname"), NULL, lookup, NULL),
	GNOMEUIINFO_END
};

static GnomeUIInfo dynrules_menu [] = {
	GNOMEUIINFO_ITEM (N_("Remove this rule"), NULL, clear_rule, NULL),
	GNOMEUIINFO_ITEM (N_("Remove all rules in this group"), NULL, clear_group, NULL),
	GNOMEUIINFO_ITEM (N_("Remove all rules in all groups"), NULL, clear_all_groups, NULL),
	GNOMEUIINFO_SEPARATOR,
	GNOMEUIINFO_ITEM (N_("Add new rule"), NULL, create_rule_dialog, NULL),
	GNOMEUIINFO_END
};

/* [ install_menus_and_toolbar ]
 * Install the menus and the toolbar in *window
 */
void
install_menus_and_toolbar (GtkWidget *window)
{
	gnome_app_create_toolbar_with_data (GNOME_APP (window), hitlogtoolbar, window);
	gnome_app_create_menus_with_data (GNOME_APP (window), menu, window);

	appbar = gnome_appbar_new (FALSE, TRUE, GNOME_PREFERENCES_USER);
	gnome_app_set_statusbar (GNOME_APP (window), appbar);
}

/* [ popup_menu ]
 * Pops up a menu and sets the sensitivity of the menu items
 */
void
popup_menu (GtkWidget *clist, GdkEventButton* bevent, GtkWidget *popup)
{
	GList* l = NULL;
	gint i, row;

	if (bevent->button == 3) {
		l = GTK_MENU_SHELL (popup)->children;
		row = GPOINTER_TO_INT (gtk_object_get_data (GTK_OBJECT (clist), "row"));

		for (i = 0; i < 7 && l != NULL; i++) {			
			gtk_widget_set_sensitive (GTK_WIDGET (l->data), row);
			l = l->next;
		}

	    /* The two last menu items of the dynclists are always sensitive*/
		if (clist == denyallclist || clist == allowallclist ||
		    clist == allowsmclist || clist == allowsaclist) {
			l = GTK_MENU_SHELL (popup)->children;
			l = l->next;
			gtk_widget_set_sensitive (GTK_WIDGET (l->data), TRUE);
			l = l->next;
			gtk_widget_set_sensitive (GTK_WIDGET (l->data), TRUE);
			l = l->next;
			l = l->next;
			gtk_widget_set_sensitive (GTK_WIDGET (l->data), TRUE);
			dynclist = (gpointer *)clist;
		}

		gtk_menu_popup (GTK_MENU (popup), NULL, NULL,
				NULL, NULL,
				bevent->button, bevent->time);
	}
}

/* [ install_clist_popup ]
 * Create a popup menu for a clist
 */
void
install_clist_popup (GtkWidget *clist)
{
	if (clist == hitlogclist) {
		hitpopup = gnome_popup_menu_new (hitlog_menu);
	}
	else {
		dynlistpopup = gnome_popup_menu_new (dynrules_menu);
	}
}


/* [ install_docklet_menu ]
 * Attach a popup to the status button docklet
 */
void
install_docklet_menu (GtkWidget *eventbox)
{
	GtkWidget *menu;

	menu = gnome_popup_menu_new (docklet_menu);
	gnome_popup_menu_attach (menu, eventbox, NULL);
}

static void goto_homepage (void)
{
	gnome_url_show ("http://firestarter.sourceforge.net");
}
