/*  sgtables.c
 *  Author: Marcin Wojdyr (only the code, not data)
 *  Licence: GNU General Public License ver. 2+
 */

#include "sgtables.h"
#include <assert.h>
#include <string.h>

const ThirdOfSeitzMx seitz_mx_codes[] = {
/* generated by cctbx and listed below sm_dict.py */
/* 0 */ { "x"      ,  1, 0, 0,  0 },
/* 1 */ { "y"      ,  0, 1, 0,  0 },
/* 2 */ { "z"      ,  0, 0, 1,  0 },
/* 3 */ { "-x"     , -1, 0, 0,  0 },
/* 4 */ { "-y"     ,  0,-1, 0,  0 },
/* 5 */ { "-z"     ,  0, 0,-1,  0 },
/* 6 */ { "x-y"    ,  1,-1, 0,  0 },
/* 7 */ { "-x+y"   , -1, 1, 0,  0 },
/* 8 */ { "x+1/2"  ,  1, 0, 0,  6 },
/* 9 */ { "x+1/4"  ,  1, 0, 0,  3 },
/* : */ { "x+3/4"  ,  1, 0, 0,  9 },
/* ; */ { "y+1/2"  ,  0, 1, 0,  6 },
/* < */ { "y+1/4"  ,  0, 1, 0,  3 },
/* = */ { "y+3/4"  ,  0, 1, 0,  9 },
/* > */ { "z+1/2"  ,  0, 0, 1,  6 },
/* ? */ { "z+1/3"  ,  0, 0, 1,  4 },
/* @ */ { "z+1/4"  ,  0, 0, 1,  3 },
/* A */ { "z+1/6"  ,  0, 0, 1,  2 },
/* B */ { "z+2/3"  ,  0, 0, 1,  8 },
/* C */ { "z+3/4"  ,  0, 0, 1,  9 },
/* D */ { "z+5/6"  ,  0, 0, 1, 10 },
/* E */ { "-x+1/2" , -1, 0, 0,  6 },
/* F */ { "-x+1/4" , -1, 0, 0,  3 },
/* G */ { "-x+3/4" , -1, 0, 0,  9 },
/* H */ { "-y+1/2" ,  0,-1, 0,  6 },
/* I */ { "-y+1/4" ,  0,-1, 0,  3 },
/* J */ { "-y+3/4" ,  0,-1, 0,  9 },
/* K */ { "-z+1/2" ,  0, 0,-1,  6 },
/* L */ { "-z+1/3" ,  0, 0,-1,  4 },
/* M */ { "-z+1/4" ,  0, 0,-1,  3 },
/* N */ { "-z+1/6" ,  0, 0,-1,  2 },
/* O */ { "-z+2/3" ,  0, 0,-1,  8 },
/* P */ { "-z+3/4" ,  0, 0,-1,  9 },
/* Q */ { "-z+5/6" ,  0, 0,-1, 10 },
};


const SpaceGroupSetting space_group_settings[] = {
/* generated by cctbx and listed below list_sg.py */
{   1,   0,     "", "P 1",        " P 1"           ,
  "" },
{   2,   0,     "", "P -1",       "-P 1"           ,
  "" },
{   3,   0,    "b", "P 1 2 1",    " P 2y"          ,
  "315" },
{   3,   0,    "c", "P 1 1 2",    " P 2"           ,
  "342" },
{   3,   0,    "a", "P 2 1 1",    " P 2x"          ,
  "045" },
{   4,   0,    "b", "P 1 21 1",   " P 2yb"         ,
  "3;5" },
{   4,   0,    "c", "P 1 1 21",   " P 2c"          ,
  "34>" },
{   4,   0,    "a", "P 21 1 1",   " P 2xa"         ,
  "845" },
{   5,   0,   "b1", "C 1 2 1",    " C 2y"          ,
  "315" },
{   5,   0,   "b2", "A 1 2 1",    " A 2y"          ,
  "315" },
{   5,   0,   "b3", "I 1 2 1",    " I 2y"          ,
  "315" },
{   5,   0,   "c1", "A 1 1 2",    " A 2"           ,
  "342" },
{   5,   0,   "c2", "B 1 1 2",    " B 2"           ,
  "342" },
{   5,   0,   "c3", "I 1 1 2",    " I 2"           ,
  "342" },
{   5,   0,   "a1", "B 2 1 1",    " B 2x"          ,
  "045" },
{   5,   0,   "a2", "C 2 1 1",    " C 2x"          ,
  "045" },
{   5,   0,   "a3", "I 2 1 1",    " I 2x"          ,
  "045" },
{   6,   0,    "b", "P 1 m 1",    " P -2y"         ,
  "042" },
{   6,   0,    "c", "P 1 1 m",    " P -2"          ,
  "015" },
{   6,   0,    "a", "P m 1 1",    " P -2x"         ,
  "312" },
{   7,   0,   "b1", "P 1 c 1",    " P -2yc"        ,
  "04>" },
{   7,   0,   "b2", "P 1 n 1",    " P -2yac"       ,
  "84>" },
{   7,   0,   "b3", "P 1 a 1",    " P -2ya"        ,
  "842" },
{   7,   0,   "c1", "P 1 1 a",    " P -2a"         ,
  "815" },
{   7,   0,   "c2", "P 1 1 n",    " P -2ab"        ,
  "8;5" },
{   7,   0,   "c3", "P 1 1 b",    " P -2b"         ,
  "0;5" },
{   7,   0,   "a1", "P b 1 1",    " P -2xb"        ,
  "3;2" },
{   7,   0,   "a2", "P n 1 1",    " P -2xbc"       ,
  "3;>" },
{   7,   0,   "a3", "P c 1 1",    " P -2xc"        ,
  "31>" },
{   8,   0,   "b1", "C 1 m 1",    " C -2y"         ,
  "042" },
{   8,   0,   "b2", "A 1 m 1",    " A -2y"         ,
  "042" },
{   8,   0,   "b3", "I 1 m 1",    " I -2y"         ,
  "042" },
{   8,   0,   "c1", "A 1 1 m",    " A -2"          ,
  "015" },
{   8,   0,   "c2", "B 1 1 m",    " B -2"          ,
  "015" },
{   8,   0,   "c3", "I 1 1 m",    " I -2"          ,
  "015" },
{   8,   0,   "a1", "B m 1 1",    " B -2x"         ,
  "312" },
{   8,   0,   "a2", "C m 1 1",    " C -2x"         ,
  "312" },
{   8,   0,   "a3", "I m 1 1",    " I -2x"         ,
  "312" },
{   9,   0,   "b1", "C 1 c 1",    " C -2yc"        ,
  "04>" },
{   9,   0,   "b2", "A 1 n 1",    " A -2yab"       ,
  "8H2" },
{   9,   0,   "b3", "I 1 a 1",    " I -2ya"        ,
  "842" },
{   9,   0,  "-b1", "A 1 a 1",    " A -2ya"        ,
  "842" },
{   9,   0,  "-b2", "C 1 n 1",    " C -2yac"       ,
  "84>" },
{   9,   0,  "-b3", "I 1 c 1",    " I -2yc"        ,
  "04>" },
{   9,   0,   "c1", "A 1 1 a",    " A -2a"         ,
  "815" },
{   9,   0,   "c2", "B 1 1 n",    " B -2ab"        ,
  "8;5" },
{   9,   0,   "c3", "I 1 1 b",    " I -2b"         ,
  "0;5" },
{   9,   0,  "-c1", "B 1 1 b",    " B -2b"         ,
  "0;5" },
{   9,   0,  "-c2", "A 1 1 n",    " A -2ab"        ,
  "8;5" },
{   9,   0,  "-c3", "I 1 1 a",    " I -2a"         ,
  "815" },
{   9,   0,   "a1", "B b 1 1",    " B -2xb"        ,
  "3;2" },
{   9,   0,   "a2", "C n 1 1",    " C -2xac"       ,
  "E1>" },
{   9,   0,   "a3", "I c 1 1",    " I -2xc"        ,
  "31>" },
{   9,   0,  "-a1", "C c 1 1",    " C -2xc"        ,
  "31>" },
{   9,   0,  "-a2", "B n 1 1",    " B -2xab"       ,
  "E;2" },
{   9,   0,  "-a3", "I b 1 1",    " I -2xb"        ,
  "3;2" },
{  10,   0,    "b", "P 1 2/m 1",  "-P 2y"          ,
  "315" },
{  10,   0,    "c", "P 1 1 2/m",  "-P 2"           ,
  "342" },
{  10,   0,    "a", "P 2/m 1 1",  "-P 2x"          ,
  "045" },
{  11,   0,    "b", "P 1 21/m 1", "-P 2yb"         ,
  "3;5" },
{  11,   0,    "c", "P 1 1 21/m", "-P 2c"          ,
  "34>" },
{  11,   0,    "a", "P 21/m 1 1", "-P 2xa"         ,
  "845" },
{  12,   0,   "b1", "C 1 2/m 1",  "-C 2y"          ,
  "315" },
{  12,   0,   "b2", "A 1 2/m 1",  "-A 2y"          ,
  "315" },
{  12,   0,   "b3", "I 1 2/m 1",  "-I 2y"          ,
  "315" },
{  12,   0,   "c1", "A 1 1 2/m",  "-A 2"           ,
  "342" },
{  12,   0,   "c2", "B 1 1 2/m",  "-B 2"           ,
  "342" },
{  12,   0,   "c3", "I 1 1 2/m",  "-I 2"           ,
  "342" },
{  12,   0,   "a1", "B 2/m 1 1",  "-B 2x"          ,
  "045" },
{  12,   0,   "a2", "C 2/m 1 1",  "-C 2x"          ,
  "045" },
{  12,   0,   "a3", "I 2/m 1 1",  "-I 2x"          ,
  "045" },
{  13,   0,   "b1", "P 1 2/c 1",  "-P 2yc"         ,
  "31K" },
{  13,   0,   "b2", "P 1 2/n 1",  "-P 2yac"        ,
  "E1K" },
{  13,   0,   "b3", "P 1 2/a 1",  "-P 2ya"         ,
  "E15" },
{  13,   0,   "c1", "P 1 1 2/a",  "-P 2a"          ,
  "E42" },
{  13,   0,   "c2", "P 1 1 2/n",  "-P 2ab"         ,
  "EH2" },
{  13,   0,   "c3", "P 1 1 2/b",  "-P 2b"          ,
  "3H2" },
{  13,   0,   "a1", "P 2/b 1 1",  "-P 2xb"         ,
  "0H5" },
{  13,   0,   "a2", "P 2/n 1 1",  "-P 2xbc"        ,
  "0HK" },
{  13,   0,   "a3", "P 2/c 1 1",  "-P 2xc"         ,
  "04K" },
{  14,   0,   "b1", "P 1 21/c 1", "-P 2ybc"        ,
  "3;K" },
{  14,   0,   "b2", "P 1 21/n 1", "-P 2yn"         ,
  "E;K" },
{  14,   0,   "b3", "P 1 21/a 1", "-P 2yab"        ,
  "E;5" },
{  14,   0,   "c1", "P 1 1 21/a", "-P 2ac"         ,
  "E4>" },
{  14,   0,   "c2", "P 1 1 21/n", "-P 2n"          ,
  "EH>" },
{  14,   0,   "c3", "P 1 1 21/b", "-P 2bc"         ,
  "3H>" },
{  14,   0,   "a1", "P 21/b 1 1", "-P 2xab"        ,
  "8H5" },
{  14,   0,   "a2", "P 21/n 1 1", "-P 2xn"         ,
  "8HK" },
{  14,   0,   "a3", "P 21/c 1 1", "-P 2xac"        ,
  "84K" },
{  15,   0,   "b1", "C 1 2/c 1",  "-C 2yc"         ,
  "31K" },
{  15,   0,   "b2", "A 1 2/n 1",  "-A 2yab"        ,
  "E;5" },
{  15,   0,   "b3", "I 1 2/a 1",  "-I 2ya"         ,
  "E15" },
{  15,   0,  "-b1", "A 1 2/a 1",  "-A 2ya"         ,
  "E15" },
{  15,   0,  "-b2", "C 1 2/n 1",  "-C 2yac"        ,
  "E1K" },
{  15,   0,  "-b3", "I 1 2/c 1",  "-I 2yc"         ,
  "31K" },
{  15,   0,   "c1", "A 1 1 2/a",  "-A 2a"          ,
  "E42" },
{  15,   0,   "c2", "B 1 1 2/n",  "-B 2ab"         ,
  "EH2" },
{  15,   0,   "c3", "I 1 1 2/b",  "-I 2b"          ,
  "3H2" },
{  15,   0,  "-c1", "B 1 1 2/b",  "-B 2b"          ,
  "3H2" },
{  15,   0,  "-c2", "A 1 1 2/n",  "-A 2ab"         ,
  "EH2" },
{  15,   0,  "-c3", "I 1 1 2/a",  "-I 2a"          ,
  "E42" },
{  15,   0,   "a1", "B 2/b 1 1",  "-B 2xb"         ,
  "0H5" },
{  15,   0,   "a2", "C 2/n 1 1",  "-C 2xac"        ,
  "84K" },
{  15,   0,   "a3", "I 2/c 1 1",  "-I 2xc"         ,
  "04K" },
{  15,   0,  "-a1", "C 2/c 1 1",  "-C 2xc"         ,
  "04K" },
{  15,   0,  "-a2", "B 2/n 1 1",  "-B 2xab"        ,
  "8H5" },
{  15,   0,  "-a3", "I 2/b 1 1",  "-I 2xb"         ,
  "0H5" },
{  16,   0,     "", "P 2 2 2",    " P 2 2"         ,
  "342""045""315" },
{  17,   0,     "", "P 2 2 21",   " P 2c 2"        ,
  "34>""045""31K" },
{  17,   0,  "cab", "P 21 2 2",   " P 2a 2a"       ,
  "E42""845""315" },
{  17,   0,  "bca", "P 2 21 2",   " P 2 2b"        ,
  "342""0H5""3;5" },
{  18,   0,     "", "P 21 21 2",  " P 2 2ab"       ,
  "342""8H5""E;5" },
{  18,   0,  "cab", "P 2 21 21",  " P 2bc 2"       ,
  "3H>""045""3;K" },
{  18,   0,  "bca", "P 21 2 21",  " P 2ac 2ac"     ,
  "E4>""84K""315" },
{  19,   0,     "", "P 21 21 21", " P 2ac 2ab"     ,
  "E4>""8H5""3;K" },
{  20,   0,     "", "C 2 2 21",   " C 2c 2"        ,
  "34>""045""31K" },
{  20,   0,  "cab", "A 21 2 2",   " A 2a 2a"       ,
  "E42""845""315" },
{  20,   0,  "bca", "B 2 21 2",   " B 2 2b"        ,
  "342""0H5""3;5" },
{  21,   0,     "", "C 2 2 2",    " C 2 2"         ,
  "342""045""315" },
{  21,   0,  "cab", "A 2 2 2",    " A 2 2"         ,
  "342""045""315" },
{  21,   0,  "bca", "B 2 2 2",    " B 2 2"         ,
  "342""045""315" },
{  22,   0,     "", "F 2 2 2",    " F 2 2"         ,
  "342""045""315" },
{  23,   0,     "", "I 2 2 2",    " I 2 2"         ,
  "342""045""315" },
{  24,   0,     "", "I 21 21 21", " I 2b 2c"       ,
  "3H2""04K""3;K" },
{  25,   0,     "", "P m m 2",    " P 2 -2"        ,
  "342""312""042" },
{  25,   0,  "cab", "P 2 m m",    " P -2 2"        ,
  "015""045""042" },
{  25,   0,  "bca", "P m 2 m",    " P -2 -2"       ,
  "015""312""315" },
{  26,   0,     "", "P m c 21",   " P 2c -2"       ,
  "34>""312""04>" },
{  26,   0, "ba-c", "P c m 21",   " P 2c -2c"      ,
  "34>""31>""042" },
{  26,   0,  "cab", "P 21 m a",   " P -2a 2a"      ,
  "815""845""042" },
{  26,   0, "-cba", "P 21 a m",   " P -2 2a"       ,
  "015""845""842" },
{  26,   0,  "bca", "P b 21 m",   " P -2 -2b"      ,
  "015""3;2""3;5" },
{  26,   0, "a-cb", "P m 21 b",   " P -2b -2"      ,
  "0;5""312""3;5" },
{  27,   0,     "", "P c c 2",    " P 2 -2c"       ,
  "342""31>""04>" },
{  27,   0,  "cab", "P 2 a a",    " P -2a 2"       ,
  "815""045""842" },
{  27,   0,  "bca", "P b 2 b",    " P -2b -2b"     ,
  "0;5""3;2""315" },
{  28,   0,     "", "P m a 2",    " P 2 -2a"       ,
  "342""E12""842" },
{  28,   0, "ba-c", "P b m 2",    " P 2 -2b"       ,
  "342""3;2""0H2" },
{  28,   0,  "cab", "P 2 m b",    " P -2b 2"       ,
  "0;5""045""0H2" },
{  28,   0, "-cba", "P 2 c m",    " P -2c 2"       ,
  "01K""045""04>" },
{  28,   0,  "bca", "P c 2 m",    " P -2c -2c"     ,
  "01K""31>""315" },
{  28,   0, "a-cb", "P m 2 a",    " P -2a -2a"     ,
  "815""E12""315" },
{  29,   0,     "", "P c a 21",   " P 2c -2ac"     ,
  "34>""E1>""842" },
{  29,   0, "ba-c", "P b c 21",   " P 2c -2b"      ,
  "34>""3;2""0H>" },
{  29,   0,  "cab", "P 21 a b",   " P -2b 2a"      ,
  "0;5""845""8H2" },
{  29,   0, "-cba", "P 21 c a",   " P -2ac 2a"     ,
  "81K""845""04>" },
{  29,   0,  "bca", "P c 21 b",   " P -2bc -2c"    ,
  "0;K""31>""3;5" },
{  29,   0, "a-cb", "P b 21 a",   " P -2a -2ab"    ,
  "815""E;2""3;5" },
{  30,   0,     "", "P n c 2",    " P 2 -2bc"      ,
  "342""3;>""0H>" },
{  30,   0, "ba-c", "P c n 2",    " P 2 -2ac"      ,
  "342""E1>""84>" },
{  30,   0,  "cab", "P 2 n a",    " P -2ac 2"      ,
  "81K""045""84>" },
{  30,   0, "-cba", "P 2 a n",    " P -2ab 2"      ,
  "8;5""045""8H2" },
{  30,   0,  "bca", "P b 2 n",    " P -2ab -2ab"   ,
  "8;5""E;2""315" },
{  30,   0, "a-cb", "P n 2 b",    " P -2bc -2bc"   ,
  "0;K""3;>""315" },
{  31,   0,     "", "P m n 21",   " P 2ac -2"      ,
  "E4>""312""84>" },
{  31,   0, "ba-c", "P n m 21",   " P 2bc -2bc"    ,
  "3H>""3;>""042" },
{  31,   0,  "cab", "P 21 m n",   " P -2ab 2ab"    ,
  "8;5""8H5""042" },
{  31,   0, "-cba", "P 21 n m",   " P -2 2ac"      ,
  "015""84K""84>" },
{  31,   0,  "bca", "P n 21 m",   " P -2 -2bc"     ,
  "015""3;>""3;K" },
{  31,   0, "a-cb", "P m 21 n",   " P -2ab -2"     ,
  "8;5""312""E;5" },
{  32,   0,     "", "P b a 2",    " P 2 -2ab"      ,
  "342""E;2""8H2" },
{  32,   0,  "cab", "P 2 c b",    " P -2bc 2"      ,
  "0;K""045""0H>" },
{  32,   0,  "bca", "P c 2 a",    " P -2ac -2ac"   ,
  "81K""E1>""315" },
{  33,   0,     "", "P n a 21",   " P 2c -2n"      ,
  "34>""E;>""8H2" },
{  33,   0, "ba-c", "P b n 21",   " P 2c -2ab"     ,
  "34>""E;2""8H>" },
{  33,   0,  "cab", "P 21 n b",   " P -2bc 2a"     ,
  "0;K""845""8H>" },
{  33,   0, "-cba", "P 21 c n",   " P -2n 2a"      ,
  "8;K""845""0H>" },
{  33,   0,  "bca", "P c 21 n",   " P -2n -2ac"    ,
  "8;K""E1>""3;5" },
{  33,   0, "a-cb", "P n 21 a",   " P -2ac -2n"    ,
  "81K""E;>""3;5" },
{  34,   0,     "", "P n n 2",    " P 2 -2n"       ,
  "342""E;>""8H>" },
{  34,   0,  "cab", "P 2 n n",    " P -2n 2"       ,
  "8;K""045""8H>" },
{  34,   0,  "bca", "P n 2 n",    " P -2n -2n"     ,
  "8;K""E;>""315" },
{  35,   0,     "", "C m m 2",    " C 2 -2"        ,
  "342""312""042" },
{  35,   0,  "cab", "A 2 m m",    " A -2 2"        ,
  "015""045""042" },
{  35,   0,  "bca", "B m 2 m",    " B -2 -2"       ,
  "015""312""315" },
{  36,   0,     "", "C m c 21",   " C 2c -2"       ,
  "34>""312""04>" },
{  36,   0, "ba-c", "C c m 21",   " C 2c -2c"      ,
  "34>""31>""042" },
{  36,   0,  "cab", "A 21 m a",   " A -2a 2a"      ,
  "815""845""042" },
{  36,   0, "-cba", "A 21 a m",   " A -2 2a"       ,
  "015""845""842" },
{  36,   0,  "bca", "B b 21 m",   " B -2 -2b"      ,
  "015""3;2""3;5" },
{  36,   0, "a-cb", "B m 21 b",   " B -2b -2"      ,
  "0;5""312""3;5" },
{  37,   0,     "", "C c c 2",    " C 2 -2c"       ,
  "342""31>""04>" },
{  37,   0,  "cab", "A 2 a a",    " A -2a 2"       ,
  "815""045""842" },
{  37,   0,  "bca", "B b 2 b",    " B -2b -2b"     ,
  "0;5""3;2""315" },
{  38,   0,     "", "A m m 2",    " A 2 -2"        ,
  "342""312""042" },
{  38,   0, "ba-c", "B m m 2",    " B 2 -2"        ,
  "342""312""042" },
{  38,   0,  "cab", "B 2 m m",    " B -2 2"        ,
  "015""045""042" },
{  38,   0, "-cba", "C 2 m m",    " C -2 2"        ,
  "015""045""042" },
{  38,   0,  "bca", "C m 2 m",    " C -2 -2"       ,
  "015""312""315" },
{  38,   0, "a-cb", "A m 2 m",    " A -2 -2"       ,
  "015""312""315" },
{  39,   0,     "", "A b m 2",    " A 2 -2b"       ,
  "342""3;2""0H2" },
{  39,   0, "ba-c", "B m a 2",    " B 2 -2a"       ,
  "342""E12""842" },
{  39,   0,  "cab", "B 2 c m",    " B -2a 2"       ,
  "815""045""842" },
{  39,   0, "-cba", "C 2 m b",    " C -2a 2"       ,
  "815""045""842" },
{  39,   0,  "bca", "C m 2 a",    " C -2a -2a"     ,
  "815""E12""315" },
{  39,   0, "a-cb", "A c 2 m",    " A -2b -2b"     ,
  "0;5""3;2""315" },
{  40,   0,     "", "A m a 2",    " A 2 -2a"       ,
  "342""E12""842" },
{  40,   0, "ba-c", "B b m 2",    " B 2 -2b"       ,
  "342""3;2""0H2" },
{  40,   0,  "cab", "B 2 m b",    " B -2b 2"       ,
  "0;5""045""0H2" },
{  40,   0, "-cba", "C 2 c m",    " C -2c 2"       ,
  "01K""045""04>" },
{  40,   0,  "bca", "C c 2 m",    " C -2c -2c"     ,
  "01K""31>""315" },
{  40,   0, "a-cb", "A m 2 a",    " A -2a -2a"     ,
  "815""E12""315" },
{  41,   0,     "", "A b a 2",    " A 2 -2ab"      ,
  "342""E;2""8H2" },
{  41,   0, "ba-c", "B b a 2",    " B 2 -2ab"      ,
  "342""E;2""8H2" },
{  41,   0,  "cab", "B 2 c b",    " B -2ab 2"      ,
  "8;5""045""8H2" },
{  41,   0, "-cba", "C 2 c b",    " C -2ac 2"      ,
  "81K""045""84>" },
{  41,   0,  "bca", "C c 2 a",    " C -2ac -2ac"   ,
  "81K""E1>""315" },
{  41,   0, "a-cb", "A c 2 a",    " A -2ab -2ab"   ,
  "8;5""E;2""315" },
{  42,   0,     "", "F m m 2",    " F 2 -2"        ,
  "342""312""042" },
{  42,   0,  "cab", "F 2 m m",    " F -2 2"        ,
  "015""045""042" },
{  42,   0,  "bca", "F m 2 m",    " F -2 -2"       ,
  "015""312""315" },
{  43,   0,     "", "F d d 2",    " F 2 -2d"       ,
  "342""F<@"":J@" },
{  43,   0,  "cab", "F 2 d d",    " F -2d 2"       ,
  "9<M""045""9I@" },
{  43,   0,  "bca", "F d 2 d",    " F -2d -2d"     ,
  "9<M""F<@""E;5" },
{  44,   0,     "", "I m m 2",    " I 2 -2"        ,
  "342""312""042" },
{  44,   0,  "cab", "I 2 m m",    " I -2 2"        ,
  "015""045""042" },
{  44,   0,  "bca", "I m 2 m",    " I -2 -2"       ,
  "015""312""315" },
{  45,   0,     "", "I b a 2",    " I 2 -2c"       ,
  "342""31>""04>" },
{  45,   0,  "cab", "I 2 c b",    " I -2a 2"       ,
  "815""045""842" },
{  45,   0,  "bca", "I c 2 a",    " I -2b -2b"     ,
  "0;5""3;2""315" },
{  46,   0,     "", "I m a 2",    " I 2 -2a"       ,
  "342""E12""842" },
{  46,   0, "ba-c", "I b m 2",    " I 2 -2b"       ,
  "342""3;2""0H2" },
{  46,   0,  "cab", "I 2 m b",    " I -2b 2"       ,
  "0;5""045""0H2" },
{  46,   0, "-cba", "I 2 c m",    " I -2c 2"       ,
  "01K""045""04>" },
{  46,   0,  "bca", "I c 2 m",    " I -2c -2c"     ,
  "01K""31>""315" },
{  46,   0, "a-cb", "I m 2 a",    " I -2a -2a"     ,
  "815""E12""315" },
{  47,   0,     "", "P m m m",    "-P 2 2"         ,
  "342""045""315" },
{  48, '1',     "", "P n n n",    " P 2 2 -1n"     ,
  "342""045""315" },
{  48, '2',     "", "P n n n",    "-P 2ab 2bc"     ,
  "EH2""0HK""E1K" },
{  49,   0,     "", "P c c m",    "-P 2 2c"        ,
  "342""04K""31K" },
{  49,   0,  "cab", "P m a a",    "-P 2a 2"        ,
  "E42""045""E15" },
{  49,   0,  "bca", "P b m b",    "-P 2b 2b"       ,
  "3H2""0H5""315" },
{  50, '1',     "", "P b a n",    " P 2 2 -1ab"    ,
  "342""045""315" },
{  50, '2',     "", "P b a n",    "-P 2ab 2b"      ,
  "EH2""0H5""E15" },
{  50, '1',  "cab", "P n c b",    " P 2 2 -1bc"    ,
  "342""045""315" },
{  50, '2',  "cab", "P n c b",    "-P 2b 2bc"      ,
  "3H2""0HK""31K" },
{  50, '1',  "bca", "P c n a",    " P 2 2 -1ac"    ,
  "342""045""315" },
{  50, '2',  "bca", "P c n a",    "-P 2a 2c"       ,
  "E42""04K""E1K" },
{  51,   0,     "", "P m m a",    "-P 2a 2a"       ,
  "E42""845""315" },
{  51,   0, "ba-c", "P m m b",    "-P 2b 2"        ,
  "3H2""045""3;5" },
{  51,   0,  "cab", "P b m m",    "-P 2 2b"        ,
  "342""0H5""3;5" },
{  51,   0, "-cba", "P c m m",    "-P 2c 2c"       ,
  "34>""04K""315" },
{  51,   0,  "bca", "P m c m",    "-P 2c 2"        ,
  "34>""045""31K" },
{  51,   0, "a-cb", "P m a m",    "-P 2 2a"        ,
  "342""845""E15" },
{  52,   0,     "", "P n n a",    "-P 2a 2bc"      ,
  "E42""0HK""E;K" },
{  52,   0, "ba-c", "P n n b",    "-P 2b 2n"       ,
  "3H2""8HK""E1K" },
{  52,   0,  "cab", "P b n n",    "-P 2n 2b"       ,
  "EH>""0H5""E1K" },
{  52,   0, "-cba", "P c n n",    "-P 2ab 2c"      ,
  "EH2""04K""E;K" },
{  52,   0,  "bca", "P n c n",    "-P 2ab 2n"      ,
  "EH2""8HK""31K" },
{  52,   0, "a-cb", "P n a n",    "-P 2n 2bc"      ,
  "EH>""0HK""E15" },
{  53,   0,     "", "P m n a",    "-P 2ac 2"       ,
  "E4>""045""E1K" },
{  53,   0, "ba-c", "P n m b",    "-P 2bc 2bc"     ,
  "3H>""0HK""315" },
{  53,   0,  "cab", "P b m n",    "-P 2ab 2ab"     ,
  "EH2""8H5""315" },
{  53,   0, "-cba", "P c n m",    "-P 2 2ac"       ,
  "342""84K""E1K" },
{  53,   0,  "bca", "P n c m",    "-P 2 2bc"       ,
  "342""0HK""3;K" },
{  53,   0, "a-cb", "P m a n",    "-P 2ab 2"       ,
  "EH2""045""E;5" },
{  54,   0,     "", "P c c a",    "-P 2a 2ac"      ,
  "E42""84K""31K" },
{  54,   0, "ba-c", "P c c b",    "-P 2b 2c"       ,
  "3H2""04K""3;K" },
{  54,   0,  "cab", "P b a a",    "-P 2a 2b"       ,
  "E42""0H5""E;5" },
{  54,   0, "-cba", "P c a a",    "-P 2ac 2c"      ,
  "E4>""04K""E15" },
{  54,   0,  "bca", "P b c b",    "-P 2bc 2b"      ,
  "3H>""0H5""31K" },
{  54,   0, "a-cb", "P b a b",    "-P 2b 2ab"      ,
  "3H2""8H5""E15" },
{  55,   0,     "", "P b a m",    "-P 2 2ab"       ,
  "342""8H5""E;5" },
{  55,   0,  "cab", "P m c b",    "-P 2bc 2"       ,
  "3H>""045""3;K" },
{  55,   0,  "bca", "P c m a",    "-P 2ac 2ac"     ,
  "E4>""84K""315" },
{  56,   0,     "", "P c c n",    "-P 2ab 2ac"     ,
  "EH2""84K""3;K" },
{  56,   0,  "cab", "P n a a",    "-P 2ac 2bc"     ,
  "E4>""0HK""E;5" },
{  56,   0,  "bca", "P b n b",    "-P 2bc 2ab"     ,
  "3H>""8H5""E1K" },
{  57,   0,     "", "P b c m",    "-P 2c 2b"       ,
  "34>""0H5""3;K" },
{  57,   0, "ba-c", "P c a m",    "-P 2c 2ac"      ,
  "34>""84K""E15" },
{  57,   0,  "cab", "P m c a",    "-P 2ac 2a"      ,
  "E4>""845""31K" },
{  57,   0, "-cba", "P m a b",    "-P 2b 2a"       ,
  "3H2""845""E;5" },
{  57,   0,  "bca", "P b m a",    "-P 2a 2ab"      ,
  "E42""8H5""3;5" },
{  57,   0, "a-cb", "P c m b",    "-P 2bc 2c"      ,
  "3H>""04K""3;5" },
{  58,   0,     "", "P n n m",    "-P 2 2n"        ,
  "342""8HK""E;K" },
{  58,   0,  "cab", "P m n n",    "-P 2n 2"        ,
  "EH>""045""E;K" },
{  58,   0,  "bca", "P n m n",    "-P 2n 2n"       ,
  "EH>""8HK""315" },
{  59, '1',     "", "P m m n",    " P 2 2ab -1ab"  ,
  "342""8H5""E;5" },
{  59, '2',     "", "P m m n",    "-P 2ab 2a"      ,
  "EH2""845""3;5" },
{  59, '1',  "cab", "P n m m",    " P 2bc 2 -1bc"  ,
  "3H>""045""3;K" },
{  59, '2',  "cab", "P n m m",    "-P 2c 2bc"      ,
  "34>""0HK""3;5" },
{  59, '1',  "bca", "P m n m",    " P 2ac 2ac -1ac",
  "E4>""84K""315" },
{  59, '2',  "bca", "P m n m",    "-P 2c 2a"       ,
  "34>""845""E1K" },
{  60,   0,     "", "P b c n",    "-P 2n 2ab"      ,
  "EH>""8H5""31K" },
{  60,   0, "ba-c", "P c a n",    "-P 2n 2c"       ,
  "EH>""04K""E;5" },
{  60,   0,  "cab", "P n c a",    "-P 2a 2n"       ,
  "E42""8HK""3;K" },
{  60,   0, "-cba", "P n a b",    "-P 2bc 2n"      ,
  "3H>""8HK""E15" },
{  60,   0,  "bca", "P b n a",    "-P 2ac 2b"      ,
  "E4>""0H5""E;K" },
{  60,   0, "a-cb", "P c n b",    "-P 2b 2ac"      ,
  "3H2""84K""E;K" },
{  61,   0,     "", "P b c a",    "-P 2ac 2ab"     ,
  "E4>""8H5""3;K" },
{  61,   0, "ba-c", "P c a b",    "-P 2bc 2ac"     ,
  "3H>""84K""E;5" },
{  62,   0,     "", "P n m a",    "-P 2ac 2n"      ,
  "E4>""8HK""3;5" },
{  62,   0, "ba-c", "P m n b",    "-P 2bc 2a"      ,
  "3H>""845""E;K" },
{  62,   0,  "cab", "P b n m",    "-P 2c 2ab"      ,
  "34>""8H5""E;K" },
{  62,   0, "-cba", "P c m n",    "-P 2n 2ac"      ,
  "EH>""84K""3;5" },
{  62,   0,  "bca", "P m c n",    "-P 2n 2a"       ,
  "EH>""845""3;K" },
{  62,   0, "a-cb", "P n a m",    "-P 2c 2n"       ,
  "34>""8HK""E;5" },
{  63,   0,     "", "C m c m",    "-C 2c 2"        ,
  "34>""045""31K" },
{  63,   0, "ba-c", "C c m m",    "-C 2c 2c"       ,
  "34>""04K""315" },
{  63,   0,  "cab", "A m m a",    "-A 2a 2a"       ,
  "E42""845""315" },
{  63,   0, "-cba", "A m a m",    "-A 2 2a"        ,
  "342""845""E15" },
{  63,   0,  "bca", "B b m m",    "-B 2 2b"        ,
  "342""0H5""3;5" },
{  63,   0, "a-cb", "B m m b",    "-B 2b 2"        ,
  "3H2""045""3;5" },
{  64,   0,     "", "C m c a",    "-C 2ac 2"       ,
  "E4>""045""E1K" },
{  64,   0, "ba-c", "C c m b",    "-C 2ac 2ac"     ,
  "E4>""84K""315" },
{  64,   0,  "cab", "A b m a",    "-A 2ab 2ab"     ,
  "EH2""8H5""315" },
{  64,   0, "-cba", "A c a m",    "-A 2 2ab"       ,
  "342""8H5""E;5" },
{  64,   0,  "bca", "B b c m",    "-B 2 2ab"       ,
  "342""8H5""E;5" },
{  64,   0, "a-cb", "B m a b",    "-B 2ab 2"       ,
  "EH2""045""E;5" },
{  65,   0,     "", "C m m m",    "-C 2 2"         ,
  "342""045""315" },
{  65,   0,  "cab", "A m m m",    "-A 2 2"         ,
  "342""045""315" },
{  65,   0,  "bca", "B m m m",    "-B 2 2"         ,
  "342""045""315" },
{  66,   0,     "", "C c c m",    "-C 2 2c"        ,
  "342""04K""31K" },
{  66,   0,  "cab", "A m a a",    "-A 2a 2"        ,
  "E42""045""E15" },
{  66,   0,  "bca", "B b m b",    "-B 2b 2b"       ,
  "3H2""0H5""315" },
{  67,   0,     "", "C m m a",    "-C 2a 2"        ,
  "E42""045""E15" },
{  67,   0, "ba-c", "C m m b",    "-C 2a 2a"       ,
  "E42""845""315" },
{  67,   0,  "cab", "A b m m",    "-A 2b 2b"       ,
  "3H2""0H5""315" },
{  67,   0, "-cba", "A c m m",    "-A 2 2b"        ,
  "342""0H5""3;5" },
{  67,   0,  "bca", "B m c m",    "-B 2 2a"        ,
  "342""845""E15" },
{  67,   0, "a-cb", "B m a m",    "-B 2a 2"        ,
  "E42""045""E15" },
{  68, '1',     "", "C c c a",    " C 2 2 -1ac"    ,
  "342""045""315" },
{  68, '2',     "", "C c c a",    "-C 2a 2ac"      ,
  "E42""84K""31K" },
{  68, '1', "ba-c", "C c c b",    " C 2 2 -1ac"    ,
  "342""045""315" },
{  68, '2', "ba-c", "C c c b",    "-C 2a 2c"       ,
  "E42""04K""E1K" },
{  68, '1',  "cab", "A b a a",    " A 2 2 -1ab"    ,
  "342""045""315" },
{  68, '2',  "cab", "A b a a",    "-A 2a 2b"       ,
  "E42""0H5""E;5" },
{  68, '1', "-cba", "A c a a",    " A 2 2 -1ab"    ,
  "342""045""315" },
{  68, '2', "-cba", "A c a a",    "-A 2ab 2b"      ,
  "EH2""0H5""E15" },
{  68, '1',  "bca", "B b c b",    " B 2 2 -1ab"    ,
  "342""045""315" },
{  68, '2',  "bca", "B b c b",    "-B 2ab 2b"      ,
  "EH2""0H5""E15" },
{  68, '1', "a-cb", "B b a b",    " B 2 2 -1ab"    ,
  "342""045""315" },
{  68, '2', "a-cb", "B b a b",    "-B 2b 2ab"      ,
  "3H2""8H5""E15" },
{  69,   0,     "", "F m m m",    "-F 2 2"         ,
  "342""045""315" },
{  70, '1',     "", "F d d d",    " F 2 2 -1d"     ,
  "342""045""315" },
{  70, '2',     "", "F d d d",    "-F 2uv 2vw"     ,
  "FI2""0IM""F1M" },
{  71,   0,     "", "I m m m",    "-I 2 2"         ,
  "342""045""315" },
{  72,   0,     "", "I b a m",    "-I 2 2c"        ,
  "342""04K""31K" },
{  72,   0,  "cab", "I m c b",    "-I 2a 2"        ,
  "E42""045""E15" },
{  72,   0,  "bca", "I c m a",    "-I 2b 2b"       ,
  "3H2""0H5""315" },
{  73,   0,     "", "I b c a",    "-I 2b 2c"       ,
  "3H2""04K""3;K" },
{  73,   0, "ba-c", "I c a b",    "-I 2a 2b"       ,
  "E42""0H5""E;5" },
{  74,   0,     "", "I m m a",    "-I 2b 2"        ,
  "3H2""045""3;5" },
{  74,   0, "ba-c", "I m m b",    "-I 2a 2a"       ,
  "E42""845""315" },
{  74,   0,  "cab", "I b m m",    "-I 2c 2c"       ,
  "34>""04K""315" },
{  74,   0, "-cba", "I c m m",    "-I 2 2b"        ,
  "342""0H5""3;5" },
{  74,   0,  "bca", "I m c m",    "-I 2 2a"        ,
  "342""845""E15" },
{  74,   0, "a-cb", "I m a m",    "-I 2c 2"        ,
  "34>""045""31K" },
{  75,   0,     "", "P 4",        " P 4"           ,
  "402""342""132" },
{  76,   0,     "", "P 41",       " P 4w"          ,
  "40@""34>""13C" },
{  77,   0,     "", "P 42",       " P 4c"          ,
  "40>""342""13>" },
{  78,   0,     "", "P 43",       " P 4cw"         ,
  "40C""34>""13@" },
{  79,   0,     "", "I 4",        " I 4"           ,
  "402""342""132" },
{  80,   0,     "", "I 41",       " I 4bw"         ,
  "48@""EH>"";3C" },
{  81,   0,     "", "P -4",       " P -4"          ,
  "135""342""405" },
{  82,   0,     "", "I -4",       " I -4"          ,
  "135""342""405" },
{  83,   0,     "", "P 4/m",      "-P 4"           ,
  "402""342""132" },
{  84,   0,     "", "P 42/m",     "-P 4c"          ,
  "40>""342""13>" },
{  85, '1',     "", "P 4/n",      " P 4ab -1ab"    ,
  "H82""342"";E2" },
{  85, '2',     "", "P 4/n",      "-P 4a"          ,
  "H02""EH2""1E2" },
{  86, '1',     "", "P 42/n",     " P 4n -1n"      ,
  "H8>""342"";E>" },
{  86, '2',     "", "P 42/n",     "-P 4bc"         ,
  "48>""EH2"";3>" },
{  87,   0,     "", "I 4/m",      "-I 4"           ,
  "402""342""132" },
{  88, '1',     "", "I 41/a",     " I 4bw -1bw"    ,
  "48@""EH>"";3C" },
{  88, '2',     "", "I 41/a",     "-I 4ad"         ,
  "J9@""E4>""=GC" },
{  89,   0,     "", "P 4 2 2",    " P 4 2"         ,
  "402""342""132""045""105""315""435" },
{  90,   0,     "", "P 4 21 2",   " P 4ab 2ab"     ,
  "H82""342"";E2""8H5""105""E;5""435" },
{  91,   0,     "", "P 41 2 2",   " P 4w 2c"       ,
  "40@""34>""13C""04K""10P""315""43M" },
{  92,   0,     "", "P 41 21 2",  " P 4abw 2nw"    ,
  "H8@""34>"";EC""8HP""105""E;M""43K" },
{  93,   0,     "", "P 42 2 2",   " P 4c 2"        ,
  "40>""342""13>""045""10K""315""43K" },
{  94,   0,     "", "P 42 21 2",  " P 4n 2n"       ,
  "H8>""342"";E>""8HK""105""E;K""435" },
{  95,   0,     "", "P 43 2 2",   " P 4cw 2c"      ,
  "40C""34>""13@""04K""10M""315""43P" },
{  96,   0,     "", "P 43 21 2",  " P 4nw 2abw"    ,
  "H8C""34>"";E@""8HM""105""E;P""43K" },
{  97,   0,     "", "I 4 2 2",    " I 4 2"         ,
  "402""342""132""045""105""315""435" },
{  98,   0,     "", "I 41 2 2",   " I 4bw 2bw"     ,
  "48@""EH>"";3C""0HM"";8K""E1P""435" },
{  99,   0,     "", "P 4 m m",    " P 4 -2"        ,
  "402""342""132""312""432""042""102" },
{ 100,   0,     "", "P 4 b m",    " P 4 -2ab"      ,
  "402""342""132""E;2""HE2""8H2"";82" },
{ 101,   0,     "", "P 42 c m",   " P 4c -2c"      ,
  "40>""342""13>""31>""432""04>""102" },
{ 102,   0,     "", "P 42 n m",   " P 4n -2n"      ,
  "H8>""342"";E>""E;>""432""8H>""102" },
{ 103,   0,     "", "P 4 c c",    " P 4 -2c"       ,
  "402""342""132""31>""43>""04>""10>" },
{ 104,   0,     "", "P 4 n c",    " P 4 -2n"       ,
  "402""342""132""E;>""HE>""8H>"";8>" },
{ 105,   0,     "", "P 42 m c",   " P 4c -2"       ,
  "40>""342""13>""312""43>""042""10>" },
{ 106,   0,     "", "P 42 b c",   " P 4c -2ab"     ,
  "40>""342""13>""E;2""HE>""8H2"";8>" },
{ 107,   0,     "", "I 4 m m",    " I 4 -2"        ,
  "402""342""132""312""432""042""102" },
{ 108,   0,     "", "I 4 c m",    " I 4 -2c"       ,
  "402""342""132""31>""43>""04>""10>" },
{ 109,   0,     "", "I 41 m d",   " I 4bw -2"      ,
  "48@""EH>"";3C""312""4E@""8H>"";0C" },
{ 110,   0,     "", "I 41 c d",   " I 4bw -2c"     ,
  "48@""EH>"";3C""31>""4EC""8H2"";0@" },
{ 111,   0,     "", "P -4 2 m",   " P -4 2"        ,
  "135""342""405""045""432""315""102" },
{ 112,   0,     "", "P -4 2 c",   " P -4 2c"       ,
  "135""342""405""04K""43>""31K""10>" },
{ 113,   0,     "", "P -4 21 m",  " P -4 2ab"      ,
  "135""342""405""8H5""HE2""E;5"";82" },
{ 114,   0,     "", "P -4 21 c",  " P -4 2n"       ,
  "135""342""405""8HK""HE>""E;K"";8>" },
{ 115,   0,     "", "P -4 m 2",   " P -4 -2"       ,
  "135""342""405""312""105""042""435" },
{ 116,   0,     "", "P -4 c 2",   " P -4 -2c"      ,
  "135""342""405""31>""10K""04>""43K" },
{ 117,   0,     "", "P -4 b 2",   " P -4 -2ab"     ,
  "135""342""405""E;2"";85""8H2""HE5" },
{ 118,   0,     "", "P -4 n 2",   " P -4 -2n"      ,
  "135""342""405""E;>"";8K""8H>""HEK" },
{ 119,   0,     "", "I -4 m 2",   " I -4 -2"       ,
  "135""342""405""312""105""042""435" },
{ 120,   0,     "", "I -4 c 2",   " I -4 -2c"      ,
  "135""342""405""31>""10K""04>""43K" },
{ 121,   0,     "", "I -4 2 m",   " I -4 2"        ,
  "135""342""405""045""432""315""102" },
{ 122,   0,     "", "I -4 2 d",   " I -4 2bw"      ,
  "135""342""405""0HM""H3C""3;M"";0C" },
{ 123,   0,     "", "P 4/m m m",  "-P 4 2"         ,
  "402""342""132""045""105""315""435" },
{ 124,   0,     "", "P 4/m c c",  "-P 4 2c"        ,
  "402""342""132""04K""10K""31K""43K" },
{ 125, '1',     "", "P 4/n b m",  " P 4 2 -1ab"    ,
  "402""342""132""045""105""315""435" },
{ 125, '2',     "", "P 4/n b m",  "-P 4a 2b"       ,
  "H02""EH2""1E2""0H5""105""E15""HE5" },
{ 126, '1',     "", "P 4/n n c",  " P 4 2 -1n"     ,
  "402""342""132""045""105""315""435" },
{ 126, '2',     "", "P 4/n n c",  "-P 4a 2bc"      ,
  "H02""EH2""1E2""0HK""10K""E1K""HEK" },
{ 127,   0,     "", "P 4/m b m",  "-P 4 2ab"       ,
  "402""342""132""8H5"";85""E;5""HE5" },
{ 128,   0,     "", "P 4/m n c",  "-P 4 2n"        ,
  "402""342""132""8HK"";8K""E;K""HEK" },
{ 129, '1',     "", "P 4/n m m",  " P 4ab 2ab -1ab",
  "H82""342"";E2""8H5""105""E;5""435" },
{ 129, '2',     "", "P 4/n m m",  "-P 4a 2a"       ,
  "H02""EH2""1E2""845"";85""3;5""435" },
{ 130, '1',     "", "P 4/n c c",  " P 4ab 2n -1ab" ,
  "H82""342"";E2""8HK""10K""E;K""43K" },
{ 130, '2',     "", "P 4/n c c",  "-P 4a 2ac"      ,
  "H02""EH2""1E2""84K"";8K""3;K""43K" },
{ 131,   0,     "", "P 42/m m c", "-P 4c 2"        ,
  "40>""342""13>""045""10K""315""43K" },
{ 132,   0,     "", "P 42/m c m", "-P 4c 2c"       ,
  "40>""342""13>""04K""105""31K""435" },
{ 133, '1',     "", "P 42/n b c", " P 4n 2c -1n"   ,
  "H8>""342"";E>""04K"";85""31K""HE5" },
{ 133, '2',     "", "P 42/n b c", "-P 4ac 2b"      ,
  "H0>""EH2""1E>""0H5""10K""E15""HEK" },
{ 134, '1',     "", "P 42/n n m", " P 4n 2 -1n"    ,
  "H8>""342"";E>""045"";8K""315""HEK" },
{ 134, '2',     "", "P 42/n n m", "-P 4ac 2bc"     ,
  "H0>""EH2""1E>""0HK""105""E1K""HE5" },
{ 135,   0,     "", "P 42/m b c", "-P 4c 2ab"      ,
  "40>""342""13>""8H5"";8K""E;5""HEK" },
{ 136,   0,     "", "P 42/m n m", "-P 4n 2n"       ,
  "H8>""342"";E>""8HK""105""E;K""435" },
{ 137, '1',     "", "P 42/n m c", " P 4n 2n -1n"   ,
  "H8>""342"";E>""8HK""105""E;K""435" },
{ 137, '2',     "", "P 42/n m c", "-P 4ac 2a"      ,
  "H0>""EH2""1E>""845"";8K""3;5""43K" },
{ 138, '1',     "", "P 42/n c m", " P 4n 2ab -1n"  ,
  "H8>""342"";E>""8H5""10K""E;5""43K" },
{ 138, '2',     "", "P 42/n c m", "-P 4ac 2ac"     ,
  "H0>""EH2""1E>""84K"";85""3;K""435" },
{ 139,   0,     "", "I 4/m m m",  "-I 4 2"         ,
  "402""342""132""045""105""315""435" },
{ 140,   0,     "", "I 4/m c m",  "-I 4 2c"        ,
  "402""342""132""04K""10K""31K""43K" },
{ 141, '1',     "", "I 41/a m d", " I 4bw 2bw -1bw",
  "48@""EH>"";3C""0HM"";8K""E1P""435" },
{ 141, '2',     "", "I 41/a m d", "-I 4bd 2"       ,
  "I:@""E4>""<FC""045""<:M""E1K""IFP" },
{ 142, '1',     "", "I 41/a c d", " I 4bw 2aw -1bw",
  "48@""EH>"";3C""84M""10K""3;P""HE5" },
{ 142, '2',     "", "I 41/a c d", "-I 4bd 2c"      ,
  "I:@""E4>""<FC""04K""<:P""E15""IFM" },
{ 143,   0,     "", "P 3",        " P 3"           ,
  "462""732" },
{ 144,   0,     "", "P 31",       " P 31"          ,
  "46?""73B" },
{ 145,   0,     "", "P 32",       " P 32"          ,
  "46B""73?" },
{ 146, 'H',     "", "R 3",        " R 3"           ,
  "462""732" },
{ 146, 'R',     "", "R 3",        " P 3*"          ,
  "201""120" },
{ 147,   0,     "", "P -3",       "-P 3"           ,
  "462""732" },
{ 148, 'H',     "", "R -3",       "-R 3"           ,
  "462""732" },
{ 148, 'R',     "", "R -3",       "-P 3*"          ,
  "201""120" },
{ 149,   0,     "", "P 3 1 2",    " P 3 2"         ,
  "462""732""435""065""715" },
{ 150,   0,     "", "P 3 2 1",    " P 3 2\""       ,
  "462""732""105""375""645" },
{ 151,   0,     "", "P 31 1 2",   " P 31 2 (0 0 4)",
  "46?""73B""43O""065""71L" },
{ 152,   0,     "", "P 31 2 1",   " P 31 2\""      ,
  "46?""73B""105""37L""64O" },
{ 153,   0,     "", "P 32 1 2",   " P 32 2 (0 0 2)",
  "46B""73?""43L""065""71O" },
{ 154,   0,     "", "P 32 2 1",   " P 32 2\""      ,
  "46B""73?""105""37O""64L" },
{ 155, 'H',     "", "R 3 2",      " R 3 2\""       ,
  "462""732""105""375""645" },
{ 155, 'R',     "", "R 3 2",      " P 3* 2"        ,
  "201""120""435""543""354" },
{ 156,   0,     "", "P 3 m 1",    " P 3 -2\""      ,
  "462""732""432""062""712" },
{ 157,   0,     "", "P 3 1 m",    " P 3 -2"        ,
  "462""732""102""372""642" },
{ 158,   0,     "", "P 3 c 1",    " P 3 -2\"c"     ,
  "462""732""43>""06>""71>" },
{ 159,   0,     "", "P 3 1 c",    " P 3 -2c"       ,
  "462""732""10>""37>""64>" },
{ 160, 'H',     "", "R 3 m",      " R 3 -2\""      ,
  "462""732""432""062""712" },
{ 160, 'R',     "", "R 3 m",      " P 3* -2"       ,
  "201""120""102""210""021" },
{ 161, 'H',     "", "R 3 c",      " R 3 -2\"c"     ,
  "462""732""43>""06>""71>" },
{ 161, 'R',     "", "R 3 c",      " P 3* -2n"      ,
  "201""120"";8>"">;8""8>;" },
{ 162,   0,     "", "P -3 1 m",   "-P 3 2"         ,
  "462""732""435""065""715" },
{ 163,   0,     "", "P -3 1 c",   "-P 3 2c"        ,
  "462""732""43K""06K""71K" },
{ 164,   0,     "", "P -3 m 1",   "-P 3 2\""       ,
  "462""732""105""375""645" },
{ 165,   0,     "", "P -3 c 1",   "-P 3 2\"c"      ,
  "462""732""10K""37K""64K" },
{ 166, 'H',     "", "R -3 m",     "-R 3 2\""       ,
  "462""732""105""375""645" },
{ 166, 'R',     "", "R -3 m",     "-P 3* 2"        ,
  "201""120""435""543""354" },
{ 167, 'H',     "", "R -3 c",     "-R 3 2\"c"      ,
  "462""732""10K""37K""64K" },
{ 167, 'R',     "", "R -3 c",     "-P 3* 2n"       ,
  "201""120""HEK""KHE""EKH" },
{ 168,   0,     "", "P 6",        " P 6"           ,
  "602""462""342""732""172" },
{ 169,   0,     "", "P 61",       " P 61"          ,
  "60A""46?""34>""73B""17D" },
{ 170,   0,     "", "P 65",       " P 65"          ,
  "60D""46B""34>""73?""17A" },
{ 171,   0,     "", "P 62",       " P 62"          ,
  "60?""46B""342""73?""17B" },
{ 172,   0,     "", "P 64",       " P 64"          ,
  "60B""46?""342""73B""17?" },
{ 173,   0,     "", "P 63",       " P 6c"          ,
  "60>""462""34>""732""17>" },
{ 174,   0,     "", "P -6",       " P -6"          ,
  "735""462""015""732""465" },
{ 175,   0,     "", "P 6/m",      "-P 6"           ,
  "602""462""342""732""172" },
{ 176,   0,     "", "P 63/m",     "-P 6c"          ,
  "60>""462""34>""732""17>" },
{ 177,   0,     "", "P 6 2 2",    " P 6 2"         ,
  "602""462""342""732""172""435""645""065""105""715""375" },
{ 178,   0,     "", "P 61 2 2",   " P 61 2 (0 0 5)",
  "60A""46?""34>""73B""17D""43Q""645""06N""10L""71K""37O" },
{ 179,   0,     "", "P 65 2 2",   " P 65 2 (0 0 1)",
  "60D""46B""34>""73?""17A""43N""645""06Q""10O""71K""37L" },
{ 180,   0,     "", "P 62 2 2",   " P 62 2 (0 0 4)",
  "60?""46B""342""73?""17B""43O""645""06L""10O""715""37L" },
{ 181,   0,     "", "P 64 2 2",   " P 64 2 (0 0 2)",
  "60B""46?""342""73B""17?""43L""645""06O""10L""715""37O" },
{ 182,   0,     "", "P 63 2 2",   " P 6c 2c"       ,
  "60>""462""34>""732""17>""43K""645""06K""105""71K""375" },
{ 183,   0,     "", "P 6 m m",    " P 6 -2"        ,
  "602""462""342""732""172""102""712""372""432""642""062" },
{ 184,   0,     "", "P 6 c c",    " P 6 -2c"       ,
  "602""462""342""732""172""10>""71>""37>""43>""64>""06>" },
{ 185,   0,     "", "P 63 c m",   " P 6c -2"       ,
  "60>""462""34>""732""17>""102""71>""372""43>""642""06>" },
{ 186,   0,     "", "P 63 m c",   " P 6c -2c"      ,
  "60>""462""34>""732""17>""10>""712""37>""432""64>""062" },
{ 187,   0,     "", "P -6 m 2",   " P -6 2"        ,
  "735""462""015""732""465""435""712""065""432""715""062" },
{ 188,   0,     "", "P -6 c 2",   " P -6c 2"       ,
  "73K""462""01K""732""46K""435""71>""065""43>""715""06>" },
{ 189,   0,     "", "P -6 2 m",   " P -6 -2"       ,
  "735""462""015""732""465""102""645""372""105""642""375" },
{ 190,   0,     "", "P -6 2 c",   " P -6c -2c"     ,
  "73K""462""01K""732""46K""10>""645""37>""105""64>""375" },
{ 191,   0,     "", "P 6/m m m",  "-P 6 2"         ,
  "602""462""342""732""172""435""645""065""105""715""375" },
{ 192,   0,     "", "P 6/m c c",  "-P 6 2c"        ,
  "602""462""342""732""172""43K""64K""06K""10K""71K""37K" },
{ 193,   0,     "", "P 63/m c m", "-P 6c 2"        ,
  "60>""462""34>""732""17>""435""64K""065""10K""715""37K" },
{ 194,   0,     "", "P 63/m m c", "-P 6c 2c"       ,
  "60>""462""34>""732""17>""43K""645""06K""105""71K""375" },
{ 195,   0,     "", "P 2 3",      " P 2 2 3"       ,
  "342""045""315""201""531""234""504""120""153""423""450" },
{ 196,   0,     "", "F 2 3",      " F 2 2 3"       ,
  "342""045""315""201""531""234""504""120""153""423""450" },
{ 197,   0,     "", "I 2 3",      " I 2 2 3"       ,
  "342""045""315""201""531""234""504""120""153""423""450" },
{ 198,   0,     "", "P 21 3",     " P 2ac 2ab 3"   ,
  "E4>""8H5""3;K""201""K3;"">E4""58H""120"";K3""4>E""H58" },
{ 199,   0,     "", "I 21 3",     " I 2b 2c 3"     ,
  "3H2""04K""3;K""201""5E1""23H""58H""120""15E""4>E""H58" },
{ 200,   0,     "", "P m -3",     "-P 2 2 3"       ,
  "342""045""315""201""531""234""504""120""153""423""450" },
{ 201, '1',     "", "P n -3",     " P 2 2 3 -1n"   ,
  "342""045""315""201""531""234""504""120""153""423""450" },
{ 201, '2',     "", "P n -3",     "-P 2ab 2bc 3"   ,
  "EH2""0HK""E1K""201""KE1""2EH""K0H""120""1KE""H2E""HK0" },
{ 202,   0,     "", "F m -3",     "-F 2 2 3"       ,
  "342""045""315""201""531""234""504""120""153""423""450" },
{ 203, '1',     "", "F d -3",     " F 2 2 3 -1d"   ,
  "342""045""315""201""531""234""504""120""153""423""450" },
{ 203, '2',     "", "F d -3",     "-F 2uv 2vw 3"   ,
  "FI2""0IM""F1M""201""MF1""2FI""M0I""120""1MF""I2F""IM0" },
{ 204,   0,     "", "I m -3",     "-I 2 2 3"       ,
  "342""045""315""201""531""234""504""120""153""423""450" },
{ 205,   0,     "", "P a -3",     "-P 2ac 2ab 3"   ,
  "E4>""8H5""3;K""201""K3;"">E4""58H""120"";K3""4>E""H58" },
{ 206,   0,     "", "I a -3",     "-I 2b 2c 3"     ,
  "3H2""04K""3;K""201""5E1""23H""58H""120""15E""4>E""H58" },
{ 207,   0,     "", "P 4 3 2",    " P 4 2 3"       ,
  "402""342""132""045""105""315""435""201""321""531""051""234""024""504""354""120""153""213""423""543""450""240""510" },
{ 208,   0,     "", "P 42 3 2",   " P 4n 2 3"      ,
  "H8>""342"";E>""045"";8K""315""HEK""201""E>;""531""8K;""234""8>H""504""EKH""120""153"">;E""423""KHE""450"">H8""K;8" },
{ 209,   0,     "", "F 4 3 2",    " F 4 2 3"       ,
  "402""342""132""045""105""315""435""201""321""531""051""234""024""504""354""120""153""213""423""543""450""240""510" },
{ 210,   0,     "", "F 41 3 2",   " F 4d 2 3"      ,
  "I9@""3H>""=FC""045""<9M""3;K""JFP""201""F@<""5E;"":M=""234""9@I""58H""GMJ""120"";5E""@=G""H>3""MIF""450""@J:""P=9" },
{ 211,   0,     "", "I 4 3 2",    " I 4 2 3"       ,
  "402""342""132""045""105""315""435""201""321""531""051""234""024""504""354""120""153""213""423""543""450""240""510" },
{ 212,   0,     "", "P 43 3 2",   " P 4acd 2ab 3"  ,
  "J9C""E4>""=G@""8H5""<:P""3;K""IFM""201""G@=""K3;"":P<"">E4""9CJ""58H""FMI""120"";K3""@=G""4>E""MIF""H58""CJ9""P<:" },
{ 213,   0,     "", "P 41 3 2",   " P 4bd 2ab 3"   ,
  "I:@""E4>""<FC""8H5""=9M""3;K""JGP""201""FC<""K3;""9M="">E4"":@I""58H""GPJ""120"";K3""C<F""4>E""PJG""H58""@I:""M=9" },
{ 214,   0,     "", "I 41 3 2",   " I 4bd 2c 3"    ,
  "I:@""E4>""<FC""04K""<:P""E15""IFM""201""FC<""K3;""9M=""23H""9CJ""K04""FMI""120"";K3""C<F""4>E""MIF""H58""CJ9""P<:" },
{ 215,   0,     "", "P -4 3 m",   " P -4 2 3"      ,
  "135""342""405""045""432""315""102""201""054""531""324""234""351""504""021""120""153""540""423""210""450""513""243" },
{ 216,   0,     "", "F -4 3 m",   " F -4 2 3"      ,
  "135""342""405""045""432""315""102""201""054""531""324""234""351""504""021""120""153""540""423""210""450""513""243" },
{ 217,   0,     "", "I -4 3 m",   " I -4 2 3"      ,
  "135""342""405""045""432""315""102""201""054""531""324""234""351""504""021""120""153""540""423""210""450""513""243" },
{ 218,   0,     "", "P -4 3 n",   " P -4n 2 3"     ,
  ";EK""342""H8K""045""HE>""315"";8>""201""8KH""531""E>H""234""EK;""504""8>;""120""153""KH8""423"">;8""450""K;E"">HE" },
{ 219,   0,     "", "F -4 3 c",   " F -4a 2 3"     ,
  ";35""EH2""485""045""H32""E;5""182""201""854""KE1""3>4""234""E51""K84""0>1""120""1KE""548""H2E"">10""450""51E"">HE" },
{ 220,   0,     "", "I -4 3 d",   " I -4bd 2c 3"   ,
  "<GM""3H2""J:M""04K""IGC""3;K""=:C""201""9PI""5E1""GCI""23H""FP=""58H"":C=""120""15E""MJ:""4>E""@<9""H58""M<G""CIG" },
{ 221,   0,     "", "P m -3 m",   "-P 4 2 3"       ,
  "402""342""132""045""105""315""435""201""321""531""051""234""024""504""354""120""153""213""423""543""450""240""510" },
{ 222, '1',     "", "P n -3 n",   " P 4 2 3 -1n"   ,
  "402""342""132""045""105""315""435""201""321""531""051""234""024""504""354""120""153""213""423""543""450""240""510" },
{ 222, '2',     "", "P n -3 n",   "-P 4a 2bc 3"    ,
  "H02""EH2""1E2""0HK""10K""E1K""HEK""201""E21""KE1""0K1""2EH""02H""K0H""EKH""120""1KE""21E""H2E""KHE""HK0""2H0""K10" },
{ 223,   0,     "", "P m -3 n",   "-P 4n 2 3"      ,
  "H8>""342"";E>""045"";8K""315""HEK""201""E>;""531""8K;""234""8>H""504""EKH""120""153"">;E""423""KHE""450"">H8""K;8" },
{ 224, '1',     "", "P n -3 m",   " P 4n 2 3 -1n"  ,
  "H8>""342"";E>""045"";8K""315""HEK""201""E>;""531""8K;""234""8>H""504""EKH""120""153"">;E""423""KHE""450"">H8""K;8" },
{ 224, '2',     "", "P n -3 m",   "-P 4bc 2bc 3"   ,
  "48>""EH2"";3>""0HK"";85""E1K""435""201""3>;""KE1""85;""2EH""8>4""K0H""354""120""1KE"">;3""H2E""543""HK0"">48""5;8" },
{ 225,   0,     "", "F m -3 m",   "-F 4 2 3"       ,
  "402""342""132""045""105""315""435""201""321""531""051""234""024""504""354""120""153""213""423""543""450""240""510" },
{ 226,   0,     "", "F m -3 c",   "-F 4a 2 3"      ,
  "H02""EH2""1E2""045"";05""E;5""4E5""201""E21""KE1""0K1""234""824""K84""3K4""120""1KE""21E""H2E""K43""450""248""K;8" },
{ 227, '1',     "", "F d -3 m",   " F 4d 2 3 -1d"  ,
  "I9@""3H>""=FC""045""<9M""3;K""JFP""201""F@<""5E;"":M=""234""9@I""58H""GMJ""120"";5E""@=G""H>3""MIF""450""@J:""P=9" },
{ 227, '2',     "", "F d -3 m",   "-F 4vw 2vw 3"   ,
  "49@""GI>""=3C""0IM""=9K""G1P""435""201""3@<""PF;"":5=""2FI"":@H""P0J""354""120"";PF""@=E""I>G""5HE""IM0""@49""K<:" },
{ 228, '1',     "", "F d -3 c",   " F 4d 2 3 -1ad" ,
  "I9@""3H>""=FC""045""<9M""3;K""JFP""201""F@<""5E;"":M=""234""9@I""58H""GMJ""120"";5E""@=G""H>3""MIF""450""@J:""P=9" },
{ 228, '2',     "", "F d -3 c",   "-F 4ud 2vw 3"   ,
  "H9@""FJ>""=EC""0IM""<9K""F;P""4E5""201""E@<""MG;"":K=""2FI""9@H""M8J""3K4""120"";MG""@=3""J>F""KHE""IM0""@4:""5=9" },
{ 229,   0,     "", "I m -3 m",   "-I 4 2 3"       ,
  "402""342""132""045""105""315""435""201""321""531""051""234""024""504""354""120""153""213""423""543""450""240""510" },
{ 230,   0,     "", "I a -3 d",   "-I 4bd 2c 3"    ,
  "I:@""E4>""<FC""04K""<:P""E15""IFM""201""FC<""K3;""9M=""23H""9CJ""K04""FMI""120"";K3""C<F""4>E""MIF""H58""CJ9""P<:" },
/* end of the generated code */
{   0,   0,     "", "",           "",  "" }
};


int get_seitz_mx_count(const SpaceGroupSetting *sgs)
{
    assert(strlen(sgs->encoded_seitz) % 3 == 0);
    return strlen(sgs->encoded_seitz) / 3;
}

void decode_seitz_mx(char x, char y, char z, SeitzMatrix *sm)
{
    int i;
    char a[] = { x, y, z };
    for (i = 0; i != 3; ++i) {
        const ThirdOfSeitzMx *c = &seitz_mx_codes[a[i] - '0'];
        sm->R[3*i + 0] = c->r1;
        sm->R[3*i + 1] = c->r2;
        sm->R[3*i + 2] = c->r3;
        sm->T[i] = c->t;
    }
}

void get_seitz_mx(const SpaceGroupSetting *sgs, int n, SeitzMatrix *sm)
{
    assert(n < (int) strlen(sgs->encoded_seitz) / 3);
    decode_seitz_mx(sgs->encoded_seitz[3*n],
                    sgs->encoded_seitz[3*n+1],
                    sgs->encoded_seitz[3*n+2],
                    sm);
}

const SpaceGroupSetting* find_first_sg_with_number(int sgn)
{
    const SpaceGroupSetting *p;
    for (p = space_group_settings; p->sgnumber != 0; ++p)
        if (p->sgnumber == sgn)
            return p;
    return NULL;
}



const char* SchoenfliesSymbols[] = {
    "C1^1", "Ci^1", "C2^1", "C2^2", "C2^3", "Cs^1", "Cs^2", "Cs^3", "Cs^4",
    "C2h^1", "C2h^2", "C2h^3", "C2h^4", "C2h^5", "C2h^6", "D2^1", "D2^2",
    "D2^3", "D2^4", "D2^5", "D2^6", "D2^7", "D2^8", "D2^9", "C2v^1", "C2v^2",
    "C2v^3", "C2v^4", "C2v^5", "C2v^6", "C2v^7", "C2v^8", "C2v^9", "C2v^10",
    "C2v^11", "C2v^12", "C2v^13", "C2v^14", "C2v^15", "C2v^16", "C2v^17",
    "C2v^18", "C2v^19", "C2v^20", "C2v^21", "C2v^22", "D2h^1", "D2h^2",
    "D2h^3", "D2h^4", "D2h^5", "D2h^6", "D2h^7", "D2h^8", "D2h^9", "D2h^10",
    "D2h^11", "D2h^12", "D2h^13", "D2h^14", "D2h^15", "D2h^16", "D2h^17",
    "D2h^18", "D2h^19", "D2h^20", "D2h^21", "D2h^22", "D2h^23", "D2h^24",
    "D2h^25", "D2h^26", "D2h^27", "D2h^28", "C4^1", "C4^2", "C4^3", "C4^4",
    "C4^5", "C4^6", "S4^1", "S4^2", "C4h^1", "C4h^2", "C4h^3", "C4h^4",
    "C4h^5", "C4h^6", "D4^1", "D4^2", "D4^3", "D4^4", "D4^5", "D4^6", "D4^7",
    "D4^8", "D4^9", "D4^10", "C4v^1", "C4v^2", "C4v^3", "C4v^4", "C4v^5",
    "C4v^6", "C4v^7", "C4v^8", "C4v^9", "C4v^10", "C4v^11", "C4v^12", "D2d^1",
    "D2d^2", "D2d^3", "D2d^4", "D2d^5", "D2d^6", "D2d^7", "D2d^8", "D2d^9",
    "D2d^10", "D2d^11", "D2d^12", "D4h^1", "D4h^2", "D4h^3", "D4h^4", "D4h^5",
    "D4h^6", "D4h^7", "D4h^8", "D4h^9", "D4h^10", "D4h^11", "D4h^12", "D4h^13",
    "D4h^14", "D4h^15", "D4h^16", "D4h^17", "D4h^18", "D4h^19", "D4h^20",
    "C3^1", "C3^2", "C3^3", "C3^4", "C3i^1", "C3i^2", "D3^1", "D3^2", "D3^3",
    "D3^4", "D3^5", "D3^6", "D3^7", "C3v^1", "C3v^2", "C3v^3", "C3v^4",
    "C3v^5", "C3v^6", "D3d^1", "D3d^2", "D3d^3", "D3d^4", "D3d^5", "D3d^6",
    "C6^1", "C6^2", "C6^3", "C6^4", "C6^5", "C6^6", "C3h^1", "C6h^1", "C6h^2",
    "D6^1", "D6^2", "D6^3", "D6^4", "D6^5", "D6^6", "C6v^1", "C6v^2", "C6v^3",
    "C6v^4", "D3h^1", "D3h^2", "D3h^3", "D3h^4", "D6h^1", "D6h^2", "D6h^3",
    "D6h^4", "T^1", "T^2", "T^3", "T^4", "T^5", "Th^1", "Th^2", "Th^3", "Th^4",
    "Th^5", "Th^6", "Th^7", "O^1", "O^2", "O^3", "O^4", "O^5", "O^6", "O^7",
    "O^8", "Td^1", "Td^2", "Td^3", "Td^4", "Td^5", "Td^6", "Oh^1", "Oh^2",
    "Oh^3", "Oh^4", "Oh^5", "Oh^6", "Oh^7", "Oh^8", "Oh^9", "Oh^10"
};

/*
The table below was produced from the table above by this Python script:

def u_superscript(d):
    if d == '1':   n = 0xB9
    elif d == '2': n = 0xB2
    elif d == '3': n = 0xB3
    else:          n = 0x2070 + int(d)
    return unichr(n).encode('utf8').encode('string-escape')

for s in table_above:
    base, idx = s.split('^')
    print ('"' + base + "".join(u_superscript(c) for c in idx) + '",'),

*/

const char* SchoenfliesSymbolsAsUTF8[] = {
    "C1\xc2\xb9", "Ci\xc2\xb9", "C2\xc2\xb9", "C2\xc2\xb2",
    "C2\xc2\xb3", "Cs\xc2\xb9", "Cs\xc2\xb2", "Cs\xc2\xb3",
    "Cs\xe2\x81\xb4", "C2h\xc2\xb9", "C2h\xc2\xb2", "C2h\xc2\xb3",
    "C2h\xe2\x81\xb4", "C2h\xe2\x81\xb5", "C2h\xe2\x81\xb6", "D2\xc2\xb9",
    "D2\xc2\xb2", "D2\xc2\xb3", "D2\xe2\x81\xb4", "D2\xe2\x81\xb5",
    "D2\xe2\x81\xb6", "D2\xe2\x81\xb7", "D2\xe2\x81\xb8",
    "D2\xe2\x81\xb9", "C2v\xc2\xb9", "C2v\xc2\xb2", "C2v\xc2\xb3",
    "C2v\xe2\x81\xb4", "C2v\xe2\x81\xb5", "C2v\xe2\x81\xb6",
    "C2v\xe2\x81\xb7", "C2v\xe2\x81\xb8", "C2v\xe2\x81\xb9",
    "C2v\xc2\xb9\xe2\x81\xb0", "C2v\xc2\xb9\xc2\xb9",
    "C2v\xc2\xb9\xc2\xb2", "C2v\xc2\xb9\xc2\xb3",
    "C2v\xc2\xb9\xe2\x81\xb4", "C2v\xc2\xb9\xe2\x81\xb5",
    "C2v\xc2\xb9\xe2\x81\xb6", "C2v\xc2\xb9\xe2\x81\xb7",
    "C2v\xc2\xb9\xe2\x81\xb8", "C2v\xc2\xb9\xe2\x81\xb9",
    "C2v\xc2\xb2\xe2\x81\xb0", "C2v\xc2\xb2\xc2\xb9",
    "C2v\xc2\xb2\xc2\xb2", "D2h\xc2\xb9", "D2h\xc2\xb2", "D2h\xc2\xb3",
    "D2h\xe2\x81\xb4", "D2h\xe2\x81\xb5", "D2h\xe2\x81\xb6",
    "D2h\xe2\x81\xb7", "D2h\xe2\x81\xb8", "D2h\xe2\x81\xb9",
    "D2h\xc2\xb9\xe2\x81\xb0", "D2h\xc2\xb9\xc2\xb9",
    "D2h\xc2\xb9\xc2\xb2", "D2h\xc2\xb9\xc2\xb3",
    "D2h\xc2\xb9\xe2\x81\xb4", "D2h\xc2\xb9\xe2\x81\xb5",
    "D2h\xc2\xb9\xe2\x81\xb6", "D2h\xc2\xb9\xe2\x81\xb7",
    "D2h\xc2\xb9\xe2\x81\xb8", "D2h\xc2\xb9\xe2\x81\xb9",
    "D2h\xc2\xb2\xe2\x81\xb0", "D2h\xc2\xb2\xc2\xb9",
    "D2h\xc2\xb2\xc2\xb2", "D2h\xc2\xb2\xc2\xb3",
    "D2h\xc2\xb2\xe2\x81\xb4", "D2h\xc2\xb2\xe2\x81\xb5",
    "D2h\xc2\xb2\xe2\x81\xb6", "D2h\xc2\xb2\xe2\x81\xb7",
    "D2h\xc2\xb2\xe2\x81\xb8", "C4\xc2\xb9", "C4\xc2\xb2", "C4\xc2\xb3",
    "C4\xe2\x81\xb4", "C4\xe2\x81\xb5", "C4\xe2\x81\xb6", "S4\xc2\xb9",
    "S4\xc2\xb2", "C4h\xc2\xb9", "C4h\xc2\xb2", "C4h\xc2\xb3",
    "C4h\xe2\x81\xb4", "C4h\xe2\x81\xb5", "C4h\xe2\x81\xb6", "D4\xc2\xb9",
    "D4\xc2\xb2", "D4\xc2\xb3", "D4\xe2\x81\xb4", "D4\xe2\x81\xb5",
    "D4\xe2\x81\xb6", "D4\xe2\x81\xb7", "D4\xe2\x81\xb8",
    "D4\xe2\x81\xb9", "D4\xc2\xb9\xe2\x81\xb0", "C4v\xc2\xb9",
    "C4v\xc2\xb2", "C4v\xc2\xb3", "C4v\xe2\x81\xb4", "C4v\xe2\x81\xb5",
    "C4v\xe2\x81\xb6", "C4v\xe2\x81\xb7", "C4v\xe2\x81\xb8",
    "C4v\xe2\x81\xb9", "C4v\xc2\xb9\xe2\x81\xb0", "C4v\xc2\xb9\xc2\xb9",
    "C4v\xc2\xb9\xc2\xb2", "D2d\xc2\xb9", "D2d\xc2\xb2", "D2d\xc2\xb3",
    "D2d\xe2\x81\xb4", "D2d\xe2\x81\xb5", "D2d\xe2\x81\xb6",
    "D2d\xe2\x81\xb7", "D2d\xe2\x81\xb8", "D2d\xe2\x81\xb9",
    "D2d\xc2\xb9\xe2\x81\xb0", "D2d\xc2\xb9\xc2\xb9",
    "D2d\xc2\xb9\xc2\xb2", "D4h\xc2\xb9", "D4h\xc2\xb2", "D4h\xc2\xb3",
    "D4h\xe2\x81\xb4", "D4h\xe2\x81\xb5", "D4h\xe2\x81\xb6",
    "D4h\xe2\x81\xb7", "D4h\xe2\x81\xb8", "D4h\xe2\x81\xb9",
    "D4h\xc2\xb9\xe2\x81\xb0", "D4h\xc2\xb9\xc2\xb9",
    "D4h\xc2\xb9\xc2\xb2", "D4h\xc2\xb9\xc2\xb3",
    "D4h\xc2\xb9\xe2\x81\xb4", "D4h\xc2\xb9\xe2\x81\xb5",
    "D4h\xc2\xb9\xe2\x81\xb6", "D4h\xc2\xb9\xe2\x81\xb7",
    "D4h\xc2\xb9\xe2\x81\xb8", "D4h\xc2\xb9\xe2\x81\xb9",
    "D4h\xc2\xb2\xe2\x81\xb0", "C3\xc2\xb9", "C3\xc2\xb2", "C3\xc2\xb3",
    "C3\xe2\x81\xb4", "C3i\xc2\xb9", "C3i\xc2\xb2", "D3\xc2\xb9",
    "D3\xc2\xb2", "D3\xc2\xb3", "D3\xe2\x81\xb4", "D3\xe2\x81\xb5",
    "D3\xe2\x81\xb6", "D3\xe2\x81\xb7", "C3v\xc2\xb9", "C3v\xc2\xb2",
    "C3v\xc2\xb3", "C3v\xe2\x81\xb4", "C3v\xe2\x81\xb5",
    "C3v\xe2\x81\xb6", "D3d\xc2\xb9", "D3d\xc2\xb2", "D3d\xc2\xb3",
    "D3d\xe2\x81\xb4", "D3d\xe2\x81\xb5", "D3d\xe2\x81\xb6", "C6\xc2\xb9",
    "C6\xc2\xb2", "C6\xc2\xb3", "C6\xe2\x81\xb4", "C6\xe2\x81\xb5",
    "C6\xe2\x81\xb6", "C3h\xc2\xb9", "C6h\xc2\xb9", "C6h\xc2\xb2",
    "D6\xc2\xb9", "D6\xc2\xb2", "D6\xc2\xb3", "D6\xe2\x81\xb4",
    "D6\xe2\x81\xb5", "D6\xe2\x81\xb6", "C6v\xc2\xb9", "C6v\xc2\xb2",
    "C6v\xc2\xb3", "C6v\xe2\x81\xb4", "D3h\xc2\xb9", "D3h\xc2\xb2",
    "D3h\xc2\xb3", "D3h\xe2\x81\xb4", "D6h\xc2\xb9", "D6h\xc2\xb2",
    "D6h\xc2\xb3", "D6h\xe2\x81\xb4", "T\xc2\xb9", "T\xc2\xb2",
    "T\xc2\xb3", "T\xe2\x81\xb4", "T\xe2\x81\xb5", "Th\xc2\xb9",
    "Th\xc2\xb2", "Th\xc2\xb3", "Th\xe2\x81\xb4", "Th\xe2\x81\xb5",
    "Th\xe2\x81\xb6", "Th\xe2\x81\xb7", "O\xc2\xb9", "O\xc2\xb2",
    "O\xc2\xb3", "O\xe2\x81\xb4", "O\xe2\x81\xb5", "O\xe2\x81\xb6",
    "O\xe2\x81\xb7", "O\xe2\x81\xb8", "Td\xc2\xb9", "Td\xc2\xb2",
    "Td\xc2\xb3", "Td\xe2\x81\xb4", "Td\xe2\x81\xb5", "Td\xe2\x81\xb6",
    "Oh\xc2\xb9", "Oh\xc2\xb2", "Oh\xc2\xb3", "Oh\xe2\x81\xb4",
    "Oh\xe2\x81\xb5", "Oh\xe2\x81\xb6", "Oh\xe2\x81\xb7",
    "Oh\xe2\x81\xb8", "Oh\xe2\x81\xb9", "Oh\xc2\xb9\xe2\x81\xb0",
};


/*
 * PowderCell uses settings (the second number after RGNR) that are listed at:
 * http://www.ccp14.ac.uk/ccp/web-mirrors/powdcell/a_v/v_1/powder/details/setting.htm
 * The following table was generated from PCWSPGR.DAT file. In this file
 * lines starting with "spgr" contain description of settings.
 * Examples:
 *
 * spgr   3  1  3  0  2  4  1   P 1 2 1
 * spgr  48  1  5  0  8 12  3   P n n n
 * spgr  48  2  5  1  4 12  2   P n n n
 * spgr 155  1 11  0  6  5  2   R 3 2
 * spgr 155  2 10  0  6  5  2   R 3 2
 *
 * We used the following records from these lines:
 * - the number of space-group type used in IT generally (2nd record)
 * - the corresponding Laue group (actually the code explained below, 4th)
 * - the existence of a inversion centre in origin (0...no, 1...yes) (5th)
 * - the full Hermann-Mauguin symbol (the last one), 
 *
 * The code of Laue group is useful to distinguish :R and :H settings:
 * 8 trigonal, rhombohedral coordinate system (-3)
 * 9 trigonal, hexagonal coordinate system (-3)
 * 10 trigonal, rhombohedral coordinate system (-3m)
 * 11 trigonal, hexagonal coordinate system (-3m)

 * Here we have a dictionary to match them with the settings in the table above.
 * E.g.  sg=15, pc_setting==9, std_setting==3 means that
 * "RGNR 15 9" <-> 4th setting for SG 15 in space_group_settings[]
 * If there is only one position in space_group_settings[] for given SG number,
 * of pc_setting=n corresponds to n-th position in space_group_settings[],
 * the item is omitted.
 */

typedef struct
{
    unsigned char sg; /* space group number */
    /* number that goes after SG number in PowderCell .cel file (1-18 or 0) */
    unsigned char pc_setting;
    /* 0 - 1st setting for this SG in the table above, 1 - 2nd, ... */
    unsigned char std_setting;
}
PowderCellSgSetting;

const PowderCellSgSetting powdercell_settings[] = {
{3,2,0}, {3,3,1}, {3,4,1}, {3,5,2}, {3,6,2},
{4,2,0}, {4,3,1}, {4,4,1}, {4,5,2}, {4,6,2},
{5,3,3}, {5,4,4}, {5,5,6}, {5,6,7}, {5,7,1}, {5,8,0}, {5,9,4}, {5,10,3},
{5,11,7}, {5,12,6}, {5,13,2}, {5,14,2}, {5,15,5}, {5,16,5}, {5,17,8}, {5,18,8},
{6,2,0}, {6,3,1}, {6,4,1}, {6,5,2}, {6,6,2},
{7,2,2}, {7,3,3}, {7,4,5}, {7,5,6}, {7,6,8}, {7,7,1}, {7,8,1}, {7,9,4},
{7,10,4}, {7,11,7}, {7,12,7}, {7,13,2}, {7,14,0}, {7,15,5}, {7,16,3}, {7,17,8},
{7,18,6},
{8,3,3}, {8,4,4}, {8,5,6}, {8,6,7}, {8,7,1}, {8,8,0}, {8,9,4}, {8,10,3},
{8,11,7}, {8,12,6}, {8,13,2}, {8,14,2}, {8,15,5}, {8,16,5}, {8,17,8}, {8,18,8},
{9,2,3}, {9,3,6}, {9,4,9}, {9,5,12}, {9,6,15}, {9,7,1}, {9,8,4}, {9,9,7},
{9,10,10}, {9,11,13}, {9,12,16}, {9,13,2}, {9,14,5}, {9,15,8}, {9,16,11},
{9,17,14},
{10,2,0}, {10,3,1}, {10,4,1}, {10,5,2}, {10,6,2},
{11,2,0}, {11,3,1}, {11,4,1}, {11,5,2}, {11,6,2},
{12,3,3}, {12,4,4}, {12,5,6}, {12,6,7}, {12,7,1}, {12,8,0}, {12,9,4},
{12,10,3}, {12,11,7}, {12,12,6}, {12,13,2}, {12,14,2}, {12,15,5}, {12,16,5},
{12,17,8}, {12,18,8},
{13,2,2}, {13,3,3}, {13,4,5}, {13,5,6}, {13,6,8}, {13,7,1}, {13,8,1}, {13,9,4},
{13,10,4}, {13,11,7}, {13,12,7}, {13,13,2}, {13,14,0}, {13,15,5}, {13,16,3},
{13,17,8}, {13,18,6},
{14,2,2}, {14,3,3}, {14,4,5}, {14,5,6}, {14,6,8}, {14,7,1}, {14,8,1}, {14,9,4},
{14,10,4}, {14,11,7}, {14,12,7}, {14,13,2}, {14,14,0}, {14,15,5}, {14,16,3},
{14,17,8}, {14,18,6},
{15,2,3}, {15,3,6}, {15,4,9}, {15,5,12}, {15,6,15}, {15,7,1}, {15,8,4},
{15,9,7}, {15,10,10}, {15,11,13}, {15,12,16}, {15,13,2}, {15,14,5}, {15,15,8},
{15,16,11}, {15,17,14},
{17,2,0}, {17,3,1}, {17,4,1}, {17,5,2}, {17,6,2},
{18,2,0}, {18,3,1}, {18,4,1}, {18,5,2}, {18,6,2},
{20,2,0}, {20,3,1}, {20,4,1}, {20,5,2}, {20,6,2},
{21,2,0}, {21,3,1}, {21,4,1}, {21,5,2}, {21,6,2},
{25,2,0}, {25,3,1}, {25,4,1}, {25,5,2}, {25,6,2},
{27,2,0}, {27,3,1}, {27,4,1}, {27,5,2}, {27,6,2},
{32,2,0}, {32,3,1}, {32,4,1}, {32,5,2}, {32,6,2},
{34,2,0}, {34,3,1}, {34,4,1}, {34,5,2}, {34,6,2},
{35,2,0}, {35,3,1}, {35,4,1}, {35,5,2}, {35,6,2},
{37,2,0}, {37,3,1}, {37,4,1}, {37,5,2}, {37,6,2},
{42,2,0}, {42,3,1}, {42,4,1}, {42,5,2}, {42,6,2},
{43,2,0}, {43,3,1}, {43,4,1}, {43,5,2}, {43,6,2},
{44,2,0}, {44,3,1}, {44,4,1}, {44,5,2}, {44,6,2},
{45,2,0}, {45,3,1}, {45,4,1}, {45,5,2}, {45,6,2},
{48,3,0}, {48,4,1}, {48,5,0}, {48,6,1}, {48,7,0}, {48,8,1}, {48,9,0},
{48,10,1}, {48,11,0}, {48,12,1},
{49,2,0}, {49,3,1}, {49,4,1}, {49,5,2}, {49,6,2},
{50,3,0}, {50,4,1}, {50,5,2}, {50,6,3}, {50,7,2}, {50,8,3}, {50,9,4},
{50,10,5}, {50,11,4}, {50,12,5},
{55,2,0}, {55,3,1}, {55,4,1}, {55,5,2}, {55,6,2},
{56,2,0}, {56,3,1}, {56,4,1}, {56,5,2}, {56,6,2},
{58,2,0}, {58,3,1}, {58,4,1}, {58,5,2}, {58,6,2},
{59,3,0}, {59,4,1}, {59,5,2}, {59,6,3}, {59,7,2}, {59,8,3}, {59,9,4},
{59,10,5}, {59,11,4}, {59,12,5},
{61,3,0}, {61,4,1}, {61,5,0}, {61,6,1},
{65,2,0}, {65,3,1}, {65,4,1}, {65,5,2}, {65,6,2},
{66,2,0}, {66,3,1}, {66,4,1}, {66,5,2}, {66,6,2},
{70,3,0}, {70,4,1}, {70,5,0}, {70,6,1}, {70,7,0}, {70,8,1}, {70,9,0},
{70,10,1}, {70,11,0}, {70,12,1},
{72,2,0}, {72,3,1}, {72,4,1}, {72,5,2}, {72,6,2},
{73,3,0}, {73,4,1}, {73,5,0}, {73,6,1},
{0,0,0}
};


const SpaceGroupSetting* get_sg_from_powdercell_rgnr(int sgn, int setting)
{
    const PowderCellSgSetting *i;
    const SpaceGroupSetting *sgs0 = find_first_sg_with_number(sgn);
    if (setting == 0 || (sgs0+1)->sgnumber != sgn)
        return sgs0;
    for (i = powdercell_settings; i->sg != 0; ++i)
        if (i->sg == sgn && i->pc_setting)
            return sgs0 + i->std_setting;
    /* if we are here, the setting is not in PowderCell table,
     * i.e. std_setting == pc_setting - 1 */
    return sgs0 + setting - 1;
}




#if 0
   ----------------------------- sm_dict.py -------------------------------
from cctbx import sgtbx

smrows = {}
for s in sgtbx.space_group_symbol_iterator():
    #print s.number(), s.universal_hermann_mauguin().replace(" ","_")
    sg = sgtbx.space_group(s.hall())
    for i in sg.smx():
        sm = i.as_int_array()
        for n, s in enumerate(i.as_xyz().split(",")):
            if s not in smrows:
                smrows[s] = sm[3*n:3*n+3] + (sm[9+n],)
            else:
                assert smrows[s] == sm[3*n:3*n+3] + (sm[9+n],)
keys = sorted(smrows.keys(), cmp=lambda x, y: cmp(len(x), len(y)) or cmp(x,y))

if __name__ == '__main__':
    for n, k in enumerate(keys):
        print '/* %s */ { "%-8s, %2d,%2d,%2d,%3d },' % (
                                        (chr(n+ord('0')),k+'"') + smrows[k])


   ----------------------------- list_sg.py -------------------------------

from cctbx import sgtbx
import sm_dict

def encode_xyz(xyz):
    return "".join(chr(sm_dict.keys.index(t)+ord('0')) for t in xyz.split(","))

for s in sgtbx.space_group_symbol_iterator():
    ext_ = s.extension()
    ext = ("'%s'" % ext_ if (ext_ and ext_ != '\0') else "0")
    qualif = '"%s"' % s.qualifier()
    hm = '"%s",' % s.hermann_mauguin()
    hall = '"%s"' % s.hall().replace('"', r'\"')
    sm = '""'.join(encode_xyz(m.as_xyz())
                   for m in sgtbx.space_group(s.hall()).smx()
                   if not m.is_unit_mx())
    print '{ %3d, %3s, %6s, %-13s %-17s,\n  "%s" },' % (
            s.number(), ext, qualif, hm, hall, sm)
#endif

