/*****************************************************************************

 Header:       FGWeatherVectorWrap.h	
 Author:       Christian Mayer
 Date started: 28.05.99

 -------- Copyright (C) 1999 Christian Mayer (fgfs@christianmayer.de) --------

 This program is free software; you can redistribute it and/or modify it under
 the terms of the GNU General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option) any later
 version.

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 details.

 You should have received a copy of the GNU General Public License along with
 this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 Place - Suite 330, Boston, MA  02111-1307, USA.

 Further information about the GNU General Public License can also be found on
 the world wide web at http://www.gnu.org.

FUNCTIONAL DESCRIPTION
------------------------------------------------------------------------------
make a wraper for an sgVec2 vector so that it can be used in a STL container

HISTORY
------------------------------------------------------------------------------
18.10.1999 Christian Mayer	Created
19.10.1999 Christian Mayer	change to use PLIB's sg instead of Point[2/3]D
				and lots of wee code cleaning
21.12.1999 Christian Mayer	Added a fix for compatibility to gcc 2.8 which
				suggested by Oliver Delise
*****************************************************************************/

/****************************************************************************/
/* SENTRY                                                                   */
/****************************************************************************/
#ifndef FGWeatherVectorWrap_H
#define FGWeatherVectorWrap_H

/****************************************************************************/
/* INCLUDES								    */
/****************************************************************************/
#include <sg.h>
		
/****************************************************************************/
/* DEFINES								    */
/****************************************************************************/
#if ( __GNU_C__ == 2 && __GNU_MAJOR__ < 9 )
#  define const_sgVec2 const sgVec2
#else
#  define const_sgVec2 const sgVec2&
#endif

struct sgVec2Wrap
{
    sgVec2 p;

    sgVec2Wrap();
    sgVec2Wrap( const_sgVec2 src ) { sgCopyVec2( p, src ); }
};

#endif /*FGWeatherVectorWrap_H*/
