parser Lisp:
    ignore:      '[ \t\n\r]+'
    token NUM:   '[0-9]+'
    token ID:    '[-+*/!@$%^&=.a-zA-Z0-9_]+'
    token STR:   r'"([^\\"]+|\\.)*"'

    rule expr:   ID              {{ return ('id',ID) }}
               | STR             {{ return ('str',eval(STR)) }}
               | NUM             {{ return ('num',atoi(NUM)) }}
               | "\\("           
                        {{ e = [] }}             # initialize the list
                 ( expr {{ e.append(expr) }} ) * # put each expr into the list
                 "\\)"  {{ return e }}           # return the list
