#include "nomen.h"

static enum encoding enc = e_iso8859_1;

static char str_Language[] = "English";
static char str_OK[] = "OK";
static unichar_t mnemonic_OK[] = 'O';
static char str_Cancel[] = "Cancel";
static unichar_t mnemonic_Cancel[] = 'C';
static char str_Open[] = "Open";
static unichar_t mnemonic_Open[] = 'O';
static char str_Save[] = "Save";
static unichar_t mnemonic_Save[] = 'S';
static char str_Filter[] = "Filter";
static unichar_t mnemonic_Filter[] = 'F';
static char str_New[] = "New";
static unichar_t mnemonic_New[] = 'N';
static char str_Replace[] = "Replace";
static char str_Fileexists[] = "File Exists";
/* "File, %s, exists. Replace it?" */
static char str_Fileexistspre[] = "File, ";
static char str_Fileexistspost[] = ", exists. Replace it?";
static char str_Createdir[] = "Create directory...";
static char str_Dirname[] = "Directory name?";
static char str_Couldntcreatedir[] = "Couldn't create directory";
static char str_SelectAll[] = "Select All";
static char mnemonic_SelectAll ='A';
static char *str_None ="None";
static char mnemonic_None ='N';
/* Menus ... */
static char str_File[] = "File";
static unichar_t mnemonic_File[] = 'F';
static char str_Edit[] = "Edit";
static unichar_t mnemonic_Edit[] = 'E';
static char str_View[] = "View";
static unichar_t mnemonic_View[] = 'V';
static char str_Window[] = "Window";
static unichar_t mnemonic_Window[] = 'W';
static char str_Help[] = "Help";
static unichar_t mnemonic_Help[] = 'H';
static char str_Recent[] = "Recent";
static unichar_t mnemonic_Recent[] = 't';
static char str_Revertfile[] = "Revert File";
static unichar_t mnemonic_Revertfile[] = 'R';
static char str_RevertTable[] = "Revert Table";
static char str_SaveAs[] = "Save as...";
static unichar_t mnemonic_Saveas[] = 'a';
static char str_Close[] = "Close";
static unichar_t mnemonic_Close[] = 'c';
static char str_Prefs[] = "Preferences...";
static unichar_t mnemonic_Prefs[] = 'e';
static char str_Quit[] = "Quit";
static unichar_t mnemonic_Quit[] = 'Q';
static char str_Undo[] = "Undo";
static unichar_t mnemonic_Undo[] = 'U';
static char str_Redo[] = "Redo";
static unichar_t mnemonic_Redo[] = 'R';
static char str_Cut[] = "Cut";
static unichar_t mnemonic_Cut[] = 't';
static char str_Copy[] = "Copy";
static unichar_t mnemonic_Copy[] = 'C';
static char str_Paste[] = "Paste";
static unichar_t mnemonic_Paste[] = 'P';
static char str_Clear[] = "Clear";
static unichar_t mnemonic_Clear[] = 'l';
static char str_Fit[] = "Fit";
static unichar_t mnemonic_Fit[] = 'F';
static char str_Zoomin[] = "Zoom in";
static unichar_t mnemonic_Zoomin[] = 'i';
static char str_Zoomout[] = "Zoom out";
static unichar_t mnemonic_Zoomout[] = 'o';
static char str_NextChar[] = "Next Char";
static unichar_t mnemonic_NextChar[] = 'N';
static char str_PrevChar[] = "Prev Char";
static unichar_t mnemonic_PrevChar[] = 'P';
static char str_Goto[] = "Goto";
static unichar_t mnemonic_Goto[] = 'G';
static char str_ShowInstrs[] = "Show Instructions";
static unichar_t mnemonic_ShowInstrs[] = 'I';
static char str_HideInstrs[] = "Hide Instructions";
static unichar_t mnemonic_HideInstrs[] = 'I';
static char str_ShowAddress[] = "Show Address";
static unichar_t mnemonic_ShowAddress[] = 'A';
static char str_HideAddress[] = "Hide Address";
static unichar_t mnemonic_HideAddress[] = 'A';
static char str_ShowGloss[] = "Show Gloss";
static unichar_t mnemonic_ShowGloss[] = 'l';
static char str_HideGloss[] = "Hide Gloss";
static unichar_t mnemonic_HideGloss[] = 'l';
static char str_ShowFore[] = "Show Splines";
static unichar_t mnemonic_ShowFore[] = 'S';
static char str_HideFore[] = "Hide Splines";
static unichar_t mnemonic_HideFore[] = 'S';
static char str_ShowGrid[] = "Show Grid";
static unichar_t mnemonic_ShowGrid[] = 'd';
static char str_HideGrid[] = "Hide Grid";
static unichar_t mnemonic_HideGrid[] = 'd';
static char str_ShowGridFit[] = "Show Grid Fit";
static unichar_t mnemonic_ShowGridFit[] = 'i';
static char str_HideGridFit[] = "Hide Grid Fit";
static unichar_t mnemonic_HideGridFit[] = 'i';
static char str_ShowRaster[] = "Show Raster";
static unichar_t mnemonic_ShowRaster[] = 'r';
static char str_HideRaster[] = "Hide Raster";
static unichar_t mnemonic_HideRaster[] = 'r';
static char str_ShowTwilight[] = "Show Twilight Points";
static unichar_t mnemonic_ShowTwilight[] = 'T';
static char str_HideTwilight[] = "Hide Twilight Points";
static unichar_t mnemonic_HideTwilight[] = 'T';
static char str_GridSize[] = "Grid Pixels per Em...";
static unichar_t mnemonic_GridSize[] = 'x';


static char *str_Mensis = "Mensis";
    /* ttfview.c */
static char *str_OpenTtf = "Open TTF...";
static char *str_TabMod = "Can't edit modified table"
static char *str_TabModNotBinary = "This table has been modified in such a way that\nthe binary editor can't edit it until you\nsave the file.\nWould you like to save the file now?";
static char *str_ReallyRevert = "Really Revert to old version?";
static char *str_RevertFailed = "Revert Failed!";
static char *str_FontChanged = "Font Changed";
static char *str_FontChangedSave = "Font %.100s has changed.\nWould you like to save it?";
static char *str_FontChangedSavem = "The file containing font %.100s has changed.\nWould you like to save it?";
static char *str_TablesOpen = "Tables Open";
static char *str_TablesOpenSave = "There are editor windows open looking at tables in font %.100s\nWould you like them to be parsed for changes and the font saved if it needs to be?";
static char *str_TablesOpenSavem = "There are editor windows open looking at tables in the file containing font %.100s\nWould you like them to be parsed for changes and the font saved it needs to be?";
static char *str_TablesOpenProcess = "There are editor windows open looking at tables in this file.\nWould you like the tables parsed before the file is saved?";
static char *str_TableNameMismatch = "Table name mismatch";
static char *str_TableMismatch = "You are attempting to replace the selected table with one of a different type.\nIs that really what you want to do?";
    /* ttffile.c */
static char *str_RestrictedRightsFont = "This font is marked with an FSType of 2 (Restricted\nLicense). That means it is not editable without the\npermission of the legal owner.\n\nDo you have such permission?";
static char *str_RestrictedFont = "Restricted Font";
    /* uiutil.c */
static char *str_Badnumberin = "Bad number in ";
    /* Table names */
static char *str_tbl_cmap = "Character to glyph mapping\nSpecifies the font's encoding";
static char *str_tbl_glyf = "Glyph data\nSpecifies the glyphs in the font";
static char *str_tbl_head = "Font header\nGeneral information about the font";
static char *str_tbl_hhea = "Horizontal header\nHigh level information about the font's\nhorizontal metrics";
static char *str_tbl_hmtx = "Horizontal metrics\nHorizontal metric (lbearing/width)\ninformation for each character";
static char *str_tbl_loca = "Index to location\nPointers specifying where each glyph\nbegins in the glyf table";
static char *str_tbl_maxp = "Maximum profile\nSpecifies various maxima of the font";
static char *str_tbl_name = "Naming table\nSpecifies the font name, copyright, etc.";
static char *str_tbl_post = "PostScript data\nSpecifies PostScript specific data\nand PostScript glyph names";
static char *str_tbl_OS2  = "OS/2 and Windows specific metrics";
static char *str_tbl_cvt  = "Control Value Table\nVarious integers used for instructing\n(hinting) the font";
static char *str_tbl_EBDT = "Embedded bitmap data (MS version)";
static char *str_tbl_EBLC = "Embedded bitmap location data (MS version)";
static char *str_tbl_EBSC = "Embedded bitmap scaling data";
static char *str_tbl_fpgm = "Font Program\nInvoked before the first use of the font.";
static char *str_tbl_gasp = "grid-fitting and scan conversion procedure (greyscale)";
static char *str_tbl_hdmx = "Horizontal device metrics\nPrecomputed metrics for certain point-sizes";
static char *str_tbl_kern = "Kerning\nKerning pairs";
static char *str_tbl_LTSH = "Linear threshold table\nSpecifies point at which metrics may be\nassumed to scale from htmx table";
static char *str_tbl_prep = "CVT Program\nInvoked before each time the font is rasterized.";
static char *str_tbl_PCLT = "PCL5\nInformation for HP printers";
static char *str_tbl_VDMX = "Vertical Device Metrics table\nPrecomputed metrics for certain point-sizes";
static char *str_tbl_vhea = "Vertical header\nHigh level information about the font's\nvertical metrics (for CJK fonts)";
static char *str_tbl_vmtx = "Vertical metrics";
static char *str_tbl_CFF  = "Compact Font Format\nPostscript outlines";
/*static char *str_tbl_fvar = "Obsolete multiple master table"*/
static char *str_tbl_MMSD = "Obsolete multiple master table"
static char *str_tbl_MMFX = "Obsolete multiple master table"
static char *str_tbl_BASE = "Baseline data\nSpecifies how to align glyphs from different scripts";
static char *str_tbl_GDEF = "Glyph definition data\nSpecifies caret locations inside ligatures\nand attachment points";
static char *str_tbl_GPOS = "Glyph positioning data\nSpecifies how to positions glyphs with\nrespect to each other in caligraphic and other\ncomplex scripts";
static char *str_tbl_GSUB = "Glyph substitution data\nSpecifies ligatures, alternate glyphs,\npositional variants, contextual substitutions";
static char *str_tbl_JSTF = "Justification data\nAnother set of glyph substitutions\nspecifically for justification";
static char *str_tbl_DSIG = "Digital Signature";
static char *str_tbl_VORG = "Vertical Origin";

static char *str_Tbl_acnt = "Accent Attachement";
static char *str_Tbl_avar = "Axis Variation";
static char *str_Tbl_bdat = "Bitmap data (Apple version)";
static char *str_Tbl_bhed = "Bitmap font header\nSame as 'head' table\nMeans no outline data, just bitmaps";
static char *str_Tbl_bloc = "Bitmap location data (Apple version)";
static char *str_Tbl_bsln = "Baseline";
static char *str_Tbl_cvar = "CVT variation";
static char *str_Tbl_fdsc = "Font Descriptor";
static char *str_Tbl_feat = "Layout Features";
static char *str_Tbl_fmtx = "Font Metrics";
static char *str_Tbl_fvar = "Font variation";
static char *str_Tbl_gvar = "Glyph variation";
static char *str_Tbl_hsty = "Horizontal Style";
static char *str_Tbl_just = "Justification";
static char *str_Tbl_lcar = "Ligature caret";
static char *str_Tbl_mort = "Metamorphosis";
static char *str_Tbl_morx = "Extended Metamorphosis";
static char *str_Tbl_opbd = "Optical Bounds";
static char *str_Tbl_prop = "Properties";
static char *str_Tbl_trak = "Tracking";
static char *str_Tbl_Zapf = "Glyph Reference\nMaps glyphs to characters (unicode)\nand provides general character properties";

    /* maxp */
static char *str_Version = "Version:";
static char mnemonic_Version = 'V';
static char *str_Glyphs = "Glyphs:";
static char mnemonic_Glyphs = 'G';
static char *str_Points = "Points:";
static char mnemonic_Points = 'P';
static char *str_Contours = "Contours:";
static char mnemonic_Contours = 'C';
static char *str_CompositPoints = "Composit Pts:";
static char mnemonic_CompositPoints = 'n';
static char *str_CompositContours = "Composit Cntrs:";
static char mnemonic_CompositContours = 'r';
static char *str_Zones = "Zones:";
static char mnemonic_Zones = 'Z';
static char *str_TwilightPoints = "Twilight Pts:";
static char mnemonic_TwilightPoints = 'T';
static char *str_Storage = "Storage:";
static char mnemonic_Storage = 'S';
static char *str_FDEFs = "FDEFs:";
static char mnemonic_FDEFs = 'F';
static char *str_IDEFs = "IDEFs:";
static char mnemonic_IDEFs = 'I';
static char *str_StackElements = "Stack Els:";
static char mnemonic_StackElements = 'E';
static char *str_SizeOfInstructions = "Size Of Instrs:";
static char mnemonic_SizeOfInstructions = 'u';
static char *str_ComponentElements = "Component Els:";
static char mnemonic_ComponentElements = 'l';
static char *str_ComponentDepth = "CDepth:";
static char mnemonic_ComponentDepth = 'D';
static char *str_ChangingGlyphCnt = "Changing Glyph Count";
static char *str_ReallyChangeGlyphCnt = "Changing the glyph count is rather dangerous.\nDo you really want to do that?";

/* OS/2 */
static char *str_General = "General";
static char *str_Alignment = "Alignment";	/* Super/Subscript/Strikeout */
static char *str_Panose = "Panose";
static char *str_Charsets = "Charsets";
static char *str_AvgWidth = "Average Width:"
static char *str_UltraCondensed = "Ultra-Condensed (50%)"
static char *str_ExtraCondensed = "Extra-Condensed (62.5%)"
static char *str_Condensed75 = "Condensed (75%)"
static char *str_SemiCondensed = "Semi-Condensed (87.5%)"
static char *str_Medium100 = "Medium (100%)"
static char *str_SemiExpanded = "Semi-Expanded (112.5%)"
static char *str_Expanded125 = "Expanded (125%)"
static char *str_ExtraExpanded = "Extra-Expanded (150%)"
static char *str_UltraExpanded = "Ultra-Expanded (200%)"
static char *str_Thin100 = "100 Thin";
static char *str_ExtraLight200 = "200 Extra-Light";
static char *str_Light300 = "300 Light";
static char *str_Book400 = "400 Book";
static char *str_Medium500 = "500 Medium";
static char *str_DemiBold600 = "600 Demi-Bold";
static char *str_Bold700 = "700 Bold";
static char *str_Heavy800 = "800 Heavy";
static char *str_Black900 = "900 Black";
static char *str_EmbeddablePopup = "Can this font be embedded in a downloadable (pdf)\ndocument and if so what behaviors are permitted on\nboth the document and the font.\nAlso known as FSType";
static char *str_Embeddable = "Embeddable:";
static char mnemonic_Embeddable = 'E';
static char *str_NeverEmbeddable = "Never Embed/No Editing";
static char *str_OnlyPrint = "Printable Document";
static char *str_EditableDoc = "Editable Document";
static char *str_Installable = "Installable Font";
static char *str_NoSubsetting = "No Subsetting";
static char *str_NoSubsettingPopup = "If set then the entire font must be\nembedded in a document when any character is.\nOtherwise the document creator need\nonly include the characters it uses.";
static char *str_OnlyBitmaps = "Only Bitmaps";
static char *str_OnlyBitmapsPopup = "Only Bitmaps may be embedded\nOutline descriptions may not be\n(if font file contains no bitmaps\nthen nothing may be embedded)";
static char *str_Serif = "Serif";
static char *str_SansSerif = "Sans-Serif";
static char *str_Monospace = "Monospace";
static char *str_Script = "Script";
static char *str_Decorative = "Decorative";
static char *str_Any = "Any";
static char *str_NoFit = "No Fit";
static char *str_TextDisplay = "Text & Display";
static char *str_Pictoral = "Pictoral";
static char *str_Cove = "Cove";
static char *str_ObtuseCove = "Obtuse Cove";
static char *str_SquareCove = "Square Cove";
static char *str_ObtuseSquareCove = "Obtuse Square Cove";
static char *str_Square = "Square";
static char *str_Thin = "Thin";
static char *str_Bone = "Bone";
static char *str_Exaggerated = "Exaggerated";
static char *str_Triangle = "Triangle";
static char *str_NormalSans = "Normal Sans";
static char *str_ObtuseSans = "Obtuse Sans";
static char *str_PerpSans = "Perp Sans";
static char *str_Flared = "Flared";
static char *str_Rounded = "Rounded";
static char *str_VeryLight = "Very Light";
static char *str_Light = "Light";
static char *str_Book = "Book";
static char *str_Medium = "Medium";
static char *str_Demi = "Demi";
static char *str_Bold = "Bold";
static char *str_Heavy = "Heavy";
static char *str_Black = "Black";
static char *str_Nord = "Nord";
static char *str_OldStyle = "Old Style";
static char *str_Modern = "Modern";
static char *str_EvenWidth = "Even Width";
static char *str_Expanded = "Expanded";
static char *str_Condensed = "Condensed";
static char *str_VeryExpanded = "Very Expanded";
static char *str_VeryCondensed = "Very Condensed";
static char *str_Monospaced ="Monospaced";
static char *str_None ="None";
static char *str_VeryLow ="Very Low";
static char *str_Low ="Low";
static char *str_MediumLow ="Medium Low";
static char *str_MediumHigh ="Medium High";
static char *str_High ="High";
static char *str_VeryHigh ="Very High";
static char *str_GradDiag ="Gradual/Diagonal";
static char *str_GradTrans ="Gradual/Transitional";
static char *str_GradVert ="Gradual/Vertical";
static char *str_GradHor ="Gradual/Horizontal";
static char *str_RapidVert ="Rapid/Vertical";
static char *str_RapidHor ="Rapid/Horizontal";
static char *str_InstantVert ="Instant/Vertical";
static char *str_NormalContact ="Normal/Contact";
static char *str_NormalWeighted ="Normal/Weighted";
static char *str_NormalBoxed ="Normal/Boxed";
static char *str_NormalFlattened ="Normal/Flattened";
static char *str_NormalRounded ="Normal/Rounded";
static char *str_NormalOffCenter ="Normal/Off-Center";
static char *str_NormalSquare ="Normal/Square";
static char *str_ObliqueContact ="Oblique/Contact";
static char *str_ObliqueWeighted ="Oblique/Weighted";
static char *str_ObliqueBoxed ="Oblique/Boxed";
static char *str_ObliqueFlattened ="Oblique/Flattened";
static char *str_ObliqueRounded ="Oblique/Rounded";
static char *str_ObliqueOffCenter ="Oblique/Off-Center";
static char *str_ObliqueSquare ="Oblique/Square";
static char *str_StraightArmsH = "Straight Arms/Horizontal";
static char *str_StraightArmsW = "Straight Arms/Wedge";
static char *str_StraightArmsV = "Straight Arms/Vertical";
static char *str_StraightArmsSS = "Straight Arms/Single Serif";
static char *str_StraightArmsDS = "Straight Arms/Double Serif";
static char *str_NStraightArmsH = "Non-Straight Arms/Horizontal";
static char *str_NStraightArmsW = "Non-Straight Arms/Wedge";
static char *str_NStraightArmsV = "Non-Straight Arms/Vertical";
static char *str_NStraightArmsSS = "Non-Straight Arms/Single Serif";
static char *str_NStraightArmsDS = "Non-Straight Arms/Double Serif";
static char *str_StandardTrimmed = "Standard/Trimmed";
static char *str_StandardPointed = "Standard/Pointed";
static char *str_StandardSerifed = "Standard/Serifed";
static char *str_HighTrimmed = "High/Trimmed";
static char *str_HighPointed = "High/Pointed";
static char *str_HighSerifed = "High/Serifed";
static char *str_ConstantTrimmed = "Constant/Trimmed";
static char *str_ConstantPointed = "Constant/Pointed";
static char *str_ConstantSerifed = "Constant/Serifed";
static char *str_LowTrimmed = "Low/Trimmed";
static char *str_LowPointed = "Low/Pointed";
static char *str_LowSerifed = "Low/Serifed";
static char *str_ConstantSmall = "Constant/Small";
static char *str_ConstantStandard = "Constant/Standard";
static char *str_ConstantLarge = "Constant/Large";
static char *str_DuckingSmall = "Ducking/Small";
static char *str_DuckingStandard = "Ducking/Standard";
static char *str_DuckingLarge = "Ducking/Large";
static char *str_WidthClass ="Width Class:";
static char mnemonic_WidthClass ='C';
static char *str_WeightClass ="Weight Class:";
static char mnemonic_WeightClass ='W';
static char *str_Family ="Family";
static char mnemonic_Family ='F';
static char *str_Serifs ="Serifs";
static char mnemonic_Serifs ='S';
static char *str_Weight ="Weight";
static char mnemonic_Weight ='W';
static char *str_Proportion ="Proportion";
static char mnemonic_Proportion ='P';
static char *str_Contrast ="Contrast";
static char mnemonic_Contrast ='C';
static char *str_StrokeVar ="Stroke Variation";
static char mnemonic_StrokeVar ='V';
static char *str_ArmStyle ="Arm Style";
static char mnemonic_ArmStyle ='A';
static char *str_Letterform ="Letterform";
static char mnemonic_Letterform ='L';
static char *str_MidLine ="Midline";
static char mnemonic_MidLine ='M';
static char *str_XHeight ="X-Height";
static char mnemonic_XHeight ='X';
static char *str_SubXSize = "Sub X Size:";
static char *str_SubYSize = "Sub Y Size:";
static char *str_SubXOffset = "Sub X Offset:";
static char *str_SubYOffset = "Sub Y Offset:";
static char *str_SupXSize = "Sup X Size:";
static char *str_SupYSize = "Sup Y Size:";
static char *str_SupXOffset = "Sup X Offset:";
static char *str_SupYOffset = "Sup Y Offset:";
static char *str_StrikeSize = "Strikeout Size:";
static char *str_StrikePos = "Strikeout Pos:";
static char *str_IBMFamily = "IBM Family:"
static char mnemonic_IBMFamily = 'I';
static char *str_NoClassification = "No Classification";
static char *str_OldStyleSerifs = "Old Style Serifs";
static char *str_OSSRoundedLegibility = "OSS Rounded Legibility";
static char *str_OSSGeralde = "OSS Geralde";
static char *str_OSSVenetian = "OSS Venetian";
static char *str_OSSModifiedVenetian = "OSS Modified Venetian";
static char *str_OSSDutchModern = "OSS Dutch Modern";
static char *str_OSSDutchTrad = "OSS Dutch Trad";
static char *str_OSSContemporary = "OSS Contemporary";
static char *str_OSSCaligraphic = "OSS Caligraphic";
static char *str_OSSMiscellaneous = "OSS Miscellaneous";
static char *str_TransitionalSerifs = "Transitional Serifs";
static char *str_TSDirectLine = "TS Direct Line";
static char *str_TSScript = "TS Script";
static char *str_TSMiscellaneous = "TS Miscellaneous";
static char *str_ModernSerifs = "Modern Serifs";
static char *str_MSItalian = "MS Italian";
static char *str_MSScript = "MS Script";
static char *str_MSMiscellaneous = "MS Miscellaneous";
static char *str_ClarendonSerifs = "Clarendon Serifs";
static char *str_CSClarendon = "CS Clarendon";
static char *str_CSModern = "CS Modern";
static char *str_CSTraditional = "CS Traditional";
static char *str_CSNewspaper = "CS Newspaper";
static char *str_CSStubSerif = "CS Stub Serif";
static char *str_CSMonotone = "CS Monotone";
static char *str_CSTypewriter = "CS Typewriter";
static char *str_CSMiscellaneous = "CS Miscellaneous";
static char *str_SlabSerifs = "Slab Serifs";
static char *str_SSMonotone = "SS Monotone";
static char *str_SSHumanist = "SS Humanist";
static char *str_SSGeometric = "SS Geometric";
static char *str_SSSwiss = "SS Swiss";
static char *str_SSTypewriter = "SS Typewriter";
static char *str_SSMiscellaneous = "SS Miscellaneous";
static char *str_FreeformSerifs = "Freeform Serifs";
static char *str_FSModern = "FS Modern";
static char *str_FSMiscellaneous = "FS Miscellaneous";
/*static char *str_SansSerif = "Sans Serif";*/
static char *str_SSIBMNeoGrotesqueGothic = "SS IBM NeoGrotesque Gothic";
/*static char *str_SSHumanist = "SS Humanist";*/
static char *str_SSLowxRoundGeometric = "SS Low-x Round Geometric";
static char *str_SSHighxRoundGeometric = "SS High-x Round Geometric";
static char *str_SSNeoGrotesqueGothic = "SS NeoGrotesque Gothic";
static char *str_SSModifiedGrotesqueGothic = "SS Modified Grotesque Gothic";
static char *str_SSTypewriterGothic = "SS Typewriter Gothic";
static char *str_SSMatrix = "SS Matrix";
/*static char *str_SSMiscellaneous = "SS Miscellaneous";*/
static char *str_Ornamentals = "Ornamentals";
static char *str_OEngraver = "O Engraver";
static char *str_OBlackLetter = "O Black Letter";
static char *str_ODecorative = "O Decorative";
static char *str_O3D = "O Three Dimensional";
static char *str_OMiscellaneous = "O Miscellaneous";
static char *str_Scripts = "Scripts";
static char *str_SUncial = "S Uncial";
static char *str_SBrushJoined = "S Brush Joined";
static char *str_SFormalJoined = "S Formal Joined";
static char *str_SMonotoneJoined = "S Monotone Joined";
static char *str_SCaligraphic = "S Caligraphic";
static char *str_SBrushUnjoined = "S Brush Unjoined";
static char *str_SFormalUnjoined = "S Formal Unjoined";
static char *str_SMonotoneUnjoined = "S Monotone Unjoined";
static char *str_SMiscellaneous = "S Miscellaneous";
static char *str_Symbolic = "Symbolic";
static char *str_SyMixedSerif = "Sy Mixed Serif";
static char *str_SyOldStyleSerif = "Sy Old Style Serif";
static char *str_SyNeoGrotesqueSansSerif = "Sy Neo-grotesque Sans Serif";
static char *str_SyMiscellaneous = "Sy Miscellaneous";
static char *str_VendorID = "Vendor ID:";
static char *mnemonic_VendorID = 'V';
static char *str_UnicodeRanges = "Unicode Ranges"
static char *mnemonic_UnicodeRanges = 'U';
static char *str_BasicLatin = "Basic Latin 0000-007f";
static char *str_Latin1Sup = "Latin-1 Sup 0080-00ff";
static char *str_LatinExtA = "Latin Ext-A 0100-017f";
static char *str_LatinExtB = "Latin Ext-B 0180-024f";
static char *str_IPAExten = "IPA Extensions 0250-02Af";
static char *str_SpacingModLetters = "Spacing Mod Letters 02B0-02FF";
static char *str_CombiningDiacritics = "Combining Diacritics 0300-036F";
static char *str_UGreek = "Greek 0370-03FF";
static char *str_GreekSymCoptic = "Obsolete Greek Symbols & Coptic";
static char *str_Cyrillic = "Cyrillic 0400-052F";
static char *str_Armenian = "Armenian 0530-058F";
static char *str_UHebrew = "Hebrew 0590-05FF";
static char *str_HebrewExtended = "Obsolete Extended Hebrew";
static char *str_UArabic = "Arabic 0600-06FF";
static char *str_ArabicExtended = "Obsolete Extended Arabic";
static char *str_Devanagari = "Devanagari 0900-097F";
static char *str_Bengali = "Bengali 0980-09FF";
static char *str_Gurmukhi = "Gurmukhi 0A00-0A7F";
static char *str_Gujarati = "Gujarati 0A80-0AFF";
static char *str_Oriya = "Oriya 0B00-0B7F";
static char *str_Tamil = "Tamil 0B80-0BFF";
static char *str_Telegu = "Telegu 0C00-0C7F";
static char *str_Kannada = "Kannada 0C80-0CFF";
static char *str_Malayalam = "Malayalam 0D00-0D7F";
static char *str_Thai = "Thai 0E00-0E7F";
static char *str_Loa = "Loa 0E80-0EFF";
static char *str_Georgian = "Georgian 10A0-10FF";
static char *str_GeorgianExtended = "Obsolete Extended Georgian";
static char *str_HangulJamo = "Hangul Jamo 1100-11FF";
static char *str_LatinAdditional = "Latin Additional 1E00-1EFF";
static char *str_GreekAdditional = "Greek Additional 1F00-1FFF";
static char *str_Punctuation = "Punctuation 2000-206F";
static char *str_SubSuperscripts = "Sub/Super scripts 2070-209F";
static char *str_Currency = "Currency 20A0-20CF";
static char *str_CombSymbolDiac = "Combining Symbol Diacritics 20D0-20FF";
static char *str_LeterlikeSymbols = "Letterlike Symbols 2100-214F";
static char *str_NumberForms = "Number Forms 2150-218F";
static char *str_Arrows = "Arrows 2190-21FF";
static char *str_MathOpers = "Math Opers 2200-22FF";
static char *str_MiscTech = "Misc Technical 2300-23FF";
static char *str_ControlPictures = "Control Pictures 2400-233F";
static char *str_OCR = "OCR 2440-245F";
static char *str_EnclosedAlphanumerics = "Enclosed Alphanumerics 2460-24FF";
static char *str_BoxDrawing = "Box Drawing 2500-257F";
static char *str_BlockElements = "Block Elements 2580-259F";
static char *str_GeometricShapes = "Geometric Shapes 25A0-25FF";
static char *str_MiscSymbols = "Misc Symbols 2600-267F";
static char *str_Dingbats = "Dingbats 2700-27BF";
static char *str_CJKSymPunct = "CJK Symbols & Punct 3000-303F";
static char *str_Hiragana = "Hiragana 3040-309F";
static char *str_Katakana = "Katakana 30A0-30FF";
static char *str_Bopomofo = "Bopomofo 3100-312F, 3180-31AF";
static char *str_HangulCompatJamo = "Hangul Compat. Jamo 3130-318F";
static char *str_CJKMisc = "CJK Misc 31B0-31FF";
static char *str_EnclosedLettersMonths = "Enclosed Letters Months 3200-32FF";
static char *str_CJKCompat = "CJK Compatability 3300-33FF";
static char *str_Hangul = "Hangul AC00-D7AF";
static char *str_Surrogates = "Surrogates 10000-7FFFFFFF";
static char *str_Unassignedbit58 = "Unassigned bit 58";
static char *str_CJK = "CJK 2E80-29FF, 3400-9FFF"; 
static char *str_PrivateUse = "Private Use E000-F8FF"; 
static char *str_CJKCompatIdeo = "CJK Compat. Ideographs F900-FAFF"; 
static char *str_AlphabeticPresentationForms = "Alphabetic Forms FB00-FB4F"; 
static char *str_ArabicPresentationFormsA = "Arabic Forms-A FB50-FDFF"; 
static char *str_CombiningHalfMarks = "Combining Half Marks FE20-FE2F"; 
static char *str_CJKCompatForms = "CJK Compatability Forms FE30-FE4F"; 
static char *str_SmallForms = "Small Forms FE50-FE6F"; 
static char *str_ArabicPresentationFormsB = "Arabic Forms-B FE70-FEFF"; 
static char *str_HalfFullWidthForms = "Half/Full Width Forms FF00-FFEF";
static char *str_Specials = "Specials FFF0-FFFF";
static char *str_Tibetan = "Tibetan 0F00-0FFF";
static char *str_Syriac = "Syriac 0700-074F";
static char *str_Thaana = "Thaana 0780-07BF";
static char *str_Sinhala = "Sinhala 0D80-0DBF";
static char *str_Myanmar = "Myanmar 1000-109F";
static char *str_Ethiopic = "Ethiopic 1200-12FF";
static char *str_Cherokee = "Cherokee 13A0-13FF";
static char *str_UnitedCanSyl = "United Canadian Syllabics 1400-167F";
static char *str_Ogham = "Ogham 1680-169F";
static char *str_Runic = "Runic 16A0-16FF";
static char *str_Khmer = "Khmer 1780-17FF";
static char *str_Mongolian = "Mongolian 1800-18AF";
static char *str_Braille = "Braille 2800-28FF";
static char *str_Yi = "Yi & Yi Radicals A000-A4AF";
static char *str_Unassignedbit84 = "Unassigned bit 84";
static char *str_Add = "Add";
static char *str_Remove = "Remove";
static char *str_FirstUnicode = "First Unicode:";
static char *str_LastUnicode = "Last:";
static char *str_Selection = "Selection:";
static char *str_Italic = "Italic";
static char *str_Underscore = "Underscore";
static char *str_Negative = "Negative";
static char *str_Outlined = "Outlined";
static char *str_Strikeout = "Strikeout";
static char *str_Regular = "Regular";
static char *str_CodePages = "CodePages:";
static char *str_CPLatin1 = "1252 Latin1";
static char *str_CPLatin2 = "1250 Latin2";
static char *str_CPCyrillic = "1251 Cyrillic";
static char *str_CPGreek = "1253 Greek";
static char *str_CPTurkish = "1254 Turkish";
static char *str_CPHebrew = "1255 Hebrew";
static char *str_CPArabic = "1256 Arabic";
static char *str_CPBaltic = "1257 Windows Baltic";
static char *str_CPVietnamese = "1258 Vietnamese";
static char *str_CPThai = "874 Thai";
static char *str_CPJapan = "932 JIS/Japan";
static char *str_CPSimplifiedChinese = "936 Simplified Chinese";
static char *str_CPWansung = "949 Korean Wansung";
static char *str_CPTraditionalChinese = "950 Traditional Chinese";
static char *str_CPJohab = "1361 Korean Johab";
static char *str_CPMac = "Mac Roman";
static char *str_CPOEM = "OEM Charset";
static char *str_CPSymbol = "Symbol Charset";
static char *str_CPIBMGreek = "869 IBM Greek";
static char *str_CPDOSRussian = "866 MS/DOS Russian";
static char *str_CPDOSNordic = "865 MS/DOS Nordic";
static char *str_CPArabic2 = "864 Arabic";
static char *str_CPDOSFrench = "863 MS/DOS Canadian French";
static char *str_CPHebrew2 = "862 Hebrew";
static char *str_CPDOSIcelandic = "861 MS/DOS Icelandic";
static char *str_CPDOSPortuguese = "860 MS/DOS Portuguese";
static char *str_CPIBMTurkish = "857 IBM Turkish";
static char *str_CPIBMCyrillic = "855 IBM Cyrillic";
static char *str_CPLatin22 = "852 Latin2";
static char *str_CPIBMBaltic = "775 IBM Baltic";
static char *str_CPGreek3 = "737 Greek";
static char *str_CPArabic3 = "708 Arabic";
static char *str_CPLatin12 = "850 WE/Latin1";
static char *str_CPUS = "437 US";
static char *str_Typography = "Typo";
static char *str_TypoAscender = "Ascender:";
static char *str_TypoDescender = "Descender:";
static char *str_TypoRight = "Typo Right:";
static char *str_TypoLeft = "Typo Left:";
static char *str_TypoLineGap = "Line Gap:";
static char *str_TypoLineSpacing = "Line Spacing:";
static char *str_WinAscent = "Win Ascent:";
static char *str_WinDescent = "Win Descent:";
static char *str_XHeightC = "X-Height:";
static char *str_CapHeightC = "Cap-Height:";
static char *str_DefaultChar = "Default Char:";
static char *str_BreakChar = "Break Char:";
static char *str_MaxContext = "Max Context:";

/* name */
    /* Platforms */
static char *str_AppleUnicode = "Unicode";
static char *str_Mac = "Mac";
static char *str_ISO = "ISO";
static char *str_Microsoft = "MS";
    /* Apple Unicode Specific */
static char *str_Default = "Default";
static char *str_Unicode1 = "Unicode 1.0";
static char *str_Unicode11 = "Unicode 1.1";
static char *str_Unicode2 = "Unicode 2.0";
    /* ISO Specific */
static char *str_ASCII = "ASCII";	/* ISO 646-1 */
static char *str_ISO106461 = "ISO 10646-1";
static char *str_ISO88591 = "ISO 8859-1";
    /* MS Specific */
static char *str_Unicode = "Unicode";
    /* Mac Specific */
static char *str_ApRoman = "Roman";
static char *str_ApJapanese = "Japanese";
static char *str_ApChinese = "Chinese";
static char *str_ApKorean = "Korean";
static char *str_ApArabic = "Arabic";
static char *str_ApHebrew = "Hebrew";
static char *str_ApGreek = "Greek";
static char *str_ApRussian = "Russian";
static char *str_ApRSymbol = "RSymbol";
static char *str_ApDevanagari = "Devanagari";
static char *str_ApGurmukhi = "Gurmukhi";
static char *str_ApGujarati = "Gujarati";
static char *str_ApOriya = "Oriya";
static char *str_ApBengali = "Bengali";
static char *str_ApTamil = "Tamil";
static char *str_ApTelugu = "Telugu";
static char *str_ApKannada = "Kannada";
static char *str_ApMalayalam = "Malayalam";
static char *str_ApSinhalese = "Sinhalese";
static char *str_ApBurmese = "Burmese";
static char *str_ApKhmer = "Khmer";
static char *str_ApThai = "Thai";
static char *str_ApLoatian = "Loatian";
static char *str_ApGeorgian = "Georgian";
static char *str_ApArmenian = "Armenian";
static char *str_ApMaldivian = "Maldivian";
static char *str_ApTibetan = "Tibetan";
static char *str_ApMongolian = "Mongolian";
static char *str_ApGeez = "Geez";
static char *str_ApSlavic = "Slavic";
static char *str_ApVietnamese = "Vietnamese";
static char *str_ApSindhi = "Sindhi";
static char *str_Uninterpreted = "Uninterp";
    /* Apple Language list */
static char *str_ApEnglish = "English";
static char *str_ApFrench = "French";
static char *str_ApGerman = "German";
static char *str_ApItalian = "Italian";
static char *str_ApDutch = "Dutch";
static char *str_ApSwedish = "Swedish";
static char *str_ApSpanish = "Spanish";
static char *str_ApDanish = "Danish";
static char *str_ApPortuguese = "Portuguese";
static char *str_ApNorwegian = "Norwegian";
static char *str_ApFinnish = "Finnish";
static char *str_ApIcelandic = "Icelandic";
static char *str_ApMaltese = "Maltese";
static char *str_ApTurkish = "Turkish";
static char *str_ApYugoslavian = "Yugoslavian";
static char *str_ApUrdu = "Urdu";
static char *str_ApHindi = "Hindi";
    /* MS Language list */
/* Language & Country (where applicable) in the native language if I can find */
/*  it, in english if I can't. Followed by the 2char language _ 2char country */
/* (again country isn't always applicable. Should basque be ES, FR? */
static char *str_Albanian = "Albanian sq_AL";
static char *str_Arabic = "Arabic ar";
static char *str_Basque = "Basque eu";
static char *str_Byelorussian = "Byelorussian be_BY";
static char *str_Bulgarian = "Bulgarian bg_BG";
static char *str_Catalan = "Catalan ca";
static char *str_MSChinese = "Chinese zh_CN";
static char *str_Croatian = "Croatian hr";
static char *str_Czech = "Czech cs_CZ";
static char *str_Danish = "Dansk da_DK";
static char *str_Dutch = "Nederlands nl_NL";
static char *str_Flemish = "Nederlands nl_BE";
static char *str_BrEnglish = "British English en_UK";
static char *str_AmEnglish = "American English en_US";
static char *str_CaEnglish = "Canadian English en_CA";
static char *str_AuEnglish = "Australian English en_AU";
static char *str_NZEnglish = "New Zeeland English en_NZ";
static char *str_IEEnglish = "Irish English en_IE";
static char *str_Estonia = "Estonian et_EE";
static char *str_Finnish = "Suomi fi_FI";
static char *str_FRFrench = "Franais Franais fr_FR";
static char *str_BEFrench = "Franais Belgique fr_BE";
static char *str_CAFrench = "Franais Canadien fr_CA";
static char *str_CHFrench = "Franais Suiss fr_CH";
static char *str_LUFrench = "Franais de Luxembourg fr_LU";
static char *str_DEGerman = "Deutsch Deutsch de_DE";
static char *str_CHGerman = "Schweizer Deutsch de_CH";
static char *str_ATGerman = "sterreichisch Deutsch de_AT";
static char *str_LUGerman = "Luxembourg Deutsch de_LU";
static char *str_LIGerman = "Liechtenstein Deutsch de_LI";
static char *str_Greek = "Greek el_GR";
static char *str_Hebrew = "Hebrew he_IL";
static char *str_Hungarian = "Hungarian hu_HU";
static char *str_Icelandic = "Icelandic is_IS";
static char *str_Italian = "Italiano it_IT";
static char *str_CHItalian = "Italiano Swiss it_CH";
static char *str_Japanese = "Japanese jp_JP";
static char *str_Latvian = "Latvian lv_LV";
static char *str_Lithuanian = "Lithuanian lt_LT";
static char *str_Norwegian = "Norsk Bokmal no_NO";
static char *str_NorwegianN = "Norsk Nynorsk no_NO";
static char *str_Polish = "Polish pl_PL";
static char *str_PTPortuguese = "Portugus Portugus pt_PT";
static char *str_BRPortuguese = "Portugus Brasil pt_BR";
static char *str_Romanian = "Romanian ro_RO";
static unichar_t str_Russian = { 0x420, 0x443, 0x441, 0x441, 0x43a, 0x438, 0x439, ' ', 'r','u','_','R','U',  '\0' };
static char *str_Slovak = "Slovak sk_SK";
static char *str_Slovenian = "Slovenian sl_SI";
static char *str_TradSpanish = "Espaol Espaol es_ES";
static char *str_MXSpanish = "Espaol Mjico es_MX";
static char *str_ModSpanish = "Espaol Espaol es_ES";
static char *str_Swedish = "Svensk sv_SE";
static char *str_Turkish = "Turkish tr_TR";
static char *str_Ukrainian = "Ukrainian uk_UA";
    /* String types */
static char *str_Copyright = "Copyright";
static char *str_SubFamily = "SubFamily";
static char *str_UniqueID = "UniqueID";
static char *str_Fullname = "Fullname";
static char *str_Trademark = "Trademark";
static char *str_PostscriptName = "PS FontName";
static char *str_Manufacturer = "Manufacturer";
static char *str_Designer = "Designer";
static char *str_Descriptor = "Descriptor";
static char *str_VendorURL = "Vendor URL";
static char *str_DesignerURL = "Designer URL";
static char *str_License = "License";
static char *str_LicenseURL = "License URL";
static char *str_OTFFamily = "Preferred Family";
static char *str_OTFStyles = "Preferred Styles";
static char *str_CompatableFull = "Compatable Full";
static char *str_SampleText = "Sample Text";
static char *str_FontRevision = "Font Revision:";
static char *str_Checksum = "Checksum:";
static char *str_MagicNumber = "Magic Number:";
static char *str_Flags = "Flags:";
static char *str_Baseliney0 = "Baseline at y==0";
static char *str_LBearingx0 = "LBearing at x==0";
static char *str_InstrsDepOnPointsize = "Instrs Depend on Pointsize";
static char *str_ForcePPEMInt = "Force PPEM to integer";
static char *str_InstrsAlterWidth = "Instrs Alter Width";
static char *str_VerticalLayout = "Vertical Layout";
/*static char *str_Arabic = "Arabic";*/
static char *str_GXWithMetamorphosis = "GX With Metamorphosis";
static char *str_ContainsRightToLeft = "Contains Right To Left";
static char *str_Indic = "Indic";
static char *str_Lossless = "Lossless";
static char *str_FontConverted = "Font Converted";
static char *str_ClearType = "Clear Type";
static char *str_UnitsPerEm = "Units Per Em:";
static char *str_Created = "Created:";
static char *str_Modified = "Modified:";
static char *str_XMin = "XMin:";
static char *str_XMax = "XMax:";
static char *str_YMin = "YMin:";
static char *str_YMax = "YMax:";
static char *str_MacStyle = "Mac Style:";
static char *str_Underline = "Underline";
static char *str_Outline = "Outline";
static char *str_Shadow = "Shadow";
/*static char *str_Condensed = "Condensed";*/
static char *str_Extended = "Extended";
static char *str_SmallestSize = "Smallest Size:";
static char *str_FontDirection = "Font Direction:";
static char *str_FullyMixed = "Fully Mixed";
static char *str_StronglyLeftToRight = "Strongly Left To Right";
static char *str_LtoROrNeutral = "LtoR Or Neutral";
static char *str_StronglyRightToLeft = "Strongly Right To Left";
static char *str_RToLOrNeutral = "RToL Or Neutral";
static char *str_LocaFormat = "loca Format:";
static char *str_16bit = "16 bit";
static char *str_32bit = "32 bit";
static char *str_GlyfFormat = "glyf Format:";
    /* metrics headers (hhea,vhea) */
static char *str_Ascent = "Ascent:";
static char *str_Descent = "Descent:";
static char *str_AdvanceMax = "Advance Max:";
static char *str_MinLeftBearing = "Min LBearing:";
static char *str_MinRightBearing = "Min RBearing:";
static char *str_MinTopBearing = "Min TBearing:";
static char *str_MinBottomBearing = "Min BBearing:";
static char *str_XMaxExtent = "X Max Extent:";
static char *str_YMaxExtent = "Y Max Extent:";
static char *str_CaretRise = "Caret Rise:";
static char *str_CaretRun = "Caret Run:";
static char *str_CaretOffset = "Caret Offset:";
static char *str_DataFormat = "Data Format:";
static char *str_MetricsCount = "Metrics Count:";
static char *str_ChangingMetricsCount = "Changing Metrics Count";
static char *str_ReallyChangeMetricsCnt = "Changing the long metrics count is rather dangerous.\nDo you really want to do that?";
    /* metrics data (hmtx,vmtx) */
static char *str_GrowLongMetrics = "Do you want to exend the metrics table?";
static char *str_GrowLongMetricsSize = "You are attempting to change the width\nof a glyph whose width is currently set\nby default. Making this change requires\na change in the table format and the\n*hea table.\nIs that what you want?"
    /* post table */
static char *str_Names = "Names";
static char *str_Encoding = "Encoding";
static char *str_MaxMemType1 = "Max:";
static char *str_MinMemType1 = "Min Memory (Type1):";
static char *str_MaxMemType42 = "Max:";
static char *str_MinMemType42 = "Min Memory (Type42):";
static char *str_IsFixed = "Is Fixed:";
static char *str_ItalicAngle = "Italic Angle:";
static char *str_UnderlinePos = "Underline Pos:";
static char *str_UnderlineHeight = "Size:";
static char *str_PostVersion4 = "A table version of 4 for the post table\nspecifies an encoding rather than\na list of character names. All names\nwill be lost.\nIs that what you want?";
static char *str_PostNamesLost = "All names will be lost";
static char *str_PostVersion3 = "A table version of 3 for the post table\nspecifies there are no postscript names\nAll names will be lost.\nIs that what you want?";
static char *str_PostEncLost = "Encoding will be lost";
static char *str_PostNotVersion4 = "A table version other than 4.0 for the post table\nDoes not include the encoding\nIt will be lost.\nIs that what you want?";
static char *str_PostVersion1Len = "A table version of 1 for the post table\ncan specify at most 258 glyph names\nThis font has more glyphs, those beyond\n258 will not have names.\nIs that what you want?";
static char *str_PostVersion1 = "A table version of 1 for the post table\nonly works for macintosh encodings\nYou can't use it with the names in this font.";
static char *str_PostVersion2_5 = "A table version of 2.5 for the post table\nonly works for rearrangements of macintosh encodings\nYou can't use it with the names in this font.\n(And it's depreciated anyway)";
static char *str_PostVersionFailure = "This version may not work for these names";
static char *str_Yes = "Yes";
static char *str_No = "No";
static char *str_BadPSName = "Bad PostScript Name";
static char *str_BadPSNameEmpty = "You must provide a name";
static char *str_BadPSNameChar = "A PostScript name may not include '()[]{}<>%/'\nIt must be entirely printable ASCII\nIt may not contain a space";
static char *str_BadPSNameNotNumber = "A PostScript name may not be a number";
static char *str_BadNumber = "Bad Number";
static char *str_NumberOutOfRange = "Number out of range\nMust be between %d and %d";
static char *str_BinaryEdit = "Edited with Binary Editor";
static char *str_BinaryEditSave = "This table has been edited with\nthe binary editor. You must save\nthe font before you can edit it\nhere.";
    /* cvt table (shorts) */
static char *str_RetainChanges = "Retain Changes?";
static char *str_BadNumberCloseAnyway = "Bad Number, Close Anyway?";
    /* ttfsave */
static char *str_NoBackup="Couldn't create backup file";
static char *str_CouldntWriteBackup="Couldnt Write Backup File";
static char *str_CouldntReopenFile="Couldn't open ttf file";
static char *str_CantCreate="Can't create file";
static char *str_CantCreateFile="Can't create file: %.100hs";
static char *str_SaveFailed="Save Failed!";
static char *str_SaveFailedOn="Attempt to save %.100hs failed.";
static char *str_CantRecoverFromSave="Can't recover from failed save.";
    /* gasp */
static char *str_Count = "Count:";
static char *str_GridFit = "GridFit";
static char *str_AntiAlias = "AntiAlias";
static char *str_BadInteger = "Bad Integer";
    /* VORG */
static char *str_Minor = "Minor:";
static char *str_DefYOrig = "Default Y Origin:";
static char *str_AddOrig = "Additional Origins:";
    /* fontview */
static char *str_CouldntReadGlyphs = "Couldn't read glyphs";
    /* charview */
static char *str_CouldntReadGlyph = "Couldn't read glyph";
static char *str_CouldntReadGlyphd = "Couldn't read glyph %d";
    /* instrmod.c */
static char *str_Pushes = "Pushes";
static char *str_UBytes = "Unsigned Bytes";
static char *str_Shorts = "Signed Shorts";
static char *str_Stack = "Stack Manipulation";
static char *str_StorageOps = "Storage Ops.";
static char *str_Unary = "Unary Ops.";
static char *str_Binary = "Binary Ops.";
static char *str_Logical = "Logical Ops.";
static char *str_Conditional = "Conditional Ops.";
static char *str_Routines = "Functions";
static char *str_Vectors = "Vectors";
static char *str_SetState = "Set State";
static char *str_SetRegisters = "Set Registers";
static char *str_GetInfo = "Get Info";
static char *str_PointState = "PointState";
static char *str_MovePoints = "MovePoints";
static char *str_MDRP = "MDRP";
static char *str_MIRP = "MIRP";
static char *str_Deltas = "Deltas";
static char *str_NoInstruction = "No Instruction";
static char *str_CouldntParseInstr = "Couldn't Parse Instruction: %s";
static char *str_ValueOutOfBounds = "Value Out Of Bounds";
static char *str_ValueMustBeShort = "Value must be between -32768 and 32767";


static int num_buttonsize = 55;
static int num_ScaleFactor = 100;
