/*
 * Copyright (C) 2002  Bogdan Surdu (tim@rdsnet.ro)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Revision: 1.1 $
 *
 * $Log: flow.h,v $
 * Revision 1.1  2002/11/24 23:13:41  tim
 * Initial revision
 *
 *
 */
#ifndef _FLOW_H
#define _FLOW_H

#define SWAPINT32(y) y =  ((((y)&0xff)<<24) | (((y)&0xff00)<<8) | (((y)&0xff0000)>>8) | (((y)>>24)&0xff));

#define SWAPINT16(y) y = ( (((y)&0xff)<<8) | (((y)&0xff00)>>8) );

#define	MAXFLOWS_V5	30

struct flow_pdu_v5 {
  /* 24 byte header */
  unsigned short version;     /* 5 */
  unsigned short count;       /* The number of records in the PDU */
  unsigned int sysUpTime;     /* Current time in millisecs since router booted */
  unsigned int unix_secs;     /* Current seconds since 0000 UTC 1970 */
  unsigned int unix_nsecs;    /* Residual nanoseconds since 0000 UTC 1970 */
  unsigned int flow_sequence; /* Seq counter of total flows seen */
  unsigned int reserved;

 /* 48 byte payload */
  struct flow_rec_v5 {
    unsigned int srcaddr;     /* Source IP Address */
    unsigned int dstaddr;     /* Destination IP Address */
    unsigned int nexthop;     /* Next hop router's IP Address */
    unsigned short input;     /* Input interface index */
    unsigned short output;    /* Output interface index */

    unsigned int dPkts;       /* Packets sent in Duration */
    unsigned int dOctets;     /* Octets sent in Duration. */
    unsigned int First;       /* SysUptime at start of flow */
    unsigned int Last;        /* and of last packet of flow */

    unsigned short srcport;   /* TCP/UDP source port number or equivalent */
    unsigned short dstport;   /* TCP/UDP destination port number or equiv */
    unsigned char  pad;
    unsigned char  tcp_flags; /* Cumulative OR of tcp flags */
    unsigned char  prot;      /* IP protocol, e.g., 6=TCP, 17=UDP, ... */
    unsigned char  tos;       /* IP Type-of-Service */
    unsigned short src_as;    /* originating AS of source address */
    unsigned short dst_as;    /* originating AS of destination address */
    unsigned char  src_mask;  /* source address prefix mask bits */
    unsigned char  dst_mask;  /* destination address prefix mask bits */
    unsigned short drops;
  } records[MAXFLOWS_V5];
};

#endif
