/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef DRAWINGLINE_H
#define DRAWINGLINE_H

#include <qcanvas.h>
#include <qpainter.h>
#include <iostream>
#include "defs.h"

/**
@author Predrag Viceic
*/
class DrawingLine : public QCanvasPolygon
{
public:
    DrawingLine(QCanvas*);

    ~DrawingLine();
    void setStartPoint(int,int);
    void setEndPoint(int,int);
    QPoint getStartPoint();
    QPoint getEndPoint();
    QPointArray areaPoints () const;
    QRect boundingRect();
    int rtti() const;
    int getYAtX(int);
    void setEndSample(long e);
    void setStartSample(long s);
    float getValueAtSample(long sample);
    void setEndValue(float ev);
    void setStartValue(float sv);

protected:
    void drawShape ( QPainter & p );

protected:
    long end_sample;
    long start_sample;
    float startValue;
    float endValue;
};

#endif
