/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "ladspavalueview.h"

LADSPAValueView::LADSPAValueView(QCanvas* canvas)
 : QCanvasRectangle(canvas)
{
    value=0;
    rectheight=20;
    rectwidth=20;
    setSize(rectwidth,rectheight);
    localFont=new QFont();
    localFont->setPixelSize(15);
    setZ(10);
}


LADSPAValueView::~LADSPAValueView()
{
    hide();
}






/*!
    \fn LADSPAValueView::setValue(float val)
 */
void LADSPAValueView::setValue(float val)
{
    value=val;
    QFontMetrics fmetrics(*localFont);
    rectwidth=fmetrics.width(QString::number(value))+4;
    setSize(rectwidth,rectheight);
}


/*!
    \fn LADSPAValueView::setY(double y)
 */
void LADSPAValueView::setY(double y)
{
    int y2=int(y<0?0:y>canvas()->height()-rectheight?canvas()->height()-rectheight:y);
    QCanvasRectangle::setY(y2);
}


/*!
    \fn LADSPAValueView::setX(double x)
 */
void LADSPAValueView::setX(double x)
{
    int v_width=((ControllerCanvas*)canvas())->getVisibleWidth();
    int startx=((ControllerCanvas*)canvas())->getStartX();
    int x2=int(x>v_width-startx-rectwidth?x-rectwidth:x<0?0:x);
    QCanvasRectangle::setX(x2);
}


/*!
    \fn LADSPAValueView::drawShape(QPainter & p)
 */
void LADSPAValueView::drawShape(QPainter & p)
{
    QPen oldpen=p.pen();
    p.setPen(QPen(gray,2));
    p.fillRect(rect(),QBrush(lightGray));
    p.drawRect(rect());
    p.setFont(*localFont);
    p.setPen(QPen(QColor(50,50,50),2));
    p.drawText(rect(),Qt::AlignHCenter|Qt::AlignVCenter,QString::number(value));
    p.setPen(oldpen);
}


/*!
    \fn LADSPAValueView::rtti() const
 */
int LADSPAValueView::rtti() const
{
    return RTTI_LADSPAVALUERECT;
}
