/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "myopenfiledialog.h"

MyOpenFileDialog::MyOpenFileDialog(SoundManager* sm,SoundPlayer* sp, FileManager* fm,
                                                            QWidget *parent, const char *name)
 : QFileDialog(parent, name,TRUE)
{

    addFilter("*.wav , *.WAV , *.aiff , *.AIFF , *.aif ");
    addFilter(" *.au , *.snd , *.raw , *.iff ");
    addFilter(" *.swx , *.voc, *.w64 , *.pvf ");
    setSelectedFilter(1);
    soundFilePreview=new SoundFilePreview(sm,sp,fm,this);
    setContentsPreviewEnabled( TRUE );
    setContentsPreview( soundFilePreview, soundFilePreview );
    setPreviewMode( QFileDialog::Contents );
    installEventFilter (this);
}


MyOpenFileDialog::~MyOpenFileDialog()
{
}

int MyOpenFileDialog::exec()
{
    rereadDir();
    soundFilePreview->init();
    return QFileDialog::exec();
}


bool MyOpenFileDialog::eventFilter (QObject* /*watched_object*/, QEvent* e)
{
    if (e->type () == QEvent::KeyPress)
    {
        QKeyEvent* k = (QKeyEvent*) e;
        if (k->key () == Qt::Key_Space && !k->isAutoRepeat() && !soundFilePreview->getPlaying()){
            //process here
            if(soundFilePreview)
                soundFilePreview->play();
            return true;
        }
    }
    else if (e->type () == QEvent::KeyRelease)
    {
        QKeyEvent* k = (QKeyEvent*) e;
        if (k->key () == Qt::Key_Space && !k->isAutoRepeat() && soundFilePreview->getPlaying()){
            //process here
            if(soundFilePreview)
                soundFilePreview->stop();
            return true;
        }
    }
    return false;
}

void MyOpenFileDialog::done ( int r ){
    soundFilePreview->stop();
    if(r==QDialog::Accepted && soundFilePreview->getIsFileOk()) QFileDialog::done(r);
    else if(r==QDialog::Rejected )QFileDialog::done(r);
}





