package freenet;
import freenet.crypt.CryptoKey;
import freenet.crypt.CryptoElement;
import java.math.BigInteger;
/**
 * An interface for the Authentication elements (private keys) in Freenet nodes
 *
 * I'm not sure what methods it needs yet...
 *
 * @author oskar
 */

public interface Authentity {

    /**
     * Returns the signature of the byte digest.
     */
    CryptoElement sign(byte[] digest);

    CryptoElement sign(BigInteger b);

    /**
     * Get a FieldSet containing hex encodings of the primitives.
     */
    FieldSet getFieldSet();

    /**
     * Returns the Cryptographic private key of this authentity 
     */
    CryptoKey getKey();

    /** @return the appropriate Identity for this Authentity
      */
    Identity getIdentity();
}
