package freenet;
import freenet.support.*;
import freenet.session.*;
import java.util.Enumeration;
import java.util.Hashtable;

public class PresentationHandler {

    private Hashtable presentations;
    private Selector select;

    public PresentationHandler() {
        presentations = new Hashtable();
        select = new Selector();
    }

    public void register(Presentation p, int pref) {
        presentations.put(new Integer(p.designatorNum()),p);
        select.register(p, pref);
    }

    public Enumeration getPresentations() {
        return select.getSelections();
    }

    public Presentation get(int num) {
        return (Presentation) presentations.get(new Integer(num));
    }

    public int size() {
        return select.size();
    }
}
