package freenet;

/**
 * Instances of this class describe Transport protocols available to 
 * Freenet.
 */

public interface Transport {

    String getName();

    /**
     * The preference weight of this transport. 
     * Transports with higher pref will be prefered
     * over ones with lower.
     */
    int preference();

    /**
     * Constructs a new address for this transport from string s
     */
    Address getAddress(String s) throws BadAddressException;

    /**
     * Constructs a new listening address for this transport from string s
     */
    ListeningAddress getListeningAddress(String s) throws BadAddressException;
}
